/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.ColumnDefinition;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import coral.shading.io.trino.sql.tree.QualifiedName;
import coral.shading.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class AddColumn
extends Statement {
    private final QualifiedName name;
    private final ColumnDefinition column;
    private final boolean tableExists;
    private final boolean columnNotExists;

    public AddColumn(QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        this(Optional.empty(), name, column, tableExists, columnNotExists);
    }

    public AddColumn(NodeLocation location, QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        this(Optional.of(location), name, column, tableExists, columnNotExists);
    }

    private AddColumn(Optional<NodeLocation> location, QualifiedName name, ColumnDefinition column, boolean tableExists, boolean columnNotExists) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.column = Objects.requireNonNull(column, "column is null");
        this.tableExists = tableExists;
        this.columnNotExists = columnNotExists;
    }

    public QualifiedName getName() {
        return this.name;
    }

    public ColumnDefinition getColumn() {
        return this.column;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnNotExists() {
        return this.columnNotExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAddColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.column);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.column);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AddColumn o = (AddColumn)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.column, o.column);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("column", this.column).toString();
    }
}

