/*
 * Decompiled with CFR 0.152.
 */
package coral.shading.io.trino.sql.tree;

import coral.shading.com.google.common.base.MoreObjects;
import coral.shading.com.google.common.collect.ImmutableList;
import coral.shading.io.trino.sql.tree.AstVisitor;
import coral.shading.io.trino.sql.tree.Expression;
import coral.shading.io.trino.sql.tree.Node;
import coral.shading.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SortItem
extends Node {
    private final Expression sortKey;
    private final Ordering ordering;
    private final NullOrdering nullOrdering;

    public SortItem(Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this(Optional.empty(), sortKey, ordering, nullOrdering);
    }

    public SortItem(NodeLocation location, Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this(Optional.of(location), sortKey, ordering, nullOrdering);
    }

    private SortItem(Optional<NodeLocation> location, Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        super(location);
        this.ordering = ordering;
        this.sortKey = sortKey;
        this.nullOrdering = nullOrdering;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSortItem(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of(this.sortKey);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("sortKey", this.sortKey).add("ordering", (Object)this.ordering).add("nullOrdering", (Object)this.nullOrdering).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return Objects.equals(this.sortKey, sortItem.sortKey) && this.ordering == sortItem.ordering && this.nullOrdering == sortItem.nullOrdering;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering, this.nullOrdering});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!SortItem.sameClass(this, other)) {
            return false;
        }
        SortItem otherItem = (SortItem)other;
        return this.ordering == otherItem.ordering && this.nullOrdering == otherItem.nullOrdering;
    }

    public static enum NullOrdering {
        FIRST,
        LAST,
        UNDEFINED;

    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }
}

