/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.plugin.hive.HiveCompressionCodec;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTimeZone;

@DefunctConfig(value={"delta.experimental.ignore-checkpoint-write-failures"})
public class DeltaLakeConfig {
    public static final String VACUUM_MIN_RETENTION = "delta.vacuum.min-retention";
    @VisibleForTesting
    static final DataSize DEFAULT_DATA_FILE_CACHE_SIZE = DataSize.succinctBytes((long)Math.floorDiv(Runtime.getRuntime().maxMemory(), 10L));
    private Duration metadataCacheTtl = new Duration(5.0, TimeUnit.MINUTES);
    private DataSize dataFileCacheSize = DEFAULT_DATA_FILE_CACHE_SIZE;
    private Duration dataFileCacheTtl = new Duration(30.0, TimeUnit.MINUTES);
    private int domainCompactionThreshold = 100;
    private int maxOutstandingSplits = 1000;
    private int maxSplitsPerSecond = Integer.MAX_VALUE;
    private int maxInitialSplits = 200;
    private DataSize maxInitialSplitSize;
    private DataSize maxSplitSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private double minimumAssignedSplitWeight = 0.05;
    private int maxPartitionsPerWriter = 100;
    private boolean unsafeWritesEnabled;
    private boolean checkpointRowStatisticsWritingEnabled = true;
    private long defaultCheckpointWritingInterval = 10L;
    private Duration vacuumMinRetention = new Duration(7.0, TimeUnit.DAYS);
    private Optional<String> hiveCatalogName = Optional.empty();
    private Duration dynamicFilteringWaitTimeout = new Duration(0.0, TimeUnit.SECONDS);
    private boolean tableStatisticsEnabled = true;
    private boolean extendedStatisticsEnabled = true;
    private HiveCompressionCodec compressionCodec = HiveCompressionCodec.SNAPPY;
    private long perTransactionMetastoreCacheMaximumSize = 1000L;
    private boolean deleteSchemaLocationsFallback;
    private String parquetTimeZone = TimeZone.getDefault().getID();
    private DataSize targetMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean uniqueTableLocation = true;

    public Duration getMetadataCacheTtl() {
        return this.metadataCacheTtl;
    }

    @Config(value="delta.metadata.cache-ttl")
    @ConfigDescription(value="Caching duration for Delta table metadata (e.g. table schema, partition info)")
    public DeltaLakeConfig setMetadataCacheTtl(Duration metadataCacheTtl) {
        this.metadataCacheTtl = metadataCacheTtl;
        return this;
    }

    public DataSize getDataFileCacheSize() {
        return this.dataFileCacheSize;
    }

    @Config(value="delta.metadata.live-files.cache-size")
    @ConfigDescription(value="Maximum in memory cache size for Delta data file metadata (e.g. file path, statistics, partition values). Defaults to 10% of the available heap size.")
    public DeltaLakeConfig setDataFileCacheSize(DataSize dataFileCacheSize) {
        this.dataFileCacheSize = dataFileCacheSize;
        return this;
    }

    @NotNull
    public Duration getDataFileCacheTtl() {
        return this.dataFileCacheTtl;
    }

    @Config(value="delta.metadata.live-files.cache-ttl")
    @ConfigDescription(value="Caching duration for Delta data file metadata (e.g. table schema, partition info)")
    public DeltaLakeConfig setDataFileCacheTtl(Duration dataFileCacheTtl) {
        this.dataFileCacheTtl = dataFileCacheTtl;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDomainCompactionThreshold() {
        return this.domainCompactionThreshold;
    }

    @Config(value="delta.domain-compaction-threshold")
    @ConfigDescription(value="Maximum ranges to allow in a tuple domain without compacting it")
    public DeltaLakeConfig setDomainCompactionThreshold(int domainCompactionThreshold) {
        this.domainCompactionThreshold = domainCompactionThreshold;
        return this;
    }

    public int getMaxOutstandingSplits() {
        return this.maxOutstandingSplits;
    }

    @Config(value="delta.max-outstanding-splits")
    @ConfigDescription(value="Target number of buffered splits for each table scan in a query, before the scheduler tries to pause itself")
    public DeltaLakeConfig setMaxOutstandingSplits(int maxOutstandingSplits) {
        this.maxOutstandingSplits = maxOutstandingSplits;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxSplitsPerSecond() {
        return this.maxSplitsPerSecond;
    }

    @Config(value="delta.max-splits-per-second")
    @ConfigDescription(value="Throttles the maximum number of splits that can be assigned to tasks per second")
    public DeltaLakeConfig setMaxSplitsPerSecond(int maxSplitsPerSecond) {
        this.maxSplitsPerSecond = maxSplitsPerSecond;
        return this;
    }

    public int getMaxInitialSplits() {
        return this.maxInitialSplits;
    }

    @Config(value="delta.max-initial-splits")
    public DeltaLakeConfig setMaxInitialSplits(int maxInitialSplits) {
        this.maxInitialSplits = maxInitialSplits;
        return this;
    }

    @NotNull
    public DataSize getMaxInitialSplitSize() {
        if (this.maxInitialSplitSize == null) {
            return DataSize.ofBytes((long)(this.maxSplitSize.toBytes() / 2L)).to(this.maxSplitSize.getUnit());
        }
        return this.maxInitialSplitSize;
    }

    @Config(value="delta.max-initial-split-size")
    public DeltaLakeConfig setMaxInitialSplitSize(DataSize maxInitialSplitSize) {
        this.maxInitialSplitSize = maxInitialSplitSize;
        return this;
    }

    @NotNull
    public DataSize getMaxSplitSize() {
        return this.maxSplitSize;
    }

    @Config(value="delta.max-split-size")
    public DeltaLakeConfig setMaxSplitSize(DataSize maxSplitSize) {
        this.maxSplitSize = maxSplitSize;
        return this;
    }

    @Config(value="delta.minimum-assigned-split-weight")
    @ConfigDescription(value="Minimum weight that a split can be assigned")
    public DeltaLakeConfig setMinimumAssignedSplitWeight(double minimumAssignedSplitWeight) {
        this.minimumAssignedSplitWeight = minimumAssignedSplitWeight;
        return this;
    }

    @DecimalMax(value="1")
    @DecimalMin(value="0", inclusive=false)
    public @DecimalMax(value="1") @DecimalMin(value="0", inclusive=false) double getMinimumAssignedSplitWeight() {
        return this.minimumAssignedSplitWeight;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxPartitionsPerWriter() {
        return this.maxPartitionsPerWriter;
    }

    @Config(value="delta.max-partitions-per-writer")
    @ConfigDescription(value="Maximum number of partitions per writer")
    public DeltaLakeConfig setMaxPartitionsPerWriter(int maxPartitionsPerWriter) {
        this.maxPartitionsPerWriter = maxPartitionsPerWriter;
        return this;
    }

    public boolean getUnsafeWritesEnabled() {
        return this.unsafeWritesEnabled;
    }

    @Config(value="delta.enable-non-concurrent-writes")
    public DeltaLakeConfig setUnsafeWritesEnabled(boolean unsafeWritesEnabled) {
        this.unsafeWritesEnabled = unsafeWritesEnabled;
        return this;
    }

    @Config(value="delta.default-checkpoint-writing-interval")
    @ConfigDescription(value="How often (in number of transactions) to write checkpoint of transaction log")
    public DeltaLakeConfig setDefaultCheckpointWritingInterval(long defaultCheckpointWritingInterval) {
        this.defaultCheckpointWritingInterval = defaultCheckpointWritingInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getDefaultCheckpointWritingInterval() {
        return this.defaultCheckpointWritingInterval;
    }

    @NotNull
    public Duration getVacuumMinRetention() {
        return this.vacuumMinRetention;
    }

    @Config(value="delta.vacuum.min-retention")
    @ConfigDescription(value="Minimal retention period for vacuum procedure")
    public DeltaLakeConfig setVacuumMinRetention(Duration vacuumMinRetention) {
        this.vacuumMinRetention = vacuumMinRetention;
        return this;
    }

    public Optional<String> getHiveCatalogName() {
        return this.hiveCatalogName;
    }

    @Config(value="delta.hive-catalog-name")
    @ConfigDescription(value="Catalog to redirect to when a Hive table is referenced")
    public DeltaLakeConfig setHiveCatalogName(String hiveCatalogName) {
        this.hiveCatalogName = Optional.ofNullable(hiveCatalogName);
        return this;
    }

    public boolean isCheckpointRowStatisticsWritingEnabled() {
        return this.checkpointRowStatisticsWritingEnabled;
    }

    @Config(value="delta.checkpoint-row-statistics-writing.enabled")
    public DeltaLakeConfig setCheckpointRowStatisticsWritingEnabled(boolean checkpointRowStatisticsWritingEnabled) {
        this.checkpointRowStatisticsWritingEnabled = checkpointRowStatisticsWritingEnabled;
        return this;
    }

    @NotNull
    public Duration getDynamicFilteringWaitTimeout() {
        return this.dynamicFilteringWaitTimeout;
    }

    @Config(value="delta.dynamic-filtering.wait-timeout")
    @ConfigDescription(value="Duration to wait for completion of dynamic filters during split generation")
    public DeltaLakeConfig setDynamicFilteringWaitTimeout(Duration dynamicFilteringWaitTimeout) {
        this.dynamicFilteringWaitTimeout = dynamicFilteringWaitTimeout;
        return this;
    }

    public boolean isTableStatisticsEnabled() {
        return this.tableStatisticsEnabled;
    }

    @Config(value="delta.table-statistics-enabled")
    @ConfigDescription(value="Expose table statistics")
    public DeltaLakeConfig setTableStatisticsEnabled(boolean tableStatisticsEnabled) {
        this.tableStatisticsEnabled = tableStatisticsEnabled;
        return this;
    }

    public boolean isExtendedStatisticsEnabled() {
        return this.extendedStatisticsEnabled;
    }

    @Config(value="delta.extended-statistics.enabled")
    @ConfigDescription(value="Use extended statistics collected by ANALYZE")
    public DeltaLakeConfig setExtendedStatisticsEnabled(boolean extendedStatisticsEnabled) {
        this.extendedStatisticsEnabled = extendedStatisticsEnabled;
        return this;
    }

    @NotNull
    public HiveCompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    @Config(value="delta.compression-codec")
    @ConfigDescription(value="Compression codec to use when writing new data files")
    public DeltaLakeConfig setCompressionCodec(HiveCompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) long getPerTransactionMetastoreCacheMaximumSize() {
        return this.perTransactionMetastoreCacheMaximumSize;
    }

    @LegacyConfig(value={"hive.per-transaction-metastore-cache-maximum-size"})
    @Config(value="delta.per-transaction-metastore-cache-maximum-size")
    public DeltaLakeConfig setPerTransactionMetastoreCacheMaximumSize(long perTransactionMetastoreCacheMaximumSize) {
        this.perTransactionMetastoreCacheMaximumSize = perTransactionMetastoreCacheMaximumSize;
        return this;
    }

    public boolean isDeleteSchemaLocationsFallback() {
        return this.deleteSchemaLocationsFallback;
    }

    @Config(value="delta.delete-schema-locations-fallback")
    @ConfigDescription(value="Whether schema locations should be deleted when Trino can't determine whether they contain external files.")
    public DeltaLakeConfig setDeleteSchemaLocationsFallback(boolean deleteSchemaLocationsFallback) {
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        return this;
    }

    public DateTimeZone getParquetDateTimeZone() {
        return DateTimeZone.forID((String)this.parquetTimeZone);
    }

    @NotNull
    public String getParquetTimeZone() {
        return this.parquetTimeZone;
    }

    @LegacyConfig(value={"hive.parquet.time-zone"})
    @Config(value="delta.parquet.time-zone")
    @ConfigDescription(value="Time zone for Parquet read and write")
    public DeltaLakeConfig setParquetTimeZone(String parquetTimeZone) {
        this.parquetTimeZone = parquetTimeZone;
        return this;
    }

    @NotNull
    public DataSize getTargetMaxFileSize() {
        return this.targetMaxFileSize;
    }

    @Config(value="delta.target-max-file-size")
    @ConfigDescription(value="Target maximum size of written files; the actual size may be larger")
    public DeltaLakeConfig setTargetMaxFileSize(DataSize targetMaxFileSize) {
        this.targetMaxFileSize = targetMaxFileSize;
        return this;
    }

    public boolean isUniqueTableLocation() {
        return this.uniqueTableLocation;
    }

    @Config(value="delta.unique-table-location")
    @ConfigDescription(value="Use randomized, unique table locations")
    public DeltaLakeConfig setUniqueTableLocation(boolean uniqueTableLocation) {
        this.uniqueTableLocation = uniqueTableLocation;
        return this;
    }
}

