/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.trino.plugin.deltalake.DeltaLakeBucketFunction;
import io.trino.plugin.deltalake.DeltaLakePartitioningHandle;
import io.trino.plugin.deltalake.DeltaLakeUpdateBucketFunction;
import io.trino.plugin.deltalake.DeltaLakeUpdateHandle;
import io.trino.spi.connector.BucketFunction;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import java.util.List;
import javax.inject.Inject;

public class DeltaLakeNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final TypeOperators typeOperators;

    @Inject
    public DeltaLakeNodePartitioningProvider(TypeManager typeManager) {
        this.typeOperators = typeManager.getTypeOperators();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        if (partitioningHandle instanceof DeltaLakeUpdateHandle) {
            return new DeltaLakeUpdateBucketFunction(bucketCount);
        }
        DeltaLakePartitioningHandle handle = (DeltaLakePartitioningHandle)partitioningHandle;
        return new DeltaLakeBucketFunction(this.typeOperators, handle.getPartitioningColumns(), bucketCount);
    }
}

