/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.HiveTypeName;
import io.trino.plugin.hive.metastore.Database;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;

public class DeltaLakeSchemaProperties {
    public static final String LOCATION_PROPERTY = "location";
    public static final List<PropertyMetadata<?>> SCHEMA_PROPERTIES = ImmutableList.of((Object)PropertyMetadata.stringProperty((String)"location", (String)"URI for the default location to store tables created in this schema", null, (boolean)false));

    private DeltaLakeSchemaProperties() {
    }

    public static Map<String, Object> fromDatabase(Database db) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        db.getLocation().ifPresent(location -> result.put((Object)LOCATION_PROPERTY, location));
        return result.buildOrThrow();
    }

    public static Optional<String> getLocation(Map<String, Object> schemaProperties) {
        return Optional.ofNullable((String)schemaProperties.get(LOCATION_PROPERTY));
    }

    public static Properties buildHiveSchema(List<String> columnNames, List<Type> columnTypes) {
        Properties schema = new Properties();
        schema.setProperty("columns", String.join((CharSequence)",", columnNames));
        schema.setProperty("columns.types", columnTypes.stream().map(DeltaHiveTypeTranslator::toHiveType).map(HiveType::getHiveTypeName).map(HiveTypeName::toString).collect(Collectors.joining(":")));
        return schema;
    }
}

