/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class NoIsolationSynchronizer
implements TransactionLogSynchronizer {
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public NoIsolationSynchronizer(TrinoFileSystemFactory fileSystemFactory) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Path newLogEntryPath, byte[] entryContents) throws UncheckedIOException {
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            TrinoOutputFile outputFile = fileSystem.newOutputFile(newLogEntryPath.toString());
            try (OutputStream outputStream = outputFile.create();){
                outputStream.write(entryContents);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return true;
    }
}

