/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.statistics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.CanonicalColumnName;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class DeltaLakeJsonFileStatistics
implements DeltaLakeFileStatistics {
    private static final Logger log = Logger.get(DeltaLakeJsonFileStatistics.class);
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(DeltaLakeJsonFileStatistics.class).instanceSize();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    private final Optional<Long> numRecords;
    private final Optional<Map<CanonicalColumnName, Object>> minValues;
    private final Optional<Map<CanonicalColumnName, Object>> maxValues;
    private final Optional<Map<CanonicalColumnName, Object>> nullCount;

    public static DeltaLakeJsonFileStatistics create(String jsonStatistics) throws JsonProcessingException {
        return (DeltaLakeJsonFileStatistics)JsonUtils.parseJson((ObjectMapper)OBJECT_MAPPER, (String)jsonStatistics, DeltaLakeJsonFileStatistics.class);
    }

    @JsonCreator
    public DeltaLakeJsonFileStatistics(@JsonProperty(value="numRecords") Optional<Long> numRecords, @JsonProperty(value="minValues") Optional<Map<String, Object>> minValues, @JsonProperty(value="maxValues") Optional<Map<String, Object>> maxValues, @JsonProperty(value="nullCount") Optional<Map<String, Object>> nullCount) {
        this.numRecords = numRecords;
        Map<String, CanonicalColumnName> canonicalColumnNames = DeltaLakeFileStatistics.getCanonicalColumnNames(minValues, maxValues, nullCount);
        this.minValues = minValues.map(minValuesMap -> TransactionLogAccess.toCanonicalNameKeyedMap(minValuesMap, canonicalColumnNames));
        this.maxValues = maxValues.map(maxValuesMap -> TransactionLogAccess.toCanonicalNameKeyedMap(maxValuesMap, canonicalColumnNames));
        this.nullCount = nullCount.map(nullCountMap -> TransactionLogAccess.toCanonicalNameKeyedMap(nullCountMap, canonicalColumnNames));
    }

    @Override
    @JsonProperty
    public Optional<Long> getNumRecords() {
        return this.numRecords;
    }

    @Override
    @JsonProperty
    public Optional<Map<String, Object>> getMinValues() {
        return this.minValues.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    @Override
    @JsonProperty
    public Optional<Map<String, Object>> getMaxValues() {
        return this.maxValues.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    @Override
    @JsonProperty
    public Optional<Map<String, Object>> getNullCount() {
        return this.nullCount.map(TransactionLogAccess::toOriginalNameKeyedMap);
    }

    @Override
    public Optional<Object> getMaxColumnValue(DeltaLakeColumnHandle columnHandle) {
        Optional<Object> value = this.getStat(columnHandle.getPhysicalName(), this.maxValues);
        return value.flatMap(o -> this.deserializeStatisticsValue(columnHandle, String.valueOf(o)));
    }

    @Override
    public Optional<Object> getMinColumnValue(DeltaLakeColumnHandle columnHandle) {
        Optional<Object> value = this.getStat(columnHandle.getPhysicalName(), this.minValues);
        return value.flatMap(o -> this.deserializeStatisticsValue(columnHandle, String.valueOf(o)));
    }

    private Optional<Object> deserializeStatisticsValue(DeltaLakeColumnHandle columnHandle, String statValue) {
        long packedTimestamp;
        ZonedDateTime dateTime;
        long epochDate;
        Object columnValue = TransactionLogParser.deserializeColumnValue(columnHandle, statValue, DeltaLakeJsonFileStatistics::readStatisticsTimestamp);
        Type columnType = columnHandle.getType();
        if (columnType.equals(DateType.DATE) && LocalDate.ofEpochDay(epochDate = ((Long)columnValue).longValue()).isBefore(TransactionLogParser.START_OF_MODERN_ERA)) {
            return Optional.empty();
        }
        if (columnType instanceof TimestampWithTimeZoneType && (dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)(packedTimestamp = ((Long)columnValue).longValue()))), ZoneOffset.UTC)).toLocalDate().isBefore(TransactionLogParser.START_OF_MODERN_ERA)) {
            return Optional.empty();
        }
        return Optional.of(columnValue);
    }

    private static Long readStatisticsTimestamp(String timestamp) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(timestamp, TransactionLogParser.JSON_STATISTICS_TIMESTAMP_FORMATTER);
        return DateTimeEncoding.packDateTimeWithZone((long)zonedDateTime.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    @Override
    public Optional<Long> getNullCount(String columnName) {
        return this.getStat(columnName, this.nullCount).map(o -> Long.valueOf(o.toString()));
    }

    private Optional<Object> getStat(String columnName, Optional<Map<CanonicalColumnName, Object>> stats) {
        if (stats.isEmpty()) {
            return Optional.empty();
        }
        CanonicalColumnName canonicalColumnName = new CanonicalColumnName(columnName);
        Object contents = stats.get().get(canonicalColumnName);
        if (contents == null) {
            return Optional.empty();
        }
        if (contents instanceof List || contents instanceof Map) {
            log.debug("Skipping statistics value for column with complex value type: %s", new Object[]{columnName});
            return Optional.empty();
        }
        return Optional.of(contents);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long totalSize = INSTANCE_SIZE;
        if (this.minValues.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.minValues.get(), CanonicalColumnName::getRetainedSize, value -> SizeOf.sizeOfObjectArray((int)1));
        }
        if (this.maxValues.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.maxValues.get(), CanonicalColumnName::getRetainedSize, value -> SizeOf.sizeOfObjectArray((int)1));
        }
        if (this.nullCount.isPresent()) {
            totalSize += SizeOf.estimatedSizeOf(this.nullCount.get(), CanonicalColumnName::getRetainedSize, value -> SizeOf.sizeOfLongArray((int)1));
        }
        return totalSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeJsonFileStatistics that = (DeltaLakeJsonFileStatistics)o;
        return Objects.equals(this.numRecords, that.numRecords) && Objects.equals(this.minValues, that.minValues) && Objects.equals(this.maxValues, that.maxValues) && Objects.equals(this.nullCount, that.nullCount);
    }

    public int hashCode() {
        return Objects.hash(this.numRecords, this.minValues, this.maxValues, this.nullCount);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numRecords", this.numRecords).add("minValues", this.minValues).add("maxValues", this.maxValues).add("nullCount", this.nullCount).toString();
    }
}

