/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.HyperLogLog;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeInputInfo;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMergeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePartitioningHandle;
import io.trino.plugin.deltalake.DeltaLakeRedirectionsProvider;
import io.trino.plugin.deltalake.DeltaLakeSchemaProperties;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeTableProperties;
import io.trino.plugin.deltalake.DeltaLakeUpdateHandle;
import io.trino.plugin.deltalake.DeltaLakeUpdateResult;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableProcedureId;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriterManager;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionConflictException;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriter;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogWriterFactory;
import io.trino.plugin.hive.HiveType;
import io.trino.plugin.hive.SchemaAlreadyExistsException;
import io.trino.plugin.hive.TableAlreadyExistsException;
import io.trino.plugin.hive.metastore.Column;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HivePrincipal;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.StorageFormat;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.security.AccessControlMetadata;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorAnalyzeMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.FixedWidthType;
import io.trino.spi.type.HyperLogLogType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.metastore.TableType;

public class DeltaLakeMetadata
implements ConnectorMetadata {
    public static final Logger LOG = Logger.get(DeltaLakeMetadata.class);
    public static final String PATH_PROPERTY = "path";
    public static final StorageFormat DELTA_STORAGE_FORMAT = StorageFormat.create((String)"org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", (String)"org.apache.hadoop.mapred.SequenceFileInputFormat", (String)"org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat");
    public static final String CREATE_TABLE_AS_OPERATION = "CREATE TABLE AS SELECT";
    public static final String CREATE_TABLE_OPERATION = "CREATE TABLE";
    public static final String ADD_COLUMN_OPERATION = "ADD COLUMNS";
    public static final String INSERT_OPERATION = "WRITE";
    public static final String MERGE_OPERATION = "MERGE";
    public static final String DELETE_OPERATION = "DELETE";
    public static final String UPDATE_OPERATION = "UPDATE";
    public static final String OPTIMIZE_OPERATION = "OPTIMIZE";
    public static final String SET_TBLPROPERTIES_OPERATION = "SET TBLPROPERTIES";
    public static final String CHANGE_COLUMN_OPERATION = "CHANGE COLUMN";
    public static final String ISOLATION_LEVEL = "WriteSerializable";
    private static final int READER_VERSION = 1;
    private static final int WRITER_VERSION = 2;
    private static final int MAX_WRITER_VERSION = 4;
    private static final ProtocolEntry DEFAULT_PROTOCOL = new ProtocolEntry(1, 2);
    private static final List<Column> DUMMY_DATA_COLUMNS = ImmutableList.of((Object)new Column("col", HiveType.toHiveType((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType())), Optional.empty()));
    private static final Set<ColumnStatisticType> SUPPORTED_STATISTICS_TYPE = ImmutableSet.builder().add((Object)ColumnStatisticType.TOTAL_SIZE_IN_BYTES).add((Object)ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY).build();
    private final DeltaLakeMetastore metastore;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final TypeManager typeManager;
    private final AccessControlMetadata accessControlMetadata;
    private final CheckpointWriterManager checkpointWriterManager;
    private final long defaultCheckpointInterval;
    private final int domainCompactionThreshold;
    private final boolean unsafeWritesEnabled;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final TransactionLogWriterFactory transactionLogWriterFactory;
    private final String nodeVersion;
    private final String nodeId;
    private final AtomicReference<Runnable> rollbackAction = new AtomicReference();
    private final DeltaLakeRedirectionsProvider deltaLakeRedirectionsProvider;
    private final ExtendedStatisticsAccess statisticsAccess;
    private final boolean deleteSchemaLocationsFallback;
    private final boolean useUniqueTableLocation;
    private final boolean allowManagedTableRename;

    public DeltaLakeMetadata(DeltaLakeMetastore metastore, TrinoFileSystemFactory fileSystemFactory, HdfsEnvironment hdfsEnvironment, TypeManager typeManager, AccessControlMetadata accessControlMetadata, int domainCompactionThreshold, boolean unsafeWritesEnabled, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeUpdateResult> updateResultJsonCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, TransactionLogWriterFactory transactionLogWriterFactory, NodeManager nodeManager, CheckpointWriterManager checkpointWriterManager, long defaultCheckpointInterval, boolean deleteSchemaLocationsFallback, DeltaLakeRedirectionsProvider deltaLakeRedirectionsProvider, ExtendedStatisticsAccess statisticsAccess, boolean useUniqueTableLocation, boolean allowManagedTableRename) {
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.accessControlMetadata = Objects.requireNonNull(accessControlMetadata, "accessControlMetadata is null");
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.unsafeWritesEnabled = unsafeWritesEnabled;
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        this.updateResultJsonCodec = Objects.requireNonNull(updateResultJsonCodec, "updateResultJsonCodec is null");
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.transactionLogWriterFactory = Objects.requireNonNull(transactionLogWriterFactory, "transactionLogWriterFactory is null");
        this.nodeVersion = nodeManager.getCurrentNode().getVersion();
        this.nodeId = nodeManager.getCurrentNode().getNodeIdentifier();
        this.checkpointWriterManager = Objects.requireNonNull(checkpointWriterManager, "checkpointWriterManager is null");
        this.defaultCheckpointInterval = defaultCheckpointInterval;
        this.deltaLakeRedirectionsProvider = Objects.requireNonNull(deltaLakeRedirectionsProvider, "deltaLakeRedirectionsProvider is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.deleteSchemaLocationsFallback = deleteSchemaLocationsFallback;
        this.useUniqueTableLocation = useUniqueTableLocation;
        this.allowManagedTableRename = allowManagedTableRename;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return (List)this.metastore.getAllDatabases().stream().filter(schema -> {
            String schemaName = schema.toLowerCase(Locale.ENGLISH);
            return !schemaName.equals("information_schema") && !schemaName.equals("sys");
        }).collect(ImmutableList.toImmutableList());
    }

    private static boolean isHiveTable(Table table) {
        return !HiveUtil.isDeltaLakeTable((Table)table);
    }

    public Optional<CatalogSchemaTableName> redirectTable(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<String> targetCatalogName = DeltaLakeSessionProperties.getHiveCatalogName(session);
        if (targetCatalogName.isEmpty()) {
            return Optional.empty();
        }
        if (HiveUtil.isHiveSystemSchema((String)tableName.getSchemaName())) {
            return Optional.empty();
        }
        int metadataMarkerIndex = tableName.getTableName().lastIndexOf(36);
        SchemaTableName tableNameBase = metadataMarkerIndex == -1 ? tableName : SchemaTableName.schemaTableName((String)tableName.getSchemaName(), (String)tableName.getTableName().substring(0, metadataMarkerIndex));
        Optional table = this.metastore.getHiveMetastore().getTable(tableNameBase.getSchemaName(), tableNameBase.getTableName());
        if (table.isEmpty() || TableType.VIRTUAL_VIEW.name().equals(((Table)table.get()).getTableType())) {
            return Optional.empty();
        }
        if (DeltaLakeMetadata.isHiveTable((Table)table.get())) {
            return targetCatalogName.map(catalog -> new CatalogSchemaTableName(catalog, tableName));
        }
        return Optional.empty();
    }

    public DeltaLakeTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        Optional<Table> table = this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table.isEmpty()) {
            return null;
        }
        TableSnapshot tableSnapshot = this.metastore.getSnapshot(tableName, session);
        Optional<MetadataEntry> metadata = this.metastore.getMetadata(tableSnapshot, session);
        metadata.ifPresent(metadataEntry -> DeltaLakeSchemaSupport.verifySupportedColumnMapping(DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry)));
        return new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), this.metastore.getTableLocation(tableName, session), metadata, (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), tableSnapshot.getVersion(), false);
    }

    public SchemaTableName getSchemaTableName(ConnectorSession session, ConnectorTableHandle table) {
        return ((DeltaLakeTableHandle)table).getSchemaTableName();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties(((DeltaLakeTableHandle)tableHandle).getEnforcedPartitionConstraint().transformKeys(ColumnHandle.class::cast), Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)table;
        String location = this.metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
        Map<String, String> columnComments = DeltaLakeSchemaSupport.getColumnComments(tableHandle.getMetadataEntry());
        Map<String, Boolean> columnsNullability = DeltaLakeSchemaSupport.getColumnsNullability(tableHandle.getMetadataEntry());
        List columns = (List)this.getColumns(tableHandle.getMetadataEntry()).stream().map(column -> DeltaLakeMetadata.getColumnMetadata(column, (String)columnComments.get(column.getName()), columnsNullability.getOrDefault(column.getName(), true))).collect(ImmutableList.toImmutableList());
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"location", (Object)location).put((Object)"partitioned_by", tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
        Optional<Long> checkpointInterval = tableHandle.getMetadataEntry().getCheckpointInterval();
        checkpointInterval.ifPresent(value -> properties.put((Object)"checkpoint_interval", value));
        return new ConnectorTableMetadata(tableHandle.getSchemaTableName(), columns, (Map)properties.buildOrThrow(), Optional.ofNullable(tableHandle.getMetadataEntry().getDescription()));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && schemaName.get().equals("information_schema")) {
            return ImmutableList.of();
        }
        return (List)schemaName.map(Collections::singletonList).orElseGet(() -> this.listSchemaNames(session)).stream().flatMap(schema -> this.metastore.getAllTables((String)schema).stream().map(table -> new SchemaTableName(schema, table))).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        return (Map)this.getColumns(table.getMetadataEntry()).stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::getName, Function.identity()));
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)columnHandle;
        return DeltaLakeMetadata.getColumnMetadata(column, DeltaLakeSchemaSupport.getColumnComments(table.getMetadataEntry()).get(column.getName()), DeltaLakeSchemaSupport.getColumnsNullability(table.getMetadataEntry()).getOrDefault(column.getName(), true));
    }

    public Optional<ConnectorTableLayout> getNewTableLayout(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        this.validateTableColumns(tableMetadata);
        List<String> partitionColumnNames = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Optional<ConnectorTableLayout> getInsertLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        List<String> partitionColumnNames = deltaLakeTableHandle.getMetadataEntry().getCanonicalPartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ConnectorTableLayout(partitionColumnNames));
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isPresent() && ((String)prefix.getSchema().get()).equals("information_schema")) {
            return Collections.emptyIterator();
        }
        List tables = prefix.getTable().map(ignored -> Collections.singletonList(prefix.toSchemaTableName())).orElseGet(() -> this.listTables(session, prefix.getSchema()));
        return tables.stream().flatMap(table -> {
            try {
                if (this.redirectTable(session, (SchemaTableName)table).isPresent()) {
                    return Stream.of(TableColumnsMetadata.forRedirectedTable((SchemaTableName)table));
                }
                return this.metastore.getMetadata(this.metastore.getSnapshot((SchemaTableName)table, session), session).stream().map(metadata -> {
                    Map<String, String> columnComments = DeltaLakeSchemaSupport.getColumnComments(metadata);
                    Map<String, Boolean> columnsNullability = DeltaLakeSchemaSupport.getColumnsNullability(metadata);
                    List columnMetadata = (List)this.getColumns((MetadataEntry)metadata).stream().map(column -> DeltaLakeMetadata.getColumnMetadata(column, (String)columnComments.get(column.getName()), columnsNullability.getOrDefault(column.getName(), true))).collect(ImmutableList.toImmutableList());
                    return TableColumnsMetadata.forTable((SchemaTableName)table, (List)columnMetadata);
                });
            }
            catch (NotADeltaLakeTableException e) {
                return Stream.empty();
            }
            catch (RuntimeException e) {
                LOG.debug((Throwable)e, "Ignored exception when trying to list columns from %s", new Object[]{table});
                return Stream.empty();
            }
        }).iterator();
    }

    private List<DeltaLakeColumnHandle> getColumns(MetadataEntry deltaMetadata) {
        ImmutableList.Builder columns = ImmutableList.builder();
        DeltaLakeSchemaSupport.extractSchema(deltaMetadata, this.typeManager).stream().map(column -> DeltaLakeMetadata.toColumnHandle(column.getColumnMetadata(), column.getFieldId(), column.getPhysicalName(), column.getPhysicalColumnType(), deltaMetadata.getCanonicalPartitionColumns())).forEach(arg_0 -> ((ImmutableList.Builder)columns).add(arg_0));
        columns.add((Object)DeltaLakeColumnHandle.pathColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileSizeColumnHandle());
        columns.add((Object)DeltaLakeColumnHandle.fileModifiedTimeColumnHandle());
        return columns.build();
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        if (!DeltaLakeSessionProperties.isTableStatisticsEnabled(session)) {
            return TableStatistics.empty();
        }
        return this.metastore.getTableStatistics(session, (DeltaLakeTableHandle)tableHandle);
    }

    public void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        block2: {
            Optional<String> location = DeltaLakeSchemaProperties.getLocation(properties).map(locationUri -> {
                try {
                    this.hdfsEnvironment.getFileSystem(new HdfsContext(session), new Path(locationUri));
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SCHEMA_PROPERTY, "Invalid location URI: " + locationUri, (Throwable)e);
                }
                return locationUri;
            });
            String queryId = session.getQueryId();
            Database database = Database.builder().setDatabaseName(schemaName).setLocation(location).setOwnerType(Optional.of(owner.getType())).setOwnerName(Optional.of(owner.getName())).setParameters((Map)ImmutableMap.of((Object)"presto_query_id", (Object)queryId)).build();
            Verify.verify((boolean)DeltaLakeMetadata.getQueryId(database).orElseThrow(() -> new IllegalArgumentException("Query id is not present")).equals(queryId), (String)"Database does not have correct query id set", (Object)database);
            try {
                this.metastore.createDatabase(database);
            }
            catch (SchemaAlreadyExistsException e) {
                Optional<Database> existingDatabase = this.metastore.getDatabase(schemaName);
                if (!existingDatabase.isEmpty() && DeltaLakeMetadata.isCreatedBy(existingDatabase.get(), queryId)) break block2;
                throw e;
            }
        }
    }

    public void dropSchema(ConnectorSession session, String schemaName) {
        Optional<Path> location = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName)).getLocation().map(Path::new);
        boolean deleteData = location.map(path -> {
            try {
                return !this.hdfsEnvironment.getFileSystem(new HdfsContext(session), path).listLocatedStatus(path).hasNext();
            }
            catch (IOException | RuntimeException e) {
                LOG.warn((Throwable)e, "Could not check schema directory '%s'", new Object[]{path});
                return this.deleteSchemaLocationsFallback;
            }
        }).orElse(this.deleteSchemaLocationsFallback);
        this.metastore.dropDatabase(schemaName, deleteData);
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        if (location == null) {
            String schemaLocation = this.getSchemaLocation(schema).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The 'location' property must be specified either for the table or the schema"));
            Object tableNameForLocation = tableName;
            if (this.useUniqueTableLocation) {
                tableNameForLocation = (String)tableNameForLocation + "-" + UUID.randomUUID().toString().replace("-", "");
            }
            location = new Path(schemaLocation, (String)tableNameForLocation).toString();
            this.checkPathContainsNoFiles(session, new Path(location));
            external = false;
        }
        Path targetPath = new Path(location);
        this.ensurePathExists(session, targetPath);
        Path deltaLogDirectory = TransactionLogUtil.getTransactionLogDir(targetPath);
        Optional<Long> checkpointInterval = DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties());
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), targetPath);
            if (!fileSystem.exists(deltaLogDirectory)) {
                this.validateTableColumns(tableMetadata);
                List<String> partitionColumns = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
                List deltaLakeColumns = (List)tableMetadata.getColumns().stream().map(column -> DeltaLakeMetadata.toColumnHandle(column, column.getName(), column.getType(), partitionColumns)).collect(ImmutableList.toImmutableList());
                Map columnComments = (Map)tableMetadata.getColumns().stream().filter(column -> column.getComment() != null).collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ColumnMetadata::getComment));
                Map columnsNullability = (Map)tableMetadata.getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, ColumnMetadata::isNullable));
                TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, targetPath.toString());
                DeltaLakeMetadata.appendTableEntries(0L, transactionLogWriter, UUID.randomUUID().toString(), deltaLakeColumns, partitionColumns, columnComments, columnsNullability, (Map)deltaLakeColumns.stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::getName, ignored -> ImmutableMap.of())), MetadataEntry.configurationForNewTable(checkpointInterval), CREATE_TABLE_OPERATION, session, this.nodeVersion, this.nodeId, tableMetadata.getComment(), DEFAULT_PROTOCOL);
                this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(new HdfsContext(session), this.hdfsEnvironment, deltaLogDirectory));
                transactionLogWriter.flush();
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + location, (Throwable)e);
        }
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(session.getUser())).setTableType(external ? TableType.EXTERNAL_TABLE.name() : TableType.MANAGED_TABLE.name()).setDataColumns(DUMMY_DATA_COLUMNS).setParameters(DeltaLakeMetadata.deltaTableProperties(session, location, external));
        DeltaLakeMetadata.setDeltaStorageFormat(tableBuilder, location, targetPath);
        Table table = tableBuilder.build();
        PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
        this.metastore.createTable(session, table, principalPrivileges);
    }

    private static Map<String, String> deltaTableProperties(ConnectorSession session, String location, boolean external) {
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"presto_query_id", (Object)session.getQueryId()).put((Object)"location", (Object)location).put((Object)"spark.sql.sources.provider", (Object)"DELTA").put((Object)"numFiles", (Object)"-1").put((Object)"totalSize", (Object)"-1");
        if (external) {
            properties.put((Object)"EXTERNAL", (Object)"TRUE");
        }
        return properties.buildOrThrow();
    }

    private static void setDeltaStorageFormat(Table.Builder tableBuilder, String location, Path targetPath) {
        tableBuilder.getStorageBuilder().setStorageFormat(DELTA_STORAGE_FORMAT).setSerdeParameters((Map)ImmutableMap.of((Object)PATH_PROPERTY, (Object)location)).setLocation(targetPath.toString());
    }

    private Path getExternalPath(HdfsContext context, String location) {
        try {
            Path path = new Path(location);
            if (!HiveWriteUtils.isS3FileSystem((HdfsContext)context, (HdfsEnvironment)this.hdfsEnvironment, (Path)path) && !this.hdfsEnvironment.getFileSystem(context, path).getFileStatus(path).isDirectory()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location must be a directory: " + location);
            }
            return path;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, "External location is not a valid file system URI: " + location, (Throwable)e);
        }
    }

    public DeltaLakeOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        this.validateTableColumns(tableMetadata);
        SchemaTableName schemaTableName = tableMetadata.getTable();
        String schemaName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Database schema = this.metastore.getDatabase(schemaName).orElseThrow(() -> new SchemaNotFoundException(schemaName));
        List<String> partitionedBy = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
        boolean external = true;
        String location = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        if (location == null) {
            String schemaLocation = this.getSchemaLocation(schema).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "The 'location' property must be specified either for the table or the schema"));
            Object tableNameForLocation = tableName;
            if (this.useUniqueTableLocation) {
                tableNameForLocation = (String)tableNameForLocation + "-" + UUID.randomUUID().toString().replace("-", "");
            }
            location = new Path(schemaLocation, (String)tableNameForLocation).toString();
            external = false;
        }
        Path targetPath = new Path(location);
        this.ensurePathExists(session, targetPath);
        this.checkPathContainsNoFiles(session, targetPath);
        this.setRollback(() -> DeltaLakeMetadata.deleteRecursivelyIfExists(new HdfsContext(session), this.hdfsEnvironment, targetPath));
        return new DeltaLakeOutputTableHandle(schemaName, tableName, (List)tableMetadata.getColumns().stream().map(column -> DeltaLakeMetadata.toColumnHandle(column, column.getName(), column.getType(), partitionedBy)).collect(ImmutableList.toImmutableList()), location, DeltaLakeTableProperties.getCheckpointInterval(tableMetadata.getProperties()), external, tableMetadata.getComment());
    }

    private Optional<String> getSchemaLocation(Database database) {
        Optional schemaLocation = database.getLocation();
        if (schemaLocation.isEmpty() || ((String)schemaLocation.get()).isEmpty()) {
            return Optional.empty();
        }
        return schemaLocation;
    }

    private void ensurePathExists(ConnectorSession session, Path directoryPath) {
        HdfsContext hdfsContext = new HdfsContext(session);
        if (!HiveWriteUtils.pathExists((HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath)) {
            HiveWriteUtils.createDirectory((HdfsContext)hdfsContext, (HdfsEnvironment)this.hdfsEnvironment, (Path)directoryPath);
        }
    }

    private void checkPathContainsNoFiles(ConnectorSession session, Path targetPath) {
        try {
            RemoteIterator filesIterator;
            FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), targetPath.getParent());
            if (fs.exists(targetPath) && (filesIterator = fs.listStatusIterator(targetPath)).hasNext()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Target location cannot contain any files: " + targetPath);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Unable to access file system for: " + targetPath, (Throwable)e);
        }
    }

    private void validateTableColumns(ConnectorTableMetadata tableMetadata) {
        DeltaLakeMetadata.checkPartitionColumns(tableMetadata.getColumns(), DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties()));
        this.checkColumnTypes(tableMetadata.getColumns());
    }

    private static void checkPartitionColumns(List<ColumnMetadata> columns, List<String> partitionColumnNames) {
        Set columnNames = (Set)columns.stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
        List invalidPartitionNames = (List)partitionColumnNames.stream().filter(partitionColumnName -> !columnNames.contains(partitionColumnName)).collect(ImmutableList.toImmutableList());
        if (!invalidPartitionNames.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Table property 'partition_by' contained column names which do not exist: " + invalidPartitionNames);
        }
    }

    private void checkColumnTypes(List<ColumnMetadata> columnMetadata) {
        for (ColumnMetadata column : columnMetadata) {
            Type type = column.getType();
            DeltaLakeSchemaSupport.validateType(type);
        }
    }

    private static boolean deleteRecursivelyIfExists(HdfsContext context, HdfsEnvironment hdfsEnvironment, Path path) {
        FileSystem fileSystem;
        try {
            fileSystem = hdfsEnvironment.getFileSystem(context, path);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "IOException while trying to delete '%s'", new Object[]{path});
            return false;
        }
        return DeltaLakeMetadata.deleteIfExists(fileSystem, path, true);
    }

    private static boolean deleteIfExists(FileSystem fileSystem, Path path, boolean recursive) {
        try {
            if (fileSystem.delete(path, recursive)) {
                return true;
            }
            return !fileSystem.exists(path);
        }
        catch (FileNotFoundException ignored) {
            return true;
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "IOException while trying to delete '%s'", new Object[]{path});
            return false;
        }
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeOutputTableHandle handle = (DeltaLakeOutputTableHandle)tableHandle;
        String schemaName = handle.getSchemaName();
        String tableName = handle.getTableName();
        String location = handle.getLocation();
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        Table.Builder tableBuilder = Table.builder().setDatabaseName(schemaName).setTableName(tableName).setOwner(Optional.of(session.getUser())).setTableType(handle.isExternal() ? TableType.EXTERNAL_TABLE.name() : TableType.MANAGED_TABLE.name()).setDataColumns(DUMMY_DATA_COLUMNS).setParameters(DeltaLakeMetadata.deltaTableProperties(session, location, handle.isExternal()));
        DeltaLakeMetadata.setDeltaStorageFormat(tableBuilder, location, this.getExternalPath(new HdfsContext(session), location));
        Table table = tableBuilder.build();
        String queryId = session.getQueryId();
        Verify.verify((boolean)DeltaLakeMetadata.getQueryId(table).orElseThrow(() -> new IllegalArgumentException("Query id is not present")).equals(queryId), (String)"Table does not have correct query id set", (Object)table);
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriterWithoutTransactionIsolation(session, handle.getLocation());
            DeltaLakeMetadata.appendTableEntries(0L, transactionLogWriter, UUID.randomUUID().toString(), handle.getInputColumns(), handle.getPartitionedBy(), (Map<String, String>)ImmutableMap.of(), (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::getName, ignored -> true)), (Map)handle.getInputColumns().stream().collect(ImmutableMap.toImmutableMap(DeltaLakeColumnHandle::getName, ignored -> ImmutableMap.of())), MetadataEntry.configurationForNewTable(handle.getCheckpointInterval()), CREATE_TABLE_AS_OPERATION, session, this.nodeVersion, this.nodeId, handle.getComment(), DEFAULT_PROTOCOL);
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, handle.getPartitionedBy(), true);
            transactionLogWriter.flush();
            PrincipalPrivileges principalPrivileges = MetastoreUtil.buildInitialPrivilegeSet((String)((String)table.getOwner().orElseThrow()));
            try {
                this.metastore.createTable(session, table, principalPrivileges);
            }
            catch (TableAlreadyExistsException e) {
                Optional<Table> existingTable = this.metastore.getTable(schemaName, tableName);
                if (existingTable.isEmpty() || !DeltaLakeMetadata.isCreatedBy(existingTable.get(), queryId)) {
                    throw e;
                }
            }
        }
        catch (Exception e) {
            try {
                Path transactionLogLocation = TransactionLogUtil.getTransactionLogDir(new Path(handle.getLocation()));
                FileSystem fs = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), transactionLogLocation);
                fs.delete(transactionLogLocation, true);
            }
            catch (IOException ioException) {
                LOG.error((Throwable)ioException, "Transaction log cleanup failed during CREATE TABLE rollback");
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
        return Optional.empty();
    }

    private static boolean isCreatedBy(Database database, String queryId) {
        Optional<String> databaseQueryId = DeltaLakeMetadata.getQueryId(database);
        return databaseQueryId.isPresent() && databaseQueryId.get().equals(queryId);
    }

    private static boolean isCreatedBy(Table table, String queryId) {
        Optional<String> tableQueryId = DeltaLakeMetadata.getQueryId(table);
        return tableQueryId.isPresent() && tableQueryId.get().equals(queryId);
    }

    public void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle);
        try {
            long commitVersion = handle.getReadVersion() + 1L;
            List<String> partitionColumns = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
            List columns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(column -> DeltaLakeMetadata.toColumnHandle(column, column.getName(), column.getType(), partitionColumns)).collect(ImmutableList.toImmutableList());
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            DeltaLakeMetadata.appendTableEntries(commitVersion, transactionLogWriter, handle.getMetadataEntry().getId(), columns, partitionColumns, DeltaLakeSchemaSupport.getColumnComments(handle.getMetadataEntry()), DeltaLakeSchemaSupport.getColumnsNullability(handle.getMetadataEntry()), DeltaLakeSchemaSupport.getColumnsMetadata(handle.getMetadataEntry()), handle.getMetadataEntry().getConfiguration(), SET_TBLPROPERTIES_OPERATION, session, this.nodeVersion, this.nodeId, comment, this.getProtocolEntry(session, handle.getSchemaTableName()));
            transactionLogWriter.flush();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to comment on table: %s.%s", handle.getSchemaName(), handle.getTableName()), (Throwable)e);
        }
    }

    public void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        DeltaLakeColumnHandle deltaLakeColumnHandle = (DeltaLakeColumnHandle)column;
        this.checkSupportedWriterVersion(session, deltaLakeTableHandle.getSchemaTableName());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, deltaLakeTableHandle);
        try {
            long commitVersion = deltaLakeTableHandle.getReadVersion() + 1L;
            List<String> partitionColumns = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
            List columns = (List)tableMetadata.getColumns().stream().filter(columnMetadata -> !columnMetadata.isHidden()).map(columnMetadata -> DeltaLakeMetadata.toColumnHandle(columnMetadata, columnMetadata.getName(), columnMetadata.getType(), partitionColumns)).collect(ImmutableList.toImmutableList());
            ImmutableMap.Builder columnComments = ImmutableMap.builder();
            columnComments.putAll(DeltaLakeSchemaSupport.getColumnComments(deltaLakeTableHandle.getMetadataEntry()).entrySet().stream().filter(e -> !((String)e.getKey()).equals(deltaLakeColumnHandle.getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            comment.ifPresent(s -> columnComments.put((Object)deltaLakeColumnHandle.getName(), s));
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, deltaLakeTableHandle.getLocation());
            DeltaLakeMetadata.appendTableEntries(commitVersion, transactionLogWriter, deltaLakeTableHandle.getMetadataEntry().getId(), columns, partitionColumns, (Map<String, String>)columnComments.buildOrThrow(), DeltaLakeSchemaSupport.getColumnsNullability(deltaLakeTableHandle.getMetadataEntry()), DeltaLakeSchemaSupport.getColumnsMetadata(deltaLakeTableHandle.getMetadataEntry()), deltaLakeTableHandle.getMetadataEntry().getConfiguration(), CHANGE_COLUMN_OPERATION, session, this.nodeVersion, this.nodeId, Optional.ofNullable(deltaLakeTableHandle.getMetadataEntry().getDescription()), this.getProtocolEntry(session, deltaLakeTableHandle.getSchemaTableName()));
            transactionLogWriter.flush();
        }
        catch (Exception e2) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add '%s' column comment for: %s.%s", deltaLakeColumnHandle.getName(), deltaLakeTableHandle.getSchemaName(), deltaLakeTableHandle.getTableName()), (Throwable)e2);
        }
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnMetadata newColumnMetadata) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        if (!newColumnMetadata.isNullable() && !this.metastore.getValidDataFiles(handle.getSchemaTableName(), session).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add NOT NULL column '%s' for non-empty table: %s.%s", newColumnMetadata.getName(), handle.getSchemaName(), handle.getTableName()));
        }
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle);
        try {
            long commitVersion = handle.getReadVersion() + 1L;
            List<String> partitionColumns = DeltaLakeTableProperties.getPartitionedBy(tableMetadata.getProperties());
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            columnsBuilder.addAll((Iterable)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(column -> DeltaLakeMetadata.toColumnHandle(column, column.getName(), column.getType(), partitionColumns)).collect(ImmutableList.toImmutableList()));
            columnsBuilder.add((Object)DeltaLakeMetadata.toColumnHandle(newColumnMetadata, newColumnMetadata.getName(), newColumnMetadata.getType(), partitionColumns));
            ImmutableMap.Builder columnComments = ImmutableMap.builder();
            columnComments.putAll(DeltaLakeSchemaSupport.getColumnComments(handle.getMetadataEntry()));
            if (newColumnMetadata.getComment() != null) {
                columnComments.put((Object)newColumnMetadata.getName(), (Object)newColumnMetadata.getComment());
            }
            ImmutableMap.Builder columnsNullability = ImmutableMap.builder();
            columnsNullability.putAll(DeltaLakeSchemaSupport.getColumnsNullability(handle.getMetadataEntry()));
            columnsNullability.put((Object)newColumnMetadata.getName(), (Object)newColumnMetadata.isNullable());
            ImmutableMap.Builder columnMetadata = ImmutableMap.builder();
            columnMetadata.putAll(DeltaLakeSchemaSupport.getColumnsMetadata(handle.getMetadataEntry()));
            columnMetadata.put((Object)newColumnMetadata.getName(), (Object)ImmutableMap.of());
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            DeltaLakeMetadata.appendTableEntries(commitVersion, transactionLogWriter, handle.getMetadataEntry().getId(), (List<DeltaLakeColumnHandle>)columnsBuilder.build(), partitionColumns, (Map<String, String>)columnComments.buildOrThrow(), (Map<String, Boolean>)columnsNullability.buildOrThrow(), (Map<String, Map<String, Object>>)columnMetadata.buildOrThrow(), handle.getMetadataEntry().getConfiguration(), ADD_COLUMN_OPERATION, session, this.nodeVersion, this.nodeId, Optional.ofNullable(handle.getMetadataEntry().getDescription()), this.getProtocolEntry(session, handle.getSchemaTableName()));
            transactionLogWriter.flush();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Unable to add '%s' column for: %s.%s", newColumnMetadata.getName(), handle.getSchemaName(), handle.getTableName()), (Throwable)e);
        }
    }

    private static void appendTableEntries(long commitVersion, TransactionLogWriter transactionLogWriter, String tableId, List<DeltaLakeColumnHandle> columns, List<String> partitionColumnNames, Map<String, String> columnComments, Map<String, Boolean> columnNullability, Map<String, Map<String, Object>> columnMetadata, Map<String, String> configuration, String operation, ConnectorSession session, String nodeVersion, String nodeId, Optional<String> comment, ProtocolEntry protocolEntry) {
        long createdTime = System.currentTimeMillis();
        transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), operation, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + nodeVersion + "-" + nodeId, 0L, ISOLATION_LEVEL, true));
        transactionLogWriter.appendProtocolEntry(protocolEntry);
        transactionLogWriter.appendMetadataEntry(new MetadataEntry(tableId, null, comment.orElse(null), new MetadataEntry.Format("parquet", (Map<String, String>)ImmutableMap.of()), DeltaLakeSchemaSupport.serializeSchemaAsJson(columns, columnComments, columnNullability, columnMetadata), partitionColumnNames, (Map<String, String>)ImmutableMap.copyOf(configuration), createdTime));
    }

    private static void appendAddFileEntries(TransactionLogWriter transactionLogWriter, List<DataFileInfo> dataFileInfos, List<String> partitionColumnNames, boolean dataChange) throws JsonProcessingException {
        for (DataFileInfo info : dataFileInfos) {
            HashMap<String, String> partitionValues = new HashMap<String, String>();
            for (int i = 0; i < partitionColumnNames.size(); ++i) {
                partitionValues.put(partitionColumnNames.get(i), info.getPartitionValues().get(i));
            }
            partitionValues = Collections.unmodifiableMap(partitionValues);
            transactionLogWriter.appendAddFileEntry(new AddFileEntry(DeltaLakeMetadata.toUriFormat(info.getPath()), partitionValues, info.getSize(), info.getCreationTime(), dataChange, Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(info.getStatistics())), Optional.empty(), (Map<String, String>)ImmutableMap.of()));
        }
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)tableHandle;
        if (!this.allowWrite(session, table)) {
            String fileSystem = new Path(table.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Inserts are not supported on the %s filesystem", fileSystem));
        }
        Map<String, String> columnInvariants = DeltaLakeSchemaSupport.getColumnInvariants(table.getMetadataEntry());
        if (!columnInvariants.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Inserts are not supported for tables with delta invariants");
        }
        if (!DeltaLakeSchemaSupport.getCheckConstraints(table.getMetadataEntry()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with CHECK constraints is not supported");
        }
        this.checkUnsupportedGeneratedColumns(table.getMetadataEntry());
        this.checkSupportedWriterVersion(session, table.getSchemaTableName());
        List inputColumns = (List)columns.stream().map(handle -> (DeltaLakeColumnHandle)handle).collect(ImmutableList.toImmutableList());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, table);
        this.checkAllColumnsPassedOnInsert(tableMetadata, inputColumns);
        return this.createInsertHandle(session, retryMode, table, inputColumns, tableMetadata);
    }

    private DeltaLakeInsertTableHandle createInsertHandle(ConnectorSession session, RetryMode retryMode, DeltaLakeTableHandle table, List<DeltaLakeColumnHandle> inputColumns, ConnectorTableMetadata tableMetadata) {
        String tableLocation = DeltaLakeTableProperties.getLocation(tableMetadata.getProperties());
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            return new DeltaLakeInsertTableHandle(table.getSchemaName(), table.getTableName(), tableLocation, table.getMetadataEntry(), inputColumns, TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(tableLocation)), retryMode != RetryMode.NO_RETRIES);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private void checkAllColumnsPassedOnInsert(ConnectorTableMetadata tableMetadata, List<DeltaLakeColumnHandle> insertColumns) {
        List allColumnNames = (List)tableMetadata.getColumns().stream().filter(Predicate.not(ColumnMetadata::isHidden)).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        List insertColumnNames = (List)insertColumns.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((boolean)allColumnNames.equals(insertColumnNames), (String)"Not all table columns passed on INSERT; table columns=%s; insert columns=%s", (Object)allColumnNames, (Object)insertColumnNames);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeInsertTableHandle handle = (DeltaLakeInsertTableHandle)insertHandle;
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (handle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, handle.getLocation(), dataFileInfos);
        }
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, handle.getLocation());
            long createdTime = Instant.now().toEpochMilli();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            long commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(handle.getLocation())) + 1L;
            if (commitVersion != handle.getReadVersion() + 1L) {
                throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.getReadVersion(), commitVersion - 1L));
            }
            Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), INSERT_OPERATION, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, handle.getReadVersion(), ISOLATION_LEVEL, true));
            List<String> partitionColumns = handle.getMetadataEntry().getOriginalPartitionColumns();
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, true);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, new SchemaTableName(handle.getSchemaName(), handle.getTableName()), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, handle.getLocation(), dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
        return Optional.empty();
    }

    public ColumnHandle getDeleteRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new DeltaLakeColumnHandle("$row_id", DeltaLakeColumnHandle.ROW_ID_COLUMN_TYPE, OptionalInt.empty(), "$row_id", DeltaLakeColumnHandle.ROW_ID_COLUMN_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }

    public ConnectorTableHandle beginDelete(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (DeltaLakeSchemaSupport.isAppendOnly(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot delete rows from a table with 'delta.appendOnly' set to true");
        }
        if (!this.allowWrite(session, handle)) {
            String fileSystem = new Path(handle.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Deletes are not supported on the %s filesystem", fileSystem));
        }
        if (!DeltaLakeSchemaSupport.getCheckConstraints(handle.getMetadataEntry()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with CHECK constraints is not supported");
        }
        this.checkUnsupportedGeneratedColumns(handle.getMetadataEntry());
        if (DeltaLakeSchemaSupport.changeDataFeedEnabled(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with Change Data Feed enabled is not supported");
        }
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        return DeltaLakeTableHandle.forDelete(handle.getSchemaName(), handle.getTableName(), handle.getLocation(), Optional.of(handle.getMetadataEntry()), handle.getEnforcedPartitionConstraint(), handle.getNonPartitionConstraint(), handle.getProjectedColumns(), handle.getReadVersion(), retryMode != RetryMode.NO_RETRIES);
    }

    public void finishDelete(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, tableHandle, fragments);
    }

    public ColumnHandle getUpdateRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        RowType rowIdType;
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        List<DeltaLakeColumnHandle> unmodifiedColumns = this.getUnmodifiedColumns(handle, updatedColumns);
        if (unmodifiedColumns.isEmpty()) {
            rowIdType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT)});
        } else {
            List unmodifiedColumnFields = (List)unmodifiedColumns.stream().map(columnMetadata -> RowType.field((String)columnMetadata.getName(), (Type)columnMetadata.getType())).collect(ImmutableList.toImmutableList());
            rowIdType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)BigintType.BIGINT), RowType.field((Type)RowType.from((List)unmodifiedColumnFields))});
        }
        return new DeltaLakeColumnHandle("$row_id", (Type)rowIdType, OptionalInt.empty(), "$row_id", (Type)rowIdType, DeltaLakeColumnType.SYNTHESIZED);
    }

    public ConnectorTableHandle beginUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> updatedColumns, RetryMode retryMode) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (DeltaLakeSchemaSupport.isAppendOnly(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot update rows from a table with 'delta.appendOnly' set to true");
        }
        if (!this.allowWrite(session, handle)) {
            String fileSystem = new Path(handle.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updates are not supported on the %s filesystem", fileSystem));
        }
        Map<String, String> columnInvariants = DeltaLakeSchemaSupport.getColumnInvariants(handle.getMetadataEntry());
        if (!columnInvariants.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updates are not supported for tables with delta invariants");
        }
        if (!DeltaLakeSchemaSupport.getCheckConstraints(handle.getMetadataEntry()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with CHECK constraints is not supported");
        }
        this.checkUnsupportedGeneratedColumns(handle.getMetadataEntry());
        if (DeltaLakeSchemaSupport.changeDataFeedEnabled(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with Change Data Feed enabled is not supported");
        }
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        List updatedColumnHandles = (List)updatedColumns.stream().map(columnHandle -> (DeltaLakeColumnHandle)columnHandle).collect(ImmutableList.toImmutableList());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(handle.getMetadataEntry().getCanonicalPartitionColumns());
        if (updatedColumnHandles.stream().map(DeltaLakeColumnHandle::getName).anyMatch(((Set)partitionColumnNames)::contains)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updating table partition columns is not supported");
        }
        List<DeltaLakeColumnHandle> unmodifiedColumns = this.getUnmodifiedColumns(handle, updatedColumns);
        return DeltaLakeTableHandle.forUpdate(handle.getSchemaName(), handle.getTableName(), handle.getLocation(), Optional.of(handle.getMetadataEntry()), handle.getEnforcedPartitionConstraint(), handle.getNonPartitionConstraint(), handle.getProjectedColumns(), updatedColumnHandles, unmodifiedColumns, handle.getReadVersion(), retryMode != RetryMode.NO_RETRIES);
    }

    public void finishUpdate(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        this.finishWrite(session, tableHandle, fragments);
    }

    public RowChangeParadigm getRowChangeParadigm(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW;
    }

    public ColumnHandle getMergeRowIdColumnHandle(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new DeltaLakeColumnHandle("$row_id", DeltaLakeColumnHandle.MERGE_ROW_ID_TYPE, OptionalInt.empty(), "$row_id", DeltaLakeColumnHandle.MERGE_ROW_ID_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }

    public Optional<ConnectorPartitioningHandle> getUpdateLayout(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return Optional.of(DeltaLakeUpdateHandle.INSTANCE);
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, RetryMode retryMode) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        if (DeltaLakeSchemaSupport.isAppendOnly(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot update rows from a table with 'delta.appendOnly' set to true");
        }
        if (!this.allowWrite(session, handle)) {
            String fileSystem = new Path(handle.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Updates are not supported on the %s filesystem", fileSystem));
        }
        if (!DeltaLakeSchemaSupport.getColumnInvariants(handle.getMetadataEntry()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Updates are not supported for tables with delta invariants");
        }
        if (!DeltaLakeSchemaSupport.getCheckConstraints(handle.getMetadataEntry()).isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with CHECK constraints is not supported");
        }
        this.checkUnsupportedGeneratedColumns(handle.getMetadataEntry());
        if (DeltaLakeSchemaSupport.changeDataFeedEnabled(handle.getMetadataEntry())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with Change Data Feed enabled is not supported");
        }
        this.checkSupportedWriterVersion(session, handle.getSchemaTableName());
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, handle);
        List inputColumns = (List)this.getColumns(handle.getMetadataEntry()).stream().filter(column -> column.getColumnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        DeltaLakeInsertTableHandle insertHandle = this.createInsertHandle(session, retryMode, handle, inputColumns, tableMetadata);
        return new DeltaLakeMergeTableHandle(handle, insertHandle);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeTableHandle handle = ((DeltaLakeMergeTableHandle)tableHandle).getTableHandle();
        List mergeResults = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.mergeResultJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        List oldFiles = (List)mergeResults.stream().map(DeltaLakeMergeResult::getOldFile).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        List newFiles = (List)mergeResults.stream().map(DeltaLakeMergeResult::getNewFile).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        if (handle.isRetriesEnabled()) {
            this.cleanExtraOutputFilesForUpdate(session, handle.getLocation(), newFiles);
        }
        Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
        String tableLocation = this.metastore.getTableLocation(handle.getSchemaTableName(), session);
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
            long createdTime = Instant.now().toEpochMilli();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            long currentVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(tableLocation));
            if (currentVersion != handle.getReadVersion()) {
                throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.getReadVersion(), currentVersion));
            }
            long commitVersion = currentVersion + 1L;
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), MERGE_OPERATION, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, handle.getReadVersion(), ISOLATION_LEVEL, true));
            long writeTimestamp = Instant.now().toEpochMilli();
            for (String file : oldFiles) {
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(file, writeTimestamp, true));
            }
            List<String> partitionColumns = handle.getMetadataEntry().getOriginalPartitionColumns();
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, newFiles, partitionColumns, true);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, new SchemaTableName(handle.getSchemaName(), handle.getTableName()), checkpointInterval, commitVersion);
        }
        catch (IOException | RuntimeException e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, newFiles);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    public Optional<ConnectorTableExecuteHandle> getTableHandleForExecute(ConnectorSession session, ConnectorTableHandle connectorTableHandle, String procedureName, Map<String, Object> executeProperties, RetryMode retryMode) {
        DeltaLakeTableProcedureId procedureId;
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)connectorTableHandle;
        try {
            procedureId = DeltaLakeTableProcedureId.valueOf(procedureName);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown procedure '" + procedureName + "'");
        }
        switch (procedureId) {
            case OPTIMIZE: {
                return this.getTableHandleForOptimize(tableHandle, executeProperties, retryMode);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + procedureId);
    }

    private Optional<ConnectorTableExecuteHandle> getTableHandleForOptimize(DeltaLakeTableHandle tableHandle, Map<String, Object> executeProperties, RetryMode retryMode) {
        DataSize maxScannedFileSize = (DataSize)executeProperties.get("file_size_threshold");
        List columns = (List)this.getColumns(tableHandle.getMetadataEntry()).stream().filter(column -> column.getColumnType() != DeltaLakeColumnType.SYNTHESIZED).collect(ImmutableList.toImmutableList());
        return Optional.of(new DeltaLakeTableExecuteHandle(tableHandle.getSchemaTableName(), DeltaLakeTableProcedureId.OPTIMIZE, new DeltaTableOptimizeHandle(tableHandle.getMetadataEntry(), columns, tableHandle.getMetadataEntry().getOriginalPartitionColumns(), maxScannedFileSize, Optional.empty(), retryMode != RetryMode.NO_RETRIES), tableHandle.getLocation()));
    }

    public Optional<ConnectorTableLayout> getLayoutForTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.getLayoutForOptimize(executeHandle);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private Optional<ConnectorTableLayout> getLayoutForOptimize(DeltaLakeTableExecuteHandle executeHandle) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        List<String> partitionColumnNames = optimizeHandle.getMetadataEntry().getCanonicalPartitionColumns();
        if (partitionColumnNames.isEmpty()) {
            return Optional.empty();
        }
        Map columnsByName = (Map)optimizeHandle.getTableColumns().stream().collect(ImmutableMap.toImmutableMap(columnHandle -> columnHandle.getName().toLowerCase(Locale.ENGLISH), Function.identity()));
        ImmutableList.Builder partitioningColumns = ImmutableList.builder();
        for (String columnName : partitionColumnNames) {
            partitioningColumns.add((Object)((DeltaLakeColumnHandle)columnsByName.get(columnName)));
        }
        DeltaLakePartitioningHandle partitioningHandle = new DeltaLakePartitioningHandle((List<DeltaLakeColumnHandle>)partitioningColumns.build());
        return Optional.of(new ConnectorTableLayout((ConnectorPartitioningHandle)partitioningHandle, partitionColumnNames, true));
    }

    public BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorTableHandle updatedSourceTableHandle) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)updatedSourceTableHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                return this.beginOptimize(session, executeHandle, table);
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private BeginTableExecuteResult<ConnectorTableExecuteHandle, ConnectorTableHandle> beginOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, DeltaLakeTableHandle table) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        if (!this.allowWrite(session, table)) {
            String fileSystem = new Path(table.getLocation()).toUri().getScheme();
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Optimize is not supported on the %s filesystem", fileSystem));
        }
        this.checkSupportedWriterVersion(session, table.getSchemaTableName());
        return new BeginTableExecuteResult((Object)executeHandle.withProcedureHandle(optimizeHandle.withCurrentVersion(table.getReadVersion())), (Object)table.forOptimize(true, optimizeHandle.getMaxScannedFileSize()));
    }

    public void finishTableExecute(ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                this.finishOptimize(session, executeHandle, fragments, splitSourceInfo);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown procedure '" + executeHandle.getProcedureId() + "'");
    }

    private void finishOptimize(ConnectorSession session, DeltaLakeTableExecuteHandle executeHandle, Collection<Slice> fragments, List<Object> splitSourceInfo) {
        DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
        long readVersion = optimizeHandle.getCurrentVersion().orElseThrow(() -> new IllegalArgumentException("currentVersion not set"));
        String tableLocation = executeHandle.getTableLocation();
        Set scannedPaths = (Set)splitSourceInfo.stream().map(file -> new Path((String)file)).collect(ImmutableSet.toImmutableSet());
        List dataFileInfos = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.dataFileInfoCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        if (optimizeHandle.isRetriesEnabled()) {
            this.cleanExtraOutputFiles(session, executeHandle.getTableLocation(), dataFileInfos);
        }
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
            long createdTime = Instant.now().toEpochMilli();
            long commitVersion = readVersion + 1L;
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), OPTIMIZE_OPERATION, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, readVersion, ISOLATION_LEVEL, true));
            long writeTimestamp = Instant.now().toEpochMilli();
            for (Path scannedPath : scannedPaths) {
                String relativePath = new Path(tableLocation).toUri().relativize(scannedPath.toUri()).toString();
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(relativePath, writeTimestamp, false));
            }
            List<String> partitionColumns = optimizeHandle.getMetadataEntry().getOriginalPartitionColumns();
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, dataFileInfos, partitionColumns, false);
            transactionLogWriter.flush();
            writeCommitted = true;
            Optional<Long> checkpointInterval = Optional.of(1L);
            this.writeCheckpointIfNeeded(session, executeHandle.getSchemaTableName(), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, dataFileInfos);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private boolean allowWrite(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        try {
            String tableLocation = this.metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
            Path tableMetadataDirectory = new Path(new Path(tableLocation).getParent().toString(), tableHandle.getTableName());
            boolean requiresOptIn = this.transactionLogWriterFactory.newWriter(session, tableMetadataDirectory.toString()).isUnsafe();
            return !requiresOptIn || this.unsafeWritesEnabled;
        }
        catch (TrinoException e) {
            if (e.getErrorCode() == StandardErrorCode.NOT_SUPPORTED.toErrorCode()) {
                return false;
            }
            throw e;
        }
    }

    private void checkUnsupportedGeneratedColumns(MetadataEntry metadataEntry) {
        Map<String, String> columnGeneratedExpressions = DeltaLakeSchemaSupport.getGeneratedColumnExpressions(metadataEntry);
        if (!columnGeneratedExpressions.isEmpty()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to tables with generated columns is not supported");
        }
    }

    private void checkSupportedWriterVersion(ConnectorSession session, SchemaTableName schemaTableName) {
        int requiredWriterVersion = this.getProtocolEntry(session, schemaTableName).getMinWriterVersion();
        if (requiredWriterVersion > 4) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table %s requires Delta Lake writer version %d which is not supported", schemaTableName, requiredWriterVersion));
        }
    }

    private ProtocolEntry getProtocolEntry(ConnectorSession session, SchemaTableName schemaTableName) {
        return this.metastore.getProtocol(session, this.metastore.getSnapshot(schemaTableName, session));
    }

    private List<DeltaLakeColumnHandle> getUnmodifiedColumns(DeltaLakeTableHandle tableHandle, List<ColumnHandle> updatedColumns) {
        Set updatedColumnHandles = (Set)updatedColumns.stream().map(columnHandle -> (DeltaLakeColumnHandle)columnHandle).collect(ImmutableSet.toImmutableSet());
        ImmutableSet partitionColumnNames = ImmutableSet.copyOf(tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
        List<DeltaLakeColumnMetadata> allColumns = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), this.typeManager);
        return (List)allColumns.stream().map(arg_0 -> DeltaLakeMetadata.lambda$getUnmodifiedColumns$49((Set)partitionColumnNames, arg_0)).filter(columnHandle -> !updatedColumnHandles.contains(columnHandle)).filter(arg_0 -> DeltaLakeMetadata.lambda$getUnmodifiedColumns$51((Set)partitionColumnNames, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private void finishWrite(ConnectorSession session, ConnectorTableHandle tableHandle, Collection<Slice> fragments) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        List updateResults = (List)fragments.stream().map(Slice::getBytes).map(arg_0 -> this.updateResultJsonCodec.fromJson(arg_0)).collect(ImmutableList.toImmutableList());
        List newFiles = (List)updateResults.stream().map(DeltaLakeUpdateResult::getNewFile).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
        if (handle.isRetriesEnabled()) {
            this.cleanExtraOutputFilesForUpdate(session, handle.getLocation(), newFiles);
        }
        String tableLocation = this.metastore.getTableLocation(handle.getSchemaTableName(), session);
        DeltaLakeTableHandle.WriteType writeType = handle.getWriteType().orElseThrow();
        String operation = switch (writeType) {
            case DeltaLakeTableHandle.WriteType.DELETE -> DELETE_OPERATION;
            case DeltaLakeTableHandle.WriteType.UPDATE -> UPDATE_OPERATION;
            default -> throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported write type: " + writeType);
        };
        boolean writeCommitted = false;
        try {
            TransactionLogWriter transactionLogWriter = this.transactionLogWriterFactory.newWriter(session, tableLocation);
            long createdTime = Instant.now().toEpochMilli();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            long commitVersion = TransactionLogParser.getMandatoryCurrentVersion(fileSystem, new Path(tableLocation)) + 1L;
            if (commitVersion != handle.getReadVersion() + 1L) {
                throw new TransactionConflictException(String.format("Conflicting concurrent writes found. Expected transaction log version: %s, actual version: %s", handle.getReadVersion(), commitVersion - 1L));
            }
            Optional<Long> checkpointInterval = handle.getMetadataEntry().getCheckpointInterval();
            transactionLogWriter.appendCommitInfoEntry(new CommitInfoEntry(commitVersion, createdTime, session.getUser(), session.getUser(), operation, (Map<String, String>)ImmutableMap.of((Object)"queryId", (Object)session.getQueryId()), null, null, "trino-" + this.nodeVersion + "-" + this.nodeId, 0L, ISOLATION_LEVEL, true));
            long writeTimestamp = Instant.now().toEpochMilli();
            for (DeltaLakeUpdateResult updateResult : updateResults) {
                transactionLogWriter.appendRemoveFileEntry(new RemoveFileEntry(updateResult.getOldFile(), writeTimestamp, true));
            }
            DeltaLakeMetadata.appendAddFileEntries(transactionLogWriter, newFiles, handle.getMetadataEntry().getOriginalPartitionColumns(), true);
            transactionLogWriter.flush();
            writeCommitted = true;
            this.writeCheckpointIfNeeded(session, new SchemaTableName(handle.getSchemaName(), handle.getTableName()), checkpointInterval, commitVersion);
        }
        catch (Exception e) {
            if (!writeCommitted) {
                this.cleanupFailedWrite(session, tableLocation, newFiles);
            }
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Failed to write Delta Lake transaction log entry", (Throwable)e);
        }
    }

    private void writeCheckpointIfNeeded(ConnectorSession session, SchemaTableName table, Optional<Long> checkpointInterval, long newVersion) {
        try {
            TableSnapshot snapshot = this.metastore.getSnapshot(table, session);
            long lastCheckpointVersion = snapshot.getLastCheckpointVersion().orElse(0L);
            if (newVersion - lastCheckpointVersion < checkpointInterval.orElse(this.defaultCheckpointInterval)) {
                return;
            }
            if (snapshot.getVersion() > newVersion) {
                LOG.info("Snapshot for table %s already at version %s when checkpoint requested for version %s", new Object[]{table, snapshot.getVersion(), newVersion});
            }
            this.checkpointWriterManager.writeCheckpoint(session, snapshot);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Failed to write checkpoint for table %s for version %s", new Object[]{table, newVersion});
        }
    }

    private void cleanupFailedWrite(ConnectorSession session, String tableLocation, List<DataFileInfo> dataFiles) {
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(new HdfsContext(session), new Path(tableLocation));
            for (DataFileInfo dataFile : dataFiles) {
                fileSystem.delete(new Path(tableLocation, dataFile.getPath()), false);
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e, "Failed cleanup of leftover files from failed write, files are: %s", new Object[]{dataFiles.stream().map(dataFileInfo -> new Path(tableLocation, dataFileInfo.getPath())).collect(ImmutableList.toImmutableList())});
        }
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        boolean isPartitioned = !((DeltaLakeTableHandle)table).getMetadataEntry().getCanonicalPartitionColumns().isEmpty();
        return Optional.of(new DeltaLakeInputInfo(isPartitioned));
    }

    public void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        this.metastore.dropTable(session, handle.getSchemaName(), handle.getTableName(), table.getTableType().equals(TableType.EXTERNAL_TABLE.toString()));
    }

    public void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        Table table = this.metastore.getTable(handle.getSchemaName(), handle.getTableName()).orElseThrow(() -> new TableNotFoundException(handle.getSchemaTableName()));
        if (table.getTableType().equals(TableType.MANAGED_TABLE.name()) && !this.allowManagedTableRename) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming managed tables is not allowed with current metastore configuration");
        }
        this.metastore.renameTable(session, handle.getSchemaTableName(), newTableName);
    }

    public Map<String, Object> getSchemaProperties(ConnectorSession session, CatalogSchemaName schemaName) {
        String schema = schemaName.getSchemaName();
        Preconditions.checkState((!schema.equals("information_schema") && !schema.equals("sys") ? 1 : 0) != 0, (String)"Schema is not accessible: %s", (Object)schemaName);
        Optional<Database> db = this.metastore.getDatabase(schema);
        return db.map(DeltaLakeSchemaProperties::fromDatabase).orElseThrow(() -> new SchemaNotFoundException(schema));
    }

    public void createRole(ConnectorSession session, String role, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.createRole(session, role, grantor.map(HivePrincipal::from));
    }

    public void dropRole(ConnectorSession session, String role) {
        this.accessControlMetadata.dropRole(session, role);
    }

    public Set<String> listRoles(ConnectorSession session) {
        return this.accessControlMetadata.listRoles(session);
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSession session, TrinoPrincipal principal) {
        return ImmutableSet.copyOf((Collection)this.accessControlMetadata.listRoleGrants(session, HivePrincipal.from((TrinoPrincipal)principal)));
    }

    public void grantRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean withAdminOption, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.grantRoles(session, roles, HivePrincipal.from(grantees), withAdminOption, grantor.map(HivePrincipal::from));
    }

    public void revokeRoles(ConnectorSession session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOptionFor, Optional<TrinoPrincipal> grantor) {
        this.accessControlMetadata.revokeRoles(session, roles, HivePrincipal.from(grantees), adminOptionFor, grantor.map(HivePrincipal::from));
    }

    public Set<RoleGrant> listApplicableRoles(ConnectorSession session, TrinoPrincipal principal) {
        return this.accessControlMetadata.listApplicableRoles(session, HivePrincipal.from((TrinoPrincipal)principal));
    }

    public Set<String> listEnabledRoles(ConnectorSession session) {
        return this.accessControlMetadata.listEnabledRoles(session);
    }

    public void grantTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.grantTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from((TrinoPrincipal)grantee), grantOption);
    }

    public void revokeTablePrivileges(ConnectorSession session, SchemaTableName schemaTableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.accessControlMetadata.revokeTablePrivileges(session, schemaTableName, privileges, HivePrincipal.from((TrinoPrincipal)grantee), grantOption);
    }

    public List<GrantInfo> listTablePrivileges(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
        return this.accessControlMetadata.listTablePrivileges(session, this.listTables(session, schemaTablePrefix));
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        SchemaTableName tableName = prefix.toSchemaTableName();
        return (List)this.metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).map(table -> ImmutableList.of((Object)tableName)).orElse(ImmutableList.of());
    }

    private void setRollback(Runnable action) {
        Preconditions.checkState((boolean)this.rollbackAction.compareAndSet(null, action), (Object)"rollback action is already set");
    }

    private static String toUriFormat(String path) {
        return new Path(path).toUri().toString();
    }

    public void rollback() {
        Optional.ofNullable(this.rollbackAction.getAndSet(null)).ifPresent(Runnable::run);
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)handle;
        SchemaTableName tableName = tableHandle.getSchemaTableName();
        ImmutableSet partitionColumns = ImmutableSet.copyOf(DeltaLakeSchemaSupport.extractPartitionColumns(tableHandle.getMetadataEntry(), this.typeManager));
        Map constraintDomains = (Map)constraint.getSummary().getDomains().orElseThrow(() -> new IllegalArgumentException("constraint summary is NONE"));
        ImmutableMap.Builder enforceableDomains = ImmutableMap.builder();
        ImmutableMap.Builder unenforceableDomains = ImmutableMap.builder();
        for (Map.Entry domainEntry : constraintDomains.entrySet()) {
            DeltaLakeColumnHandle column = (DeltaLakeColumnHandle)domainEntry.getKey();
            if (!partitionColumns.contains(column)) {
                unenforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
                continue;
            }
            enforceableDomains.put((Object)column, (Object)((Domain)domainEntry.getValue()));
        }
        TupleDomain newEnforcedConstraint = TupleDomain.withColumnDomains((Map)enforceableDomains.buildOrThrow());
        TupleDomain newUnenforcedConstraint = TupleDomain.withColumnDomains((Map)unenforceableDomains.buildOrThrow());
        DeltaLakeTableHandle newHandle = new DeltaLakeTableHandle(tableName.getSchemaName(), tableName.getTableName(), tableHandle.getLocation(), Optional.of(tableHandle.getMetadataEntry()), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getEnforcedPartitionConstraint().intersect(newEnforcedConstraint), (TupleDomain<DeltaLakeColumnHandle>)tableHandle.getNonPartitionConstraint().intersect(newUnenforcedConstraint).simplify(this.domainCompactionThreshold), tableHandle.getWriteType(), tableHandle.getProjectedColumns(), tableHandle.getUpdatedColumns(), tableHandle.getUpdateRowIdColumns(), Optional.empty(), tableHandle.getReadVersion(), tableHandle.isRetriesEnabled());
        if (tableHandle.getEnforcedPartitionConstraint().equals(newHandle.getEnforcedPartitionConstraint()) && tableHandle.getNonPartitionConstraint().equals(newHandle.getNonPartitionConstraint())) {
            return Optional.empty();
        }
        return Optional.of(new ConstraintApplicationResult((Object)newHandle, newUnenforcedConstraint.transformKeys(ColumnHandle.class::cast), false));
    }

    public Optional<ProjectionApplicationResult<ConnectorTableHandle>> applyProjection(ConnectorSession session, ConnectorTableHandle tableHandle, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)tableHandle;
        ImmutableSet projectedColumns = ImmutableSet.copyOf(assignments.values());
        if (deltaLakeTableHandle.getProjectedColumns().isPresent() && deltaLakeTableHandle.getProjectedColumns().get().equals(projectedColumns)) {
            return Optional.empty();
        }
        List simpleProjections = (List)projections.stream().filter(projection -> projection instanceof Variable).collect(ImmutableList.toImmutableList());
        List newColumnAssignments = (List)assignments.entrySet().stream().map(assignment -> new Assignment((String)assignment.getKey(), (ColumnHandle)assignment.getValue(), ((DeltaLakeColumnHandle)assignment.getValue()).getType())).collect(ImmutableList.toImmutableList());
        return Optional.of(new ProjectionApplicationResult((Object)deltaLakeTableHandle.withProjectedColumns((Set<ColumnHandle>)projectedColumns), simpleProjections, newColumnAssignments, false));
    }

    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return this.deltaLakeRedirectionsProvider.getTableScanRedirection(session, (DeltaLakeTableHandle)tableHandle);
    }

    public ConnectorAnalyzeMetadata getStatisticsCollectionMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, Map<String, Object> analyzeProperties) {
        Optional oldAnalyzeColumnNames;
        Optional<Set<String>> analyzeColumnNames;
        if (!DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("ANALYZE not supported if extended statistics are disabled. Enable via %s config property or %s session property.", "delta.extended-statistics.enabled", "extended_statistics_enabled"));
        }
        DeltaLakeTableHandle handle = (DeltaLakeTableHandle)tableHandle;
        MetadataEntry metadata = handle.getMetadataEntry();
        Optional<Instant> filesModifiedAfterFromProperties = DeltaLakeAnalyzeProperties.getFilesModifiedAfterProperty(analyzeProperties);
        Optional<ExtendedStatistics> statistics = this.statisticsAccess.readExtendedStatistics(session, handle.getLocation());
        Optional<Instant> alreadyAnalyzedModifiedTimeMax = statistics.map(ExtendedStatistics::getAlreadyAnalyzedModifiedTimeMax);
        Optional<Instant> filesModifiedAfter = Optional.empty();
        if (filesModifiedAfterFromProperties.isPresent() || alreadyAnalyzedModifiedTimeMax.isPresent()) {
            filesModifiedAfter = Optional.of((Instant)Comparators.max((Comparable)filesModifiedAfterFromProperties.orElse(Instant.ofEpochMilli(0L)), (Comparable)alreadyAnalyzedModifiedTimeMax.orElse(Instant.ofEpochMilli(0L))));
        }
        if ((analyzeColumnNames = DeltaLakeAnalyzeProperties.getColumnNames(analyzeProperties)).isPresent()) {
            Set<String> columnNames = analyzeColumnNames.get();
            if (columnNames.isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "Cannot specify empty list of columns for analysis");
            }
            Set allColumnNames = (Set)DeltaLakeSchemaSupport.extractColumnMetadata(metadata, this.typeManager).stream().map(ColumnMetadata::getName).collect(ImmutableSet.toImmutableSet());
            if (!allColumnNames.containsAll(columnNames)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, String.format("Invalid columns specified for analysis: %s", Sets.difference(columnNames, (Set)allColumnNames)));
            }
        }
        if ((oldAnalyzeColumnNames = statistics.flatMap(ExtendedStatistics::getAnalyzedColumns)).isPresent() && (analyzeColumnNames.isEmpty() || !((Set)oldAnalyzeColumnNames.get()).containsAll((Collection)analyzeColumnNames.get()))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ANALYZE_PROPERTY, "List of columns to be analyzed must be a subset of previously used. To extend list of analyzed columns drop table statistics");
        }
        AnalyzeHandle analyzeHandle = new AnalyzeHandle(statistics.isEmpty(), filesModifiedAfter, analyzeColumnNames);
        DeltaLakeTableHandle newHandle = new DeltaLakeTableHandle(handle.getSchemaTableName().getSchemaName(), handle.getSchemaTableName().getTableName(), handle.getLocation(), Optional.of(metadata), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), (TupleDomain<DeltaLakeColumnHandle>)TupleDomain.all(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(analyzeHandle), handle.getReadVersion(), false);
        ImmutableSet.Builder columnStatistics = ImmutableSet.builder();
        DeltaLakeSchemaSupport.extractColumnMetadata(metadata, this.typeManager).stream().filter(DeltaLakeMetadata::shouldCollectExtendedStatistics).filter(columnMetadata -> analyzeColumnNames.map(columnNames -> columnNames.contains(columnMetadata.getName())).orElse(true)).forEach(columnMetadata -> {
            if (!(columnMetadata.getType() instanceof FixedWidthType) && (statistics.isEmpty() || DeltaLakeMetadata.totalSizeStatisticsExists(((ExtendedStatistics)statistics.get()).getColumnStatistics(), columnMetadata.getName()))) {
                columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.TOTAL_SIZE_IN_BYTES));
            }
            columnStatistics.add((Object)new ColumnStatisticMetadata(columnMetadata.getName(), ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY));
        });
        columnStatistics.add((Object)new ColumnStatisticMetadata("$file_modified_time", ColumnStatisticType.MAX_VALUE));
        TableStatisticsMetadata statisticsMetadata = new TableStatisticsMetadata((Set)columnStatistics.build(), (Set)ImmutableSet.of(), (List)ImmutableList.of());
        return new ConnectorAnalyzeMetadata((ConnectorTableHandle)newHandle, statisticsMetadata);
    }

    private static boolean shouldCollectExtendedStatistics(ColumnMetadata columnMetadata) {
        if (columnMetadata.isHidden()) {
            return false;
        }
        Type type = columnMetadata.getType();
        return !(type instanceof MapType) && !(type instanceof RowType) && !(type instanceof ArrayType);
    }

    private static boolean totalSizeStatisticsExists(Map<String, DeltaLakeColumnStatistics> statistics, String columnName) {
        return statistics.containsKey(columnName) && statistics.get(columnName).getTotalSizeInBytes().isPresent();
    }

    public ConnectorTableHandle beginStatisticsCollection(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return tableHandle;
    }

    public void finishStatisticsCollection(ConnectorSession session, ConnectorTableHandle table, Collection<ComputedStatistics> computedStatistics) {
        DeltaLakeTableHandle tableHandle = (DeltaLakeTableHandle)table;
        AnalyzeHandle analyzeHandle = tableHandle.getAnalyzeHandle().orElseThrow(() -> new IllegalArgumentException("analyzeHandle not set"));
        String location = this.metastore.getTableLocation(tableHandle.getSchemaTableName(), session);
        Optional<ExtendedStatistics> oldStatistics = this.statisticsAccess.readExtendedStatistics(session, location);
        oldStatistics.ifPresent(statistics -> Preconditions.checkArgument((statistics.getModelVersion() == 4L ? 1 : 0) != 0, (Object)"Existing table statistics are incompatible, run the drop statistics procedure on this table before re-analyzing"));
        Map oldColumnStatistics = oldStatistics.map(ExtendedStatistics::getColumnStatistics).orElseGet(ImmutableMap::of);
        Map<String, DeltaLakeColumnStatistics> newColumnStatistics = DeltaLakeMetadata.toDeltaLakeColumnStatistics(computedStatistics);
        HashMap<String, DeltaLakeColumnStatistics> mergedColumnStatistics = new HashMap<String, DeltaLakeColumnStatistics>();
        Set<String> newColumns = newColumnStatistics.keySet();
        oldColumnStatistics.entrySet().stream().filter(entry -> newColumns.contains(entry.getKey())).forEach(entry -> mergedColumnStatistics.put((String)entry.getKey(), (DeltaLakeColumnStatistics)entry.getValue()));
        newColumnStatistics.forEach((columnName, columnStatistics) -> mergedColumnStatistics.merge((String)columnName, (DeltaLakeColumnStatistics)columnStatistics, DeltaLakeColumnStatistics::update));
        Optional<Instant> maxFileModificationTime = DeltaLakeMetadata.getMaxFileModificationTime(computedStatistics);
        Instant finalAlreadyAnalyzedModifiedTimeMax = Instant.now();
        if (maxFileModificationTime.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.min((Comparable)maxFileModificationTime.get(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        if (oldStatistics.isPresent()) {
            finalAlreadyAnalyzedModifiedTimeMax = (Instant)Comparators.max((Comparable)oldStatistics.get().getAlreadyAnalyzedModifiedTimeMax(), (Comparable)finalAlreadyAnalyzedModifiedTimeMax);
        }
        if (analyzeHandle.getColumns().isPresent() && !mergedColumnStatistics.keySet().equals(analyzeHandle.getColumns().get())) {
            throw new IllegalStateException(String.format("Unexpected columns in in mergedColumnStatistics %s; expected %s", mergedColumnStatistics.keySet(), analyzeHandle.getColumns().get()));
        }
        ExtendedStatistics mergedExtendedStatistics = new ExtendedStatistics(finalAlreadyAnalyzedModifiedTimeMax, mergedColumnStatistics, analyzeHandle.getColumns());
        this.statisticsAccess.updateExtendedStatistics(session, location, mergedExtendedStatistics);
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, ConnectorTableHandle connectorTableHandle) {
        return true;
    }

    public boolean supportsReportingWrittenBytes(ConnectorSession session, SchemaTableName fullTableName, Map<String, Object> tableProperties) {
        return true;
    }

    private void cleanExtraOutputFiles(ConnectorSession session, String baseLocation, List<DataFileInfo> validDataFiles) {
        Set writtenFilePaths = (Set)validDataFiles.stream().map(dataFileInfo -> baseLocation + "/" + dataFileInfo.getPath()).collect(ImmutableSet.toImmutableSet());
        this.cleanExtraOutputFiles(session, writtenFilePaths);
    }

    private void cleanExtraOutputFilesForUpdate(ConnectorSession session, String baseLocation, List<DataFileInfo> newFiles) {
        Set writtenFilePaths = (Set)newFiles.stream().map(dataFileInfo -> baseLocation + "/" + dataFileInfo.getPath()).collect(ImmutableSet.toImmutableSet());
        this.cleanExtraOutputFiles(session, writtenFilePaths);
    }

    private void cleanExtraOutputFiles(ConnectorSession session, Set<String> validWrittenFilePaths) {
        HdfsContext hdfsContext = new HdfsContext(session);
        Set fileLocations = (Set)validWrittenFilePaths.stream().map(path -> {
            int fileNameSeparatorPos = path.lastIndexOf("/");
            Verify.verify((fileNameSeparatorPos != -1 && fileNameSeparatorPos != 0 ? 1 : 0) != 0, (String)"invalid data file path: %s", (Object)path);
            return path.substring(0, fileNameSeparatorPos);
        }).collect(ImmutableSet.toImmutableSet());
        for (String location : fileLocations) {
            this.cleanExtraOutputFiles(hdfsContext, session.getQueryId(), location, validWrittenFilePaths);
        }
    }

    private void cleanExtraOutputFiles(HdfsContext hdfsContext, String queryId, String location, Set<String> filesToKeep) {
        ArrayDeque<String> filesToDelete = new ArrayDeque<String>();
        try {
            LOG.debug("Deleting failed attempt files from %s for query %s", new Object[]{location, queryId});
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(hdfsContext, new Path(location));
            if (!fileSystem.exists(new Path(location))) {
                return;
            }
            RemoteIterator iterator = fileSystem.listFiles(new Path(location), false);
            while (iterator.hasNext()) {
                Path file = ((LocatedFileStatus)iterator.next()).getPath();
                if (!this.isFileCreatedByQuery(file.getName(), queryId) || filesToKeep.contains(location + "/" + file.getName())) continue;
                filesToDelete.add(file.getName());
            }
            if (filesToDelete.isEmpty()) {
                return;
            }
            LOG.info("Found %s files to delete and %s to retain in location %s for query %s", new Object[]{filesToDelete.size(), filesToKeep.size(), location, queryId});
            ImmutableList.Builder deletedFilesBuilder = ImmutableList.builder();
            Iterator filesToDeleteIterator = filesToDelete.iterator();
            while (filesToDeleteIterator.hasNext()) {
                String fileName = (String)filesToDeleteIterator.next();
                LOG.debug("Deleting failed attempt file %s/%s for query %s", new Object[]{location, fileName, queryId});
                fileSystem.delete(new Path(location, fileName), false);
                deletedFilesBuilder.add((Object)fileName);
                filesToDeleteIterator.remove();
            }
            ImmutableList deletedFiles = deletedFilesBuilder.build();
            if (!deletedFiles.isEmpty()) {
                LOG.info("Deleted failed attempt files %s from %s for query %s", new Object[]{deletedFiles, location, queryId});
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Could not clean up extraneous output files; remaining files: %s", filesToDelete), (Throwable)e);
        }
    }

    private boolean isFileCreatedByQuery(String fileName, String queryId) {
        Verify.verify((!queryId.contains("-") ? 1 : 0) != 0, (String)"queryId(%s) should not contain hyphens", (Object)queryId);
        return fileName.startsWith(queryId + "-");
    }

    private static Map<String, DeltaLakeColumnStatistics> toDeltaLakeColumnStatistics(Collection<ComputedStatistics> computedStatistics) {
        ComputedStatistics singleStatistics = (ComputedStatistics)Iterables.getOnlyElement(computedStatistics);
        return (Map)DeltaLakeMetadata.createColumnToComputedStatisticsMap(singleStatistics.getColumnStatistics()).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> DeltaLakeMetadata.createDeltaLakeColumnStatistics((Map)entry.getValue())));
    }

    private static Map<String, Map<ColumnStatisticType, Block>> createColumnToComputedStatisticsMap(Map<ColumnStatisticMetadata, Block> computedStatistics) {
        ImmutableTable.Builder result = ImmutableTable.builder();
        computedStatistics.forEach((metadata, block) -> {
            if (metadata.getColumnName().equals("$file_modified_time")) {
                return;
            }
            if (!SUPPORTED_STATISTICS_TYPE.contains(metadata.getStatisticType())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics collection: " + metadata);
            }
            result.put((Object)metadata.getColumnName(), (Object)metadata.getStatisticType(), block);
        });
        return result.buildOrThrow().rowMap();
    }

    private static DeltaLakeColumnStatistics createDeltaLakeColumnStatistics(Map<ColumnStatisticType, Block> computedStatistics) {
        OptionalLong totalSize = OptionalLong.empty();
        if (computedStatistics.containsKey(ColumnStatisticType.TOTAL_SIZE_IN_BYTES)) {
            totalSize = DeltaLakeMetadata.getLongValue(computedStatistics.get(ColumnStatisticType.TOTAL_SIZE_IN_BYTES));
        }
        HyperLogLog ndvSummary = DeltaLakeMetadata.getHyperLogLogForNdv(computedStatistics.get(ColumnStatisticType.NUMBER_OF_DISTINCT_VALUES_SUMMARY));
        return DeltaLakeColumnStatistics.create(totalSize, ndvSummary);
    }

    private static OptionalLong getLongValue(Block block) {
        if (block.isNull(0)) {
            return OptionalLong.of(0L);
        }
        return OptionalLong.of(BigintType.BIGINT.getLong(block, 0));
    }

    private static HyperLogLog getHyperLogLogForNdv(Block block) {
        if (block.isNull(0)) {
            return HyperLogLog.newInstance((int)4096);
        }
        Slice serializedSummary = (Slice)Utils.blockToNativeValue((Type)HyperLogLogType.HYPER_LOG_LOG, (Block)block);
        return HyperLogLog.newInstance((Slice)serializedSummary);
    }

    private static Optional<Instant> getMaxFileModificationTime(Collection<ComputedStatistics> computedStatistics) {
        ComputedStatistics singleStatistics = (ComputedStatistics)Iterables.getOnlyElement(computedStatistics);
        return singleStatistics.getColumnStatistics().entrySet().stream().filter(entry -> ((ColumnStatisticMetadata)entry.getKey()).getColumnName().equals("$file_modified_time")).map(entry -> {
            ColumnStatisticMetadata columnStatisticMetadata = (ColumnStatisticMetadata)entry.getKey();
            if (columnStatisticMetadata.getStatisticType() != ColumnStatisticType.MAX_VALUE) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unexpected statistics collection: " + columnStatisticMetadata);
            }
            if (((Block)entry.getValue()).isNull(0)) {
                return Optional.empty();
            }
            return Optional.of(Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong((Block)entry.getValue(), 0))));
        }).findFirst().orElseThrow();
    }

    public DeltaLakeMetastore getMetastore() {
        return this.metastore;
    }

    private static ColumnMetadata getColumnMetadata(DeltaLakeColumnHandle column, @Nullable String comment, boolean nullability) {
        return ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).setHidden(column.getColumnType() == DeltaLakeColumnType.SYNTHESIZED).setComment(Optional.ofNullable(comment)).setNullable(nullability).build();
    }

    public static TupleDomain<DeltaLakeColumnHandle> createStatisticsPredicate(AddFileEntry addFileEntry, List<DeltaLakeColumnMetadata> schema, List<String> canonicalPartitionColumns) {
        return addFileEntry.getStats().map(deltaLakeFileStatistics -> TupleDomain.withColumnDomains((Map)((Map)schema.stream().filter(column -> DeltaLakeMetadata.canUseInPredicate(column.getColumnMetadata())).collect(ImmutableMap.toImmutableMap(column -> DeltaLakeMetadata.toColumnHandle(column.getColumnMetadata(), column.getFieldId(), column.getPhysicalName(), column.getPhysicalColumnType(), canonicalPartitionColumns), column -> DeltaLakeMetadata.buildColumnDomain(column, deltaLakeFileStatistics, canonicalPartitionColumns)))))).orElseGet(TupleDomain::all);
    }

    private static boolean canUseInPredicate(ColumnMetadata column) {
        Type type = column.getType();
        return type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(RealType.REAL) || type.equals(DoubleType.DOUBLE) || type.equals(BooleanType.BOOLEAN) || type.equals(DateType.DATE) || type instanceof TimestampWithTimeZoneType || type instanceof DecimalType || type.equals(VarcharType.VARCHAR);
    }

    private static Domain buildColumnDomain(DeltaLakeColumnMetadata column, DeltaLakeFileStatistics stats, List<String> canonicalPartitionColumns) {
        Optional<Object> maxValue;
        Optional<Long> nullCount = stats.getNullCount(column.getPhysicalName());
        if (nullCount.isEmpty()) {
            return Domain.all((Type)column.getType());
        }
        if (stats.getNumRecords().equals(nullCount)) {
            return Domain.onlyNull((Type)column.getType());
        }
        boolean hasNulls = nullCount.get() > 0L;
        DeltaLakeColumnHandle deltaLakeColumnHandle = DeltaLakeMetadata.toColumnHandle(column.getColumnMetadata(), column.getFieldId(), column.getPhysicalName(), column.getPhysicalColumnType(), canonicalPartitionColumns);
        Optional<Object> minValue = stats.getMinColumnValue(deltaLakeColumnHandle);
        if (minValue.isPresent() && TypeUtils.isFloatingPointNaN((Type)column.getType(), (Object)minValue.get())) {
            return DeltaLakeMetadata.allValues(column.getType(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(minValue, column.getType())) {
            minValue = Optional.empty();
        }
        if ((maxValue = stats.getMaxColumnValue(deltaLakeColumnHandle)).isPresent() && TypeUtils.isFloatingPointNaN((Type)column.getType(), (Object)maxValue.get())) {
            return DeltaLakeMetadata.allValues(column.getType(), hasNulls);
        }
        if (DeltaLakeMetadata.isNotFinite(maxValue, column.getType())) {
            maxValue = Optional.empty();
        }
        if (minValue.isPresent() && maxValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)column.getType(), (Object)minValue.get(), (boolean)true, (Object)maxValue.get(), (boolean)true), (Range[])new Range[0]), (boolean)hasNulls);
        }
        if (minValue.isPresent()) {
            return Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.greaterThanOrEqual((Type)column.getType(), (Object)minValue.get()), (Range[])new Range[0]), (boolean)hasNulls);
        }
        return maxValue.map(value -> Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.lessThanOrEqual((Type)column.getType(), (Object)value), (Range[])new Range[0]), (boolean)hasNulls)).orElseGet(() -> Domain.all((Type)column.getType()));
    }

    private static boolean isNotFinite(Optional<Object> value, Type type) {
        if (type.equals(DoubleType.DOUBLE)) {
            return value.map(Double.class::cast).filter(val -> !Double.isFinite(val)).isPresent();
        }
        if (type.equals(RealType.REAL)) {
            return value.map(Long.class::cast).map(Math::toIntExact).map(Float::intBitsToFloat).filter(val -> !Float.isFinite(val.floatValue())).isPresent();
        }
        return false;
    }

    private static Domain allValues(Type type, boolean includeNull) {
        if (includeNull) {
            return Domain.all((Type)type);
        }
        return Domain.notNull((Type)type);
    }

    private static DeltaLakeColumnHandle toColumnHandle(ColumnMetadata column, String physicalName, Type physicalType, Collection<String> partitionColumns) {
        return DeltaLakeMetadata.toColumnHandle(column, OptionalInt.empty(), physicalName, physicalType, partitionColumns);
    }

    private static DeltaLakeColumnHandle toColumnHandle(ColumnMetadata column, OptionalInt fieldId, String physicalName, Type physicalType, Collection<String> partitionColumns) {
        boolean isPartitionKey = partitionColumns.stream().anyMatch(partition -> partition.equalsIgnoreCase(column.getName()));
        return new DeltaLakeColumnHandle(column.getName(), column.getType(), fieldId, physicalName, physicalType, isPartitionKey ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR);
    }

    private static Optional<String> getQueryId(Database database) {
        return Optional.ofNullable((String)database.getParameters().get("presto_query_id"));
    }

    private static Optional<String> getQueryId(Table table) {
        return Optional.ofNullable((String)table.getParameters().get("presto_query_id"));
    }

    private static /* synthetic */ boolean lambda$getUnmodifiedColumns$51(Set partitionColumnNames, DeltaLakeColumnHandle columnHandle) {
        return !partitionColumnNames.contains(columnHandle.getName());
    }

    private static /* synthetic */ DeltaLakeColumnHandle lambda$getUnmodifiedColumns$49(Set partitionColumnNames, DeltaLakeColumnMetadata column) {
        return DeltaLakeMetadata.toColumnHandle(column.getColumnMetadata(), column.getFieldId(), column.getPhysicalName(), column.getPhysicalColumnType(), partitionColumnNames);
    }
}

