/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import io.airlift.json.JsonCodec;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMergeSink;
import io.trino.plugin.deltalake.DeltaLakeMergeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePageSink;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.TypeManager;
import java.util.Objects;
import javax.inject.Inject;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSinkProvider
implements ConnectorPageSinkProvider {
    private final PageIndexerFactory pageIndexerFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final HdfsEnvironment hdfsEnvironment;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final DeltaLakeWriterStats stats;
    private final int maxPartitionsPerWriter;
    private final DateTimeZone parquetDateTimeZone;
    private final TypeManager typeManager;
    private final String trinoVersion;

    @Inject
    public DeltaLakePageSinkProvider(PageIndexerFactory pageIndexerFactory, TrinoFileSystemFactory fileSystemFactory, HdfsEnvironment hdfsEnvironment, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, DeltaLakeWriterStats stats, DeltaLakeConfig deltaLakeConfig, TypeManager typeManager, NodeVersion nodeVersion) {
        this.pageIndexerFactory = pageIndexerFactory;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.hdfsEnvironment = hdfsEnvironment;
        this.dataFileInfoCodec = dataFileInfoCodec;
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.stats = stats;
        this.maxPartitionsPerWriter = deltaLakeConfig.getMaxPartitionsPerWriter();
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoVersion = nodeVersion.toString();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeOutputTableHandle tableHandle = (DeltaLakeOutputTableHandle)outputTableHandle;
        return new DeltaLakePageSink(tableHandle.getInputColumns(), tableHandle.getPartitionedBy(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableHandle.getLocation(), session, this.stats, this.typeManager, this.trinoVersion);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeInsertTableHandle tableHandle = (DeltaLakeInsertTableHandle)insertTableHandle;
        return new DeltaLakePageSink(tableHandle.getInputColumns(), tableHandle.getMetadataEntry().getOriginalPartitionColumns(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableHandle.getLocation(), session, this.stats, this.typeManager, this.trinoVersion);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
                return new DeltaLakePageSink(optimizeHandle.getTableColumns(), optimizeHandle.getOriginalPartitionColumns(), this.pageIndexerFactory, this.hdfsEnvironment, this.maxPartitionsPerWriter, this.dataFileInfoCodec, executeHandle.getTableLocation(), session, this.stats, this.typeManager, this.trinoVersion);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + executeHandle.getProcedureId());
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeMergeTableHandle merge = (DeltaLakeMergeTableHandle)mergeHandle;
        DeltaLakeInsertTableHandle tableHandle = merge.getInsertTableHandle();
        ConnectorPageSink pageSink = this.createPageSink(transactionHandle, session, tableHandle, pageSinkId);
        return new DeltaLakeMergeSink(this.fileSystemFactory, this.hdfsEnvironment, session, this.parquetDateTimeZone, this.trinoVersion, this.dataFileInfoCodec, this.mergeResultJsonCodec, this.stats, tableHandle.getLocation(), pageSink, tableHandle.getInputColumns());
    }
}

