/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Throwables;
import com.google.inject.Module;
import io.trino.plugin.base.Versions;
import io.trino.plugin.deltalake.InternalDeltaLakeConnectorFactory;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeConnectorFactory
implements ConnectorFactory {
    public static final String CONNECTOR_NAME = "delta-lake";
    private final Class<? extends Module> module;

    public DeltaLakeConnectorFactory(Class<? extends Module> module) {
        this.module = Objects.requireNonNull(module, "module is null");
    }

    public String getName() {
        return CONNECTOR_NAME;
    }

    public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        ClassLoader classLoader = context.duplicatePluginClassLoader();
        try {
            Class<?> moduleClass = classLoader.loadClass(Module.class.getName());
            Object moduleInstance = classLoader.loadClass(this.module.getName()).getConstructor(new Class[0]).newInstance(new Object[0]);
            return (Connector)classLoader.loadClass(InternalDeltaLakeConnectorFactory.class.getName()).getMethod("createConnector", String.class, Map.class, ConnectorContext.class, Optional.class, moduleClass).invoke(null, catalogName, config, context, Optional.empty(), moduleInstance);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            Throwables.throwIfUnchecked((Throwable)targetException);
            throw new RuntimeException(targetException);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

