/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.reader.MetadataReader;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeParquetStatisticsUtils;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class DeltaLakeWriter
implements FileWriter {
    private final TrinoFileSystem fileSystem;
    private final FileWriter fileWriter;
    private final Path rootTableLocation;
    private final String relativeFilePath;
    private final List<String> partitionValues;
    private final DeltaLakeWriterStats stats;
    private final long creationTime;
    private final Set<Integer> timestampColumnIndices;
    private final List<DeltaLakeColumnHandle> columnHandles;
    private long rowCount;
    private long inputSizeInBytes;

    public DeltaLakeWriter(TrinoFileSystem fileSystem, FileWriter fileWriter, Path rootTableLocation, String relativeFilePath, List<String> partitionValues, DeltaLakeWriterStats stats, List<DeltaLakeColumnHandle> columnHandles) {
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
        this.rootTableLocation = Objects.requireNonNull(rootTableLocation, "rootTableLocation is null");
        this.relativeFilePath = Objects.requireNonNull(relativeFilePath, "relativeFilePath is null");
        this.partitionValues = partitionValues;
        this.stats = stats;
        this.creationTime = Instant.now().toEpochMilli();
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableSet.Builder timestampColumnIndices = ImmutableSet.builder();
        for (int i = 0; i < columnHandles.size(); ++i) {
            if (!(columnHandles.get(i).getType() instanceof TimestampWithTimeZoneType)) continue;
            timestampColumnIndices.add((Object)i);
        }
        this.timestampColumnIndices = timestampColumnIndices.build();
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.fileWriter.getMemoryUsage();
    }

    public void appendRows(Page originalPage) {
        Page page = originalPage;
        if (this.timestampColumnIndices.size() > 0) {
            Block[] translatedBlocks = new Block[originalPage.getChannelCount()];
            for (int index = 0; index < translatedBlocks.length; ++index) {
                Block originalBlock = originalPage.getBlock(index);
                translatedBlocks[index] = this.timestampColumnIndices.contains(index) ? new LazyBlock(originalBlock.getPositionCount(), (LazyBlockLoader)new TimestampTranslationBlockLoader(originalBlock)) : originalBlock;
            }
            page = new Page(originalPage.getPositionCount(), translatedBlocks);
        }
        this.stats.addInputPageSizesInBytes(page.getRetainedSizeInBytes());
        this.fileWriter.appendRows(page);
        this.rowCount += (long)page.getPositionCount();
        this.inputSizeInBytes += page.getSizeInBytes();
    }

    public Closeable commit() {
        return this.fileWriter.commit();
    }

    public void rollback() {
        this.fileWriter.rollback();
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public DataFileInfo getDataFileInfo() throws IOException {
        List dataColumnNames = (List)this.columnHandles.stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableList.toImmutableList());
        List dataColumnTypes = (List)this.columnHandles.stream().map(DeltaLakeColumnHandle::getType).collect(ImmutableList.toImmutableList());
        return new DataFileInfo(this.relativeFilePath, this.getWrittenBytes(), this.creationTime, this.partitionValues, DeltaLakeWriter.readStatistics(this.fileSystem, this.rootTableLocation, dataColumnNames, dataColumnTypes, this.relativeFilePath, this.rowCount));
    }

    private static DeltaLakeJsonFileStatistics readStatistics(TrinoFileSystem fileSystem, Path tableLocation, List<String> dataColumnNames, List<Type> dataColumnTypes, String relativeFilePath, Long rowCount) throws IOException {
        ImmutableMap.Builder typeForColumn = ImmutableMap.builder();
        for (int i = 0; i < dataColumnNames.size(); ++i) {
            typeForColumn.put((Object)dataColumnNames.get(i), (Object)dataColumnTypes.get(i));
        }
        TrinoInputFile inputFile = fileSystem.newInputFile(new Path(tableLocation, relativeFilePath).toString());
        try (TrinoParquetDataSource trinoParquetDataSource = new TrinoParquetDataSource(inputFile, new ParquetReaderOptions(), new FileFormatDataSourceStats());){
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)trinoParquetDataSource, Optional.empty());
            ImmutableMultimap.Builder metadataForColumn = ImmutableMultimap.builder();
            for (BlockMetaData blockMetaData : parquetMetadata.getBlocks()) {
                for (ColumnChunkMetaData columnChunkMetaData : blockMetaData.getColumns()) {
                    if (columnChunkMetaData.getPath().size() != 1) continue;
                    String columnName = (String)Iterables.getOnlyElement((Iterable)columnChunkMetaData.getPath());
                    metadataForColumn.put((Object)columnName, (Object)columnChunkMetaData);
                }
            }
            DeltaLakeJsonFileStatistics deltaLakeJsonFileStatistics = DeltaLakeWriter.mergeStats((Multimap<String, ColumnChunkMetaData>)metadataForColumn.build(), (Map<String, Type>)typeForColumn.buildOrThrow(), rowCount);
            return deltaLakeJsonFileStatistics;
        }
    }

    @VisibleForTesting
    static DeltaLakeJsonFileStatistics mergeStats(Multimap<String, ColumnChunkMetaData> metadataForColumn, Map<String, Type> typeForColumn, long rowCount) {
        Map statsForColumn = (Map)metadataForColumn.keySet().stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), key -> DeltaLakeWriter.mergeMetadataList(metadataForColumn.get(key))));
        Map nullCount = (Map)statsForColumn.entrySet().stream().filter(entry -> ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Statistics)((Optional)entry.getValue()).get()).getNumNulls()));
        return new DeltaLakeJsonFileStatistics(Optional.of(rowCount), Optional.of(DeltaLakeParquetStatisticsUtils.jsonEncodeMin(statsForColumn, typeForColumn)), Optional.of(DeltaLakeParquetStatisticsUtils.jsonEncodeMax(statsForColumn, typeForColumn)), Optional.of(nullCount));
    }

    private static Optional<Statistics<?>> mergeMetadataList(Collection<ColumnChunkMetaData> metadataList) {
        if (DeltaLakeParquetStatisticsUtils.hasInvalidStatistics(metadataList)) {
            return Optional.empty();
        }
        return metadataList.stream().map(ColumnChunkMetaData::getStatistics).reduce((statsA, statsB) -> {
            statsA.mergeStatistics(statsB);
            return statsA;
        });
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("relativeFilePath", (Object)this.relativeFilePath).add("partitionValues", this.partitionValues).add("creationTime", this.creationTime).add("rowCount", this.rowCount).add("inputSizeInBytes", this.inputSizeInBytes).toString();
    }

    private static final class TimestampTranslationBlockLoader
    implements LazyBlockLoader {
        private Block originalBlock;

        public TimestampTranslationBlockLoader(Block originalBlock) {
            this.originalBlock = Objects.requireNonNull(originalBlock, "originalBlock is null");
        }

        public Block load() {
            Preconditions.checkState((this.originalBlock != null ? 1 : 0) != 0, (Object)"Already loaded");
            int positionCount = this.originalBlock.getPositionCount();
            long[] values = new long[positionCount];
            boolean mayHaveNulls = this.originalBlock.mayHaveNull();
            boolean[] valueIsNull = mayHaveNulls ? new boolean[positionCount] : null;
            for (int position = 0; position < positionCount; ++position) {
                if (mayHaveNulls && this.originalBlock.isNull(position)) {
                    valueIsNull[position] = true;
                    continue;
                }
                values[position] = TimeUnit.MILLISECONDS.toMicros(DateTimeEncoding.unpackMillisUtc((long)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.getLong(this.originalBlock, position)));
            }
            LongArrayBlock mapped = new LongArrayBlock(positionCount, Optional.ofNullable(valueIsNull), values);
            this.originalBlock = null;
            return mapped;
        }
    }
}

