/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class CheckpointSchemaManager {
    private final TypeManager typeManager;
    private static final RowType TXN_ENTRY_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"appId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"version", (Type)BigintType.BIGINT), (Object)RowType.field((String)"lastUpdated", (Type)BigintType.BIGINT)));
    private static final RowType REMOVE_ENTRY_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"path", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"deletionTimestamp", (Type)BigintType.BIGINT), (Object)RowType.field((String)"dataChange", (Type)BooleanType.BOOLEAN)));
    private static final RowType PROTOCOL_ENTRY_TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"minReaderVersion", (Type)IntegerType.INTEGER), (Object)RowType.field((String)"minWriterVersion", (Type)IntegerType.INTEGER)));
    private final RowType metadataEntryType;
    private final RowType commitInfoEntryType;

    @Inject
    public CheckpointSchemaManager(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        ArrayType stringList = (ArrayType)this.typeManager.getType(TypeSignature.arrayType((TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        MapType stringMap = (MapType)this.typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.metadataEntryType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"id", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"name", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"description", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"format", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"provider", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"options", (Type)stringMap)))), (Object)RowType.field((String)"schemaString", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"partitionColumns", (Type)stringList), (Object)RowType.field((String)"configuration", (Type)stringMap), (Object)RowType.field((String)"createdTime", (Type)BigintType.BIGINT)));
        this.commitInfoEntryType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"version", (Type)BigintType.BIGINT), (Object)RowType.field((String)"timestamp", (Type)BigintType.BIGINT), (Object)RowType.field((String)"userId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"userName", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"operation", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"operationParameters", (Type)stringMap), (Object)RowType.field((String)"job", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"jobId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"jobName", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"runId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"jobOwnerId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"triggerType", (Type)VarcharType.createUnboundedVarcharType())))), (Object)RowType.field((String)"notebook", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"notebookId", (Type)VarcharType.createUnboundedVarcharType())))), (Object)RowType.field((String)"clusterId", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"readVersion", (Type)BigintType.BIGINT), (Object)RowType.field((String)"isolationLevel", (Type)VarcharType.createUnboundedVarcharType()), (Object)RowType.field((String)"isBlindAppend", (Type)BooleanType.BOOLEAN), (Object[])new RowType.Field[0]));
    }

    public RowType getMetadataEntryType() {
        return this.metadataEntryType;
    }

    public RowType getAddEntryType(MetadataEntry metadataEntry, boolean requireWriteStatsAsJson, boolean requireWriteStatsAsStruct) {
        List<DeltaLakeColumnMetadata> allColumns = DeltaLakeSchemaSupport.extractSchema(metadataEntry, this.typeManager);
        List<DeltaLakeColumnMetadata> minMaxColumns = TransactionLogAccess.columnsWithStats(metadataEntry, this.typeManager);
        ImmutableList.Builder minMaxFields = ImmutableList.builder();
        for (DeltaLakeColumnMetadata dataColumn : minMaxColumns) {
            Type type = dataColumn.getPhysicalColumnType();
            if (type instanceof TimestampWithTimeZoneType) {
                minMaxFields.add((Object)RowType.field((String)dataColumn.getPhysicalName(), (Type)TimestampType.TIMESTAMP_MILLIS));
                continue;
            }
            minMaxFields.add((Object)RowType.field((String)dataColumn.getPhysicalName(), (Type)type));
        }
        ImmutableList.Builder statsColumns = ImmutableList.builder();
        statsColumns.add((Object)RowType.field((String)"numRecords", (Type)BigintType.BIGINT));
        ImmutableList minMax = minMaxFields.build();
        if (!minMax.isEmpty()) {
            RowType minMaxType = RowType.from((List)minMax);
            statsColumns.add((Object)RowType.field((String)"minValues", (Type)minMaxType));
            statsColumns.add((Object)RowType.field((String)"maxValues", (Type)minMaxType));
        }
        statsColumns.add((Object)RowType.field((String)"nullCount", (Type)RowType.from((List)((List)allColumns.stream().map(column -> CheckpointSchemaManager.buildNullCountType(Optional.of(column.getPhysicalName()), column.getPhysicalColumnType())).collect(ImmutableList.toImmutableList())))));
        MapType stringMap = (MapType)this.typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ImmutableList.Builder addFields = ImmutableList.builder();
        addFields.add((Object)RowType.field((String)"path", (Type)VarcharType.createUnboundedVarcharType()));
        addFields.add((Object)RowType.field((String)"partitionValues", (Type)stringMap));
        addFields.add((Object)RowType.field((String)"size", (Type)BigintType.BIGINT));
        addFields.add((Object)RowType.field((String)"modificationTime", (Type)BigintType.BIGINT));
        addFields.add((Object)RowType.field((String)"dataChange", (Type)BooleanType.BOOLEAN));
        if (requireWriteStatsAsJson) {
            addFields.add((Object)RowType.field((String)"stats", (Type)VarcharType.createUnboundedVarcharType()));
        }
        if (requireWriteStatsAsStruct) {
            addFields.add((Object)RowType.field((String)"stats_parsed", (Type)RowType.from((List)statsColumns.build())));
        }
        addFields.add((Object)RowType.field((String)"tags", (Type)stringMap));
        return RowType.from((List)addFields.build());
    }

    private static RowType.Field buildNullCountType(Optional<String> columnName, Type columnType) {
        if (columnType instanceof RowType) {
            RowType rowType = (RowType)columnType;
            RowType rowTypeFromFields = RowType.from((List)((List)rowType.getFields().stream().map(field -> CheckpointSchemaManager.buildNullCountType(field.getName(), field.getType())).collect(ImmutableList.toImmutableList())));
            return new RowType.Field(columnName, (Type)rowTypeFromFields);
        }
        return new RowType.Field(columnName, (Type)BigintType.BIGINT);
    }

    public RowType getRemoveEntryType() {
        return REMOVE_ENTRY_TYPE;
    }

    public RowType getTxnEntryType() {
        return TXN_ENTRY_TYPE;
    }

    public RowType getProtocolEntryType() {
        return PROTOCOL_ENTRY_TYPE;
    }

    public RowType getCommitInfoEntryType() {
        return this.commitInfoEntryType;
    }
}

