/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.collect.ImmutableList;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.MissingTransactionLogException;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.Path;

public class TransactionLogTail {
    private static final int JSON_LOG_ENTRY_READ_BUFFER_SIZE = 0x100000;
    private final List<DeltaLakeTransactionLogEntry> entries;
    private final long version;

    private TransactionLogTail(List<DeltaLakeTransactionLogEntry> entries, long version) {
        this.entries = ImmutableList.copyOf((Collection)Objects.requireNonNull(entries, "entries is null"));
        this.version = version;
    }

    public static TransactionLogTail loadNewTail(TrinoFileSystem fileSystem, Path tableLocation, Optional<Long> startVersion) throws IOException {
        return TransactionLogTail.loadNewTail(fileSystem, tableLocation, startVersion, Optional.empty());
    }

    public static TransactionLogTail loadNewTail(TrinoFileSystem fileSystem, Path tableLocation, Optional<Long> startVersion, Optional<Long> endVersion) throws IOException {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        long version = startVersion.orElse(0L);
        long entryNumber = startVersion.map(start -> start + 1L).orElse(0L);
        Path transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        boolean endOfTail = false;
        while (!endOfTail) {
            Path path = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, entryNumber);
            Optional<List<DeltaLakeTransactionLogEntry>> results = TransactionLogTail.getEntriesFromJson(path, fileSystem);
            if (results.isPresent()) {
                entriesBuilder.addAll((Iterable)results.get());
                version = entryNumber++;
            } else {
                if (endVersion.isPresent()) {
                    throw new MissingTransactionLogException(path);
                }
                endOfTail = true;
            }
            if (!endVersion.isPresent() || version != endVersion.get()) continue;
            endOfTail = true;
        }
        return new TransactionLogTail((List<DeltaLakeTransactionLogEntry>)entriesBuilder.build(), version);
    }

    public Optional<TransactionLogTail> getUpdatedTail(TrinoFileSystem fileSystem, Path tableLocation) throws IOException {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        long newVersion = this.version;
        Path transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        boolean endOfTail = false;
        while (!endOfTail) {
            Optional<List<DeltaLakeTransactionLogEntry>> results = TransactionLogTail.getEntriesFromJson(TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, newVersion + 1L), fileSystem);
            if (results.isPresent()) {
                if (this.version == newVersion) {
                    entriesBuilder.addAll(this.entries);
                }
                entriesBuilder.addAll((Iterable)results.get());
                ++newVersion;
                continue;
            }
            endOfTail = true;
        }
        if (newVersion == this.version) {
            return Optional.empty();
        }
        return Optional.of(new TransactionLogTail((List<DeltaLakeTransactionLogEntry>)entriesBuilder.build(), newVersion));
    }

    public static Optional<List<DeltaLakeTransactionLogEntry>> getEntriesFromJson(Path transactionLogFilePath, TrinoFileSystem fileSystem) throws IOException {
        Optional<ImmutableList> optional;
        TrinoInputFile inputFile = fileSystem.newInputFile(transactionLogFilePath.toString());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputFile.newInput().inputStream(), StandardCharsets.UTF_8), 0x100000);
        try {
            ImmutableList.Builder resultsBuilder = ImmutableList.builder();
            String line = reader.readLine();
            while (line != null) {
                resultsBuilder.add((Object)TransactionLogParser.parseJson(line));
                line = reader.readLine();
            }
            optional = Optional.of(resultsBuilder.build());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                if (TransactionLogTail.isFileNotFoundException(e)) {
                    return Optional.empty();
                }
                throw new IOException(e);
            }
        }
        reader.close();
        return optional;
    }

    public static boolean isFileNotFoundException(IOException e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        return e.getMessage().contains("The specified key does not exist");
    }

    public List<DeltaLakeTransactionLogEntry> getFileEntries() {
        return this.entries;
    }

    public long getVersion() {
        return this.version;
    }
}

