/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.Page;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class DeltaLakeHistoryTable
implements SystemTable {
    private final ConnectorTableMetadata tableMetadata;
    private final List<CommitInfoEntry> commitInfoEntries;

    public DeltaLakeHistoryTable(SchemaTableName tableName, List<CommitInfoEntry> commitInfoEntries, TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.commitInfoEntries = (List)ImmutableList.copyOf((Collection)Objects.requireNonNull(commitInfoEntries, "commitInfoEntries is null")).stream().sorted(Comparator.comparingLong(CommitInfoEntry::getVersion).reversed()).collect(ImmutableList.toImmutableList());
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata("user_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("user_name", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation_parameters", typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("cluster_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("read_version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("isolation_level", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("is_blind_append", (Type)BooleanType.BOOLEAN)).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        if (this.commitInfoEntries.isEmpty()) {
            return new FixedPageSource((Iterable)ImmutableList.of());
        }
        return new FixedPageSource(this.buildPages(session));
    }

    private List<Page> buildPages(ConnectorSession session) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(this.tableMetadata);
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        this.commitInfoEntries.forEach(commitInfoEntry -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendBigint(commitInfoEntry.getVersion());
            pagesBuilder.appendTimestampTzMillis(commitInfoEntry.getTimestamp(), timeZoneKey);
            DeltaLakeHistoryTable.write(commitInfoEntry.getUserId(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.getUserName(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.getOperation(), pagesBuilder);
            if (commitInfoEntry.getOperationParameters() == null) {
                pagesBuilder.appendNull();
            } else {
                pagesBuilder.appendVarcharVarcharMap(commitInfoEntry.getOperationParameters());
            }
            DeltaLakeHistoryTable.write(commitInfoEntry.getClusterId(), pagesBuilder);
            pagesBuilder.appendBigint(commitInfoEntry.getReadVersion());
            DeltaLakeHistoryTable.write(commitInfoEntry.getIsolationLevel(), pagesBuilder);
            commitInfoEntry.isBlindAppend().ifPresentOrElse(pagesBuilder::appendBoolean, pagesBuilder::appendNull);
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void write(String value, PageListBuilder pagesBuilder) {
        if (value == null) {
            pagesBuilder.appendNull();
        } else {
            pagesBuilder.appendVarchar(value);
        }
    }
}

