/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.reader.MetadataReader;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakePageSource;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSourceProvider
implements ConnectorPageSourceProvider {
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final ParquetReaderOptions parquetReaderOptions;
    private final int domainCompactionThreshold;
    private final DateTimeZone parquetDateTimeZone;
    private final TypeManager typeManager;

    @Inject
    public DeltaLakePageSourceProvider(TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderConfig parquetReaderConfig, DeltaLakeConfig deltaLakeConfig, TypeManager typeManager) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions().withBloomFilter(false);
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        DeltaLakeSplit split = (DeltaLakeSplit)connectorSplit;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)connectorTable;
        TupleDomain filteredSplitPredicate = TupleDomain.intersect((List)ImmutableList.of(table.getNonPartitionConstraint(), split.getStatisticsPredicate(), (Object)dynamicFilter.getCurrentPredicate().transformKeys(DeltaLakeColumnHandle.class::cast)));
        if (filteredSplitPredicate.isNone()) {
            return new EmptyPageSource();
        }
        List deltaLakeColumns = (List)columns.stream().map(DeltaLakeColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        Map<String, Optional<String>> partitionKeys = split.getPartitionKeys();
        ArrayList<String> partitionValues = new ArrayList<String>();
        if (deltaLakeColumns.stream().anyMatch(column -> column.getName().equals("$row_id"))) {
            for (DeltaLakeColumnMetadata column2 : DeltaLakeSchemaSupport.extractSchema(table.getMetadataEntry(), this.typeManager)) {
                Optional<String> value = partitionKeys.get(column2.getName());
                if (value == null) continue;
                partitionValues.add(value.orElse(null));
            }
        }
        TrinoInputFile inputFile = this.fileSystemFactory.create(session).newInputFile(split.getPath(), split.getFileSize());
        ParquetReaderOptions options = this.parquetReaderOptions.withMaxReadBlockSize(DeltaLakeSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(DeltaLakeSessionProperties.getParquetMaxReadBlockRowCount(session)).withUseColumnIndex(DeltaLakeSessionProperties.isParquetUseColumnIndex(session)).withBatchColumnReaders(DeltaLakeSessionProperties.isParquetOptimizedReaderEnabled(session)).withBatchNestedColumnReaders(DeltaLakeSessionProperties.isParquetOptimizedNestedReaderEnabled(session));
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(table.getMetadataEntry());
        ImmutableMap parquetFieldIdToName = columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID ? this.loadParquetIdAndNameMapping(inputFile, options) : ImmutableMap.of();
        List regularColumns = (List)deltaLakeColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR || column.getName().equals("$row_id")).collect(ImmutableList.toImmutableList());
        ImmutableSet.Builder missingColumnNames = ImmutableSet.builder();
        ImmutableList.Builder hiveColumnHandles = ImmutableList.builder();
        for (DeltaLakeColumnHandle column3 : regularColumns) {
            if (column3.getName().equals("$row_id")) {
                hiveColumnHandles.add((Object)ParquetPageSourceFactory.PARQUET_ROW_INDEX_COLUMN);
                continue;
            }
            DeltaLakePageSourceProvider.toHiveColumnHandle(column3, columnMappingMode, (Map<Integer, String>)parquetFieldIdToName).ifPresentOrElse(arg_0 -> ((ImmutableList.Builder)hiveColumnHandles).add(arg_0), () -> missingColumnNames.add((Object)column3.getName()));
        }
        TupleDomain<HiveColumnHandle> parquetPredicate = DeltaLakePageSourceProvider.getParquetTupleDomain((TupleDomain<DeltaLakeColumnHandle>)filteredSplitPredicate.simplify(this.domainCompactionThreshold), columnMappingMode, (Map<Integer, String>)parquetFieldIdToName);
        ReaderPageSource pageSource = ParquetPageSourceFactory.createPageSource((TrinoInputFile)inputFile, (long)split.getStart(), (long)split.getLength(), (List)hiveColumnHandles.build(), parquetPredicate, (boolean)true, (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)this.fileFormatDataSourceStats, (ParquetReaderOptions)options, Optional.empty(), (int)this.domainCompactionThreshold);
        Verify.verify((boolean)pageSource.getReaderColumns().isEmpty(), (String)"All columns expected to be base columns", (Object[])new Object[0]);
        return new DeltaLakePageSource(deltaLakeColumns, (Set<String>)missingColumnNames.build(), partitionKeys, partitionValues, pageSource.get(), split.getPath(), split.getFileSize(), split.getFileModifiedTime());
    }

    public Map<Integer, String> loadParquetIdAndNameMapping(TrinoInputFile inputFile, ParquetReaderOptions options) {
        Map map;
        TrinoParquetDataSource dataSource = new TrinoParquetDataSource(inputFile, options, this.fileFormatDataSourceStats);
        try {
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            map = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Type::getName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        dataSource.close();
        return map;
    }

    public static TupleDomain<HiveColumnHandle> getParquetTupleDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate, DeltaLakeSchemaSupport.ColumnMappingMode columnMapping, Map<Integer, String> fieldIdToName) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            String baseType = columnHandle.getType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row"))) {
                Optional<HiveColumnHandle> hiveColumnHandle = DeltaLakePageSourceProvider.toHiveColumnHandle(columnHandle, columnMapping, fieldIdToName);
                hiveColumnHandle.ifPresent(column -> predicate.put(column, domain));
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    public static Optional<HiveColumnHandle> toHiveColumnHandle(DeltaLakeColumnHandle deltaLakeColumnHandle, DeltaLakeSchemaSupport.ColumnMappingMode columnMapping, Map<Integer, String> fieldIdToName) {
        switch (columnMapping) {
            case ID: {
                Integer fieldId = deltaLakeColumnHandle.getFieldId().orElseThrow(() -> new IllegalArgumentException("Field ID must exist"));
                if (!fieldIdToName.containsKey(fieldId)) {
                    return Optional.empty();
                }
                String fieldName = fieldIdToName.get(fieldId);
                return Optional.of(new HiveColumnHandle(fieldName, 0, DeltaHiveTypeTranslator.toHiveType(deltaLakeColumnHandle.getPhysicalType()), deltaLakeColumnHandle.getPhysicalType(), Optional.empty(), deltaLakeColumnHandle.getColumnType().toHiveColumnType(), Optional.empty()));
            }
            case NAME: 
            case NONE: {
                Preconditions.checkArgument((boolean)fieldIdToName.isEmpty(), (String)"Mapping between field id and name must be empty: %s", fieldIdToName);
                return Optional.of(deltaLakeColumnHandle.toHiveColumnHandle());
            }
        }
        throw new IllegalArgumentException("Unsupported column mapping: " + columnMapping);
    }
}

