/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DeltaLakeTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String location;
    private final Optional<MetadataEntry> metadataEntry;
    private final TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint;
    private final TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint;
    private final Optional<WriteType> writeType;
    private final long readVersion;
    private final boolean retriesEnabled;
    private final Optional<Set<ColumnHandle>> projectedColumns;
    private final Optional<List<DeltaLakeColumnHandle>> updatedColumns;
    private final Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns;
    private final Optional<AnalyzeHandle> analyzeHandle;
    private final boolean recordScannedFiles;
    private final Optional<DataSize> maxScannedFileSize;

    @JsonCreator
    public DeltaLakeTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="location") String location, @JsonProperty(value="metadataEntry") Optional<MetadataEntry> metadataEntry, @JsonProperty(value="enforcedPartitionConstraint") TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint, @JsonProperty(value="nonPartitionConstraint") TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint, @JsonProperty(value="writeType") Optional<WriteType> writeType, @JsonProperty(value="projectedColumns") Optional<Set<ColumnHandle>> projectedColumns, @JsonProperty(value="updatedColumns") Optional<List<DeltaLakeColumnHandle>> updatedColumns, @JsonProperty(value="updateRowIdColumns") Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns, @JsonProperty(value="analyzeHandle") Optional<AnalyzeHandle> analyzeHandle, @JsonProperty(value="readVersion") long readVersion, @JsonProperty(value="retriesEnabled") boolean retriesEnabled) {
        this(schemaName, tableName, location, metadataEntry, enforcedPartitionConstraint, nonPartitionConstraint, writeType, projectedColumns, updatedColumns, updateRowIdColumns, analyzeHandle, false, Optional.empty(), readVersion, retriesEnabled);
    }

    public DeltaLakeTableHandle(String schemaName, String tableName, String location, Optional<MetadataEntry> metadataEntry, TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint, TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint, Optional<WriteType> writeType, Optional<Set<ColumnHandle>> projectedColumns, Optional<List<DeltaLakeColumnHandle>> updatedColumns, Optional<List<DeltaLakeColumnHandle>> updateRowIdColumns, Optional<AnalyzeHandle> analyzeHandle, boolean recordScannedFiles, Optional<DataSize> maxScannedFileSize, long readVersion, boolean retriesEnabled) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.location = Objects.requireNonNull(location, "location is null");
        this.metadataEntry = Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        this.enforcedPartitionConstraint = Objects.requireNonNull(enforcedPartitionConstraint, "enforcedPartitionConstraint is null");
        this.nonPartitionConstraint = Objects.requireNonNull(nonPartitionConstraint, "nonPartitionConstraint is null");
        this.writeType = Objects.requireNonNull(writeType, "writeType is null");
        Preconditions.checkArgument((updatedColumns.isPresent() == (writeType.isPresent() && writeType.get() == WriteType.UPDATE) ? 1 : 0) != 0);
        Preconditions.checkArgument((updateRowIdColumns.isPresent() == (writeType.isPresent() && writeType.get() == WriteType.UPDATE) ? 1 : 0) != 0);
        this.projectedColumns = Objects.requireNonNull(projectedColumns, "projectedColumns is null");
        this.updatedColumns = Objects.requireNonNull(updatedColumns, "updatedColumns is null");
        this.updateRowIdColumns = Objects.requireNonNull(updateRowIdColumns, "rowIdColumns is null");
        this.analyzeHandle = Objects.requireNonNull(analyzeHandle, "analyzeHandle is null");
        this.recordScannedFiles = recordScannedFiles;
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
        this.readVersion = readVersion;
        this.retriesEnabled = retriesEnabled;
    }

    public static DeltaLakeTableHandle forDelete(String schemaName, String tableName, String location, Optional<MetadataEntry> metadataEntry, TupleDomain<DeltaLakeColumnHandle> enforcedConstraint, TupleDomain<DeltaLakeColumnHandle> unenforcedConstraint, Optional<Set<ColumnHandle>> projectedColumns, long readVersion, boolean retriesEnabled) {
        return new DeltaLakeTableHandle(schemaName, tableName, location, metadataEntry, enforcedConstraint, unenforcedConstraint, Optional.of(WriteType.DELETE), projectedColumns, Optional.empty(), Optional.empty(), Optional.empty(), readVersion, retriesEnabled);
    }

    public static DeltaLakeTableHandle forUpdate(String schemaName, String tableName, String location, Optional<MetadataEntry> metadataEntry, TupleDomain<DeltaLakeColumnHandle> enforcedConstraint, TupleDomain<DeltaLakeColumnHandle> unenforcedConstraint, Optional<Set<ColumnHandle>> projectedColumns, List<DeltaLakeColumnHandle> updatedColumns, List<DeltaLakeColumnHandle> updateRowIdColumns, long readVersion, boolean retriesEnabled) {
        Preconditions.checkArgument((!updatedColumns.isEmpty() ? 1 : 0) != 0, (Object)"Update must specify at least one column to set");
        return new DeltaLakeTableHandle(schemaName, tableName, location, metadataEntry, enforcedConstraint, unenforcedConstraint, Optional.of(WriteType.UPDATE), projectedColumns, Optional.of(updatedColumns), Optional.of(updateRowIdColumns), Optional.empty(), readVersion, retriesEnabled);
    }

    public DeltaLakeTableHandle withProjectedColumns(Set<ColumnHandle> projectedColumns) {
        return new DeltaLakeTableHandle(this.getSchemaName(), this.getTableName(), this.getLocation(), Optional.of(this.getMetadataEntry()), this.getEnforcedPartitionConstraint(), this.getNonPartitionConstraint(), this.getWriteType(), Optional.of(projectedColumns), this.getUpdatedColumns(), this.getUpdateRowIdColumns(), this.getAnalyzeHandle(), this.getReadVersion(), this.isRetriesEnabled());
    }

    public DeltaLakeTableHandle forOptimize(boolean recordScannedFiles, DataSize maxScannedFileSize) {
        return new DeltaLakeTableHandle(this.schemaName, this.tableName, this.location, this.metadataEntry, this.enforcedPartitionConstraint, this.nonPartitionConstraint, this.writeType, this.projectedColumns, this.updatedColumns, this.updateRowIdColumns, this.analyzeHandle, recordScannedFiles, Optional.of(maxScannedFileSize), this.readVersion, false);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getLocation() {
        return this.location;
    }

    @JsonProperty
    public MetadataEntry getMetadataEntry() {
        return this.metadataEntry.orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Metadata not found in transaction log for " + this.tableName));
    }

    @JsonProperty
    public TupleDomain<DeltaLakeColumnHandle> getEnforcedPartitionConstraint() {
        return this.enforcedPartitionConstraint;
    }

    @JsonProperty
    public TupleDomain<DeltaLakeColumnHandle> getNonPartitionConstraint() {
        return this.nonPartitionConstraint;
    }

    @JsonProperty
    public Optional<WriteType> getWriteType() {
        return this.writeType;
    }

    @JsonIgnore
    public Optional<Set<ColumnHandle>> getProjectedColumns() {
        return this.projectedColumns;
    }

    @JsonProperty
    public Optional<List<DeltaLakeColumnHandle>> getUpdatedColumns() {
        return this.updatedColumns;
    }

    @JsonProperty
    public Optional<List<DeltaLakeColumnHandle>> getUpdateRowIdColumns() {
        return this.updateRowIdColumns;
    }

    @JsonProperty
    public Optional<AnalyzeHandle> getAnalyzeHandle() {
        return this.analyzeHandle;
    }

    @JsonIgnore
    public boolean isRecordScannedFiles() {
        return this.recordScannedFiles;
    }

    @JsonIgnore
    public Optional<DataSize> getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    @JsonProperty
    public long getReadVersion() {
        return this.readVersion;
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }

    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public String toString() {
        return this.getSchemaTableName().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeTableHandle that = (DeltaLakeTableHandle)o;
        return this.recordScannedFiles == that.recordScannedFiles && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.location, that.location) && Objects.equals(this.metadataEntry, that.metadataEntry) && Objects.equals(this.enforcedPartitionConstraint, that.enforcedPartitionConstraint) && Objects.equals(this.nonPartitionConstraint, that.nonPartitionConstraint) && Objects.equals(this.writeType, that.writeType) && Objects.equals(this.projectedColumns, that.projectedColumns) && Objects.equals(this.updatedColumns, that.updatedColumns) && Objects.equals(this.updateRowIdColumns, that.updateRowIdColumns) && Objects.equals(this.analyzeHandle, that.analyzeHandle) && Objects.equals(this.maxScannedFileSize, that.maxScannedFileSize) && this.readVersion == that.readVersion && this.retriesEnabled == that.retriesEnabled;
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.location, this.metadataEntry, this.enforcedPartitionConstraint, this.nonPartitionConstraint, this.writeType, this.projectedColumns, this.updatedColumns, this.updateRowIdColumns, this.analyzeHandle, this.recordScannedFiles, this.maxScannedFileSize, this.readVersion, this.retriesEnabled);
    }

    public static enum WriteType {
        UPDATE,
        DELETE;

    }
}

