/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeJsonFileStatistics;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeParquetFileStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class AddFileEntry {
    private static final Logger LOG = Logger.get(AddFileEntry.class);
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(AddFileEntry.class).instanceSize();
    private final String path;
    private final Map<String, String> partitionValues;
    private final Map<String, Optional<String>> canonicalPartitionValues;
    private final long size;
    private final long modificationTime;
    private final boolean dataChange;
    private final Map<String, String> tags;
    private final Optional<? extends DeltaLakeFileStatistics> parsedStats;

    @JsonCreator
    public AddFileEntry(@JsonProperty(value="path") String path, @JsonProperty(value="partitionValues") Map<String, String> partitionValues, @JsonProperty(value="size") long size, @JsonProperty(value="modificationTime") long modificationTime, @JsonProperty(value="dataChange") boolean dataChange, @JsonProperty(value="stats") Optional<String> stats, @JsonProperty(value="parsedStats") Optional<DeltaLakeParquetFileStatistics> parsedStats, @JsonProperty(value="tags") @Nullable Map<String, String> tags) {
        this.path = path;
        this.partitionValues = partitionValues;
        this.canonicalPartitionValues = (Map)partitionValues.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> TransactionLogAccess.canonicalizeColumnName((String)entry.getKey()), entry -> {
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }));
        this.size = size;
        this.modificationTime = modificationTime;
        this.dataChange = dataChange;
        this.tags = tags;
        Optional<Object> resultParsedStats = Optional.empty();
        if (parsedStats.isPresent()) {
            resultParsedStats = parsedStats;
        } else if (stats.isPresent()) {
            try {
                resultParsedStats = Optional.ofNullable(DeltaLakeJsonFileStatistics.create(stats.get()));
            }
            catch (JsonProcessingException e) {
                LOG.debug((Throwable)e, "File level stats could not be parsed and will be ignored. The JSON string was: %s", new Object[]{stats.get()});
            }
        }
        this.parsedStats = resultParsedStats;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    @Deprecated
    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonIgnore
    public Map<String, Optional<String>> getCanonicalPartitionValues() {
        return this.canonicalPartitionValues;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public long getModificationTime() {
        return this.modificationTime;
    }

    @JsonProperty(value="dataChange")
    public boolean isDataChange() {
        return this.dataChange;
    }

    @JsonProperty(value="stats")
    public Optional<String> getStatsString() {
        if (this.parsedStats.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(DeltaLakeSchemaSupport.serializeStatsAsJson(this.parsedStats.get()));
        }
        catch (JsonProcessingException e) {
            return Optional.empty();
        }
    }

    public Optional<? extends DeltaLakeFileStatistics> getStats() {
        return this.parsedStats;
    }

    @Nullable
    @JsonProperty
    public Map<String, String> getTags() {
        return this.tags;
    }

    public String toString() {
        return String.format("AddFileEntry{path=%s, partitionValues=%s, size=%d, modificationTime=%d, dataChange=%b, parsedStats=%s, tags=%s}", this.path, this.partitionValues, this.size, this.modificationTime, this.dataChange, this.parsedStats, this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddFileEntry that = (AddFileEntry)o;
        return this.size == that.size && this.modificationTime == that.modificationTime && this.dataChange == that.dataChange && Objects.equals(this.path, that.path) && Objects.equals(this.partitionValues, that.partitionValues) && Objects.equals(this.canonicalPartitionValues, that.canonicalPartitionValues) && Objects.equals(this.tags, that.tags) && Objects.equals(this.parsedStats, that.parsedStats);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.partitionValues, this.canonicalPartitionValues, this.size, this.modificationTime, this.dataChange, this.tags, this.parsedStats);
    }

    public long getRetainedSizeInBytes() {
        long totalSize = INSTANCE_SIZE;
        totalSize += SizeOf.estimatedSizeOf((String)this.path);
        if (this.parsedStats.isPresent()) {
            totalSize += this.parsedStats.get().getRetainedSizeInBytes();
        }
        totalSize += SizeOf.estimatedSizeOf(this.partitionValues, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf);
        return totalSize += SizeOf.estimatedSizeOf(this.tags, SizeOf::estimatedSizeOf, SizeOf::estimatedSizeOf);
    }
}

