/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DeltaLakeColumnHandle
implements ColumnHandle {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeColumnHandle.class);
    public static final String ROW_ID_COLUMN_NAME = "$row_id";
    public static final Type MERGE_ROW_ID_TYPE = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"path", (Type)VarcharType.VARCHAR), RowType.field((String)"position", (Type)BigintType.BIGINT), RowType.field((String)"partition", (Type)VarcharType.VARCHAR)});
    public static final String PATH_COLUMN_NAME = "$path";
    public static final Type PATH_TYPE = VarcharType.VARCHAR;
    public static final String FILE_SIZE_COLUMN_NAME = "$file_size";
    public static final Type FILE_SIZE_TYPE = BigintType.BIGINT;
    public static final String FILE_MODIFIED_TIME_COLUMN_NAME = "$file_modified_time";
    public static final Type FILE_MODIFIED_TIME_TYPE = TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS;
    private final String name;
    private final Type type;
    private final OptionalInt fieldId;
    private final String physicalName;
    private final Type physicalType;
    private final DeltaLakeColumnType columnType;

    @JsonCreator
    public DeltaLakeColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type, @JsonProperty(value="fieldId") OptionalInt fieldId, @JsonProperty(value="physicalName") String physicalName, @JsonProperty(value="physicalType") Type physicalType, @JsonProperty(value="columnType") DeltaLakeColumnType columnType) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.fieldId = Objects.requireNonNull(fieldId, "fieldId is null");
        this.physicalName = Objects.requireNonNull(physicalName, "physicalName is null");
        this.physicalType = Objects.requireNonNull(physicalType, "physicalType is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public OptionalInt getFieldId() {
        return this.fieldId;
    }

    @JsonProperty
    public String getPhysicalName() {
        return this.physicalName;
    }

    @JsonProperty
    public Type getPhysicalType() {
        return this.physicalType;
    }

    @JsonProperty
    public DeltaLakeColumnType getColumnType() {
        return this.columnType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeltaLakeColumnHandle other = (DeltaLakeColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type) && Objects.equals(this.fieldId, other.fieldId) && Objects.equals(this.physicalName, other.physicalName) && Objects.equals(this.physicalType, other.physicalType) && this.columnType == other.columnType;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.fieldId, this.physicalName, this.physicalType, this.columnType});
    }

    public String toString() {
        return this.name + ":" + this.type.getDisplayName() + ":" + this.columnType;
    }

    public HiveColumnHandle toHiveColumnHandle() {
        return new HiveColumnHandle(this.physicalName, 0, DeltaHiveTypeTranslator.toHiveType(this.physicalType), this.physicalType, Optional.empty(), this.columnType.toHiveColumnType(), Optional.empty());
    }

    public static DeltaLakeColumnHandle pathColumnHandle() {
        return new DeltaLakeColumnHandle(PATH_COLUMN_NAME, PATH_TYPE, OptionalInt.empty(), PATH_COLUMN_NAME, PATH_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }

    public static DeltaLakeColumnHandle fileSizeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, OptionalInt.empty(), FILE_SIZE_COLUMN_NAME, FILE_SIZE_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }

    public static DeltaLakeColumnHandle fileModifiedTimeColumnHandle() {
        return new DeltaLakeColumnHandle(FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, OptionalInt.empty(), FILE_MODIFIED_TIME_COLUMN_NAME, FILE_MODIFIED_TIME_TYPE, DeltaLakeColumnType.SYNTHESIZED);
    }
}

