/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.cloud.hadoop.fs.gcs.TrinoGoogleHadoopFileSystemConfiguration;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.HttpTransport;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.JsonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.json.jackson2.JacksonFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.GoogleCloudStorageOptions;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.CredentialFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.HttpTransportFactory;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RedactedString;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.util.RetryHttpInitializer;
import com.google.common.base.Strings;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.plugin.hive.gcs.HiveGcsConfig;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.hadoop.fs.Path;

public class GcsStorageFactory {
    private static final String APPLICATION_NAME = "Trino-Delta-Lake";
    private final HdfsEnvironment hdfsEnvironment;
    private final boolean useGcsAccessToken;
    @Nullable
    private final Optional<GoogleCredential> jsonGoogleCredential;

    @Inject
    public GcsStorageFactory(HdfsEnvironment hdfsEnvironment, HiveGcsConfig hiveGcsConfig) throws IOException {
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.useGcsAccessToken = hiveGcsConfig.isUseGcsAccessToken();
        String jsonKeyFilePath = hiveGcsConfig.getJsonKeyFilePath();
        if (jsonKeyFilePath != null) {
            try (FileInputStream inputStream = new FileInputStream(jsonKeyFilePath);){
                this.jsonGoogleCredential = Optional.of(GoogleCredential.fromStream((InputStream)inputStream).createScoped((Collection)CredentialFactory.DEFAULT_SCOPES));
            }
        } else {
            this.jsonGoogleCredential = Optional.empty();
        }
    }

    public Storage create(ConnectorSession session, Path path) {
        try {
            GoogleCredential credential;
            GoogleCloudStorageOptions gcsOptions = TrinoGoogleHadoopFileSystemConfiguration.getGcsOptionsBuilder(this.hdfsEnvironment.getConfiguration(new HdfsContext(session), path)).build();
            HttpTransport httpTransport = HttpTransportFactory.createHttpTransport((HttpTransportFactory.HttpTransportType)gcsOptions.getTransportType(), (String)gcsOptions.getProxyAddress(), (RedactedString)gcsOptions.getProxyUsername(), (RedactedString)gcsOptions.getProxyPassword(), (Duration)Duration.ofMillis(gcsOptions.getHttpRequestReadTimeout()));
            if (this.useGcsAccessToken) {
                String accessToken = Strings.nullToEmpty((String)((String)session.getIdentity().getExtraCredentials().get("hive.gcs.oauth")));
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(accessToken.getBytes(StandardCharsets.UTF_8));){
                    credential = GoogleCredential.fromStream((InputStream)inputStream).createScoped((Collection)CredentialFactory.DEFAULT_SCOPES);
                }
            } else {
                credential = this.jsonGoogleCredential.get();
            }
            return new Storage.Builder(httpTransport, (JsonFactory)JacksonFactory.getDefaultInstance(), (HttpRequestInitializer)new RetryHttpInitializer((Credential)credential, APPLICATION_NAME)).setApplicationName(APPLICATION_NAME).build();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

