/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import io.trino.plugin.deltalake.expression.BooleanLiteral;
import io.trino.plugin.deltalake.expression.ComparisonExpression;
import io.trino.plugin.deltalake.expression.Identifier;
import io.trino.plugin.deltalake.expression.LogicalExpression;
import io.trino.plugin.deltalake.expression.LongLiteral;
import io.trino.plugin.deltalake.expression.SparkExpression;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import io.trino.plugin.deltalake.expression.StringLiteral;

public final class SparkExpressionConverter {
    private SparkExpressionConverter() {
    }

    public static String toTrinoExpression(SparkExpression expression) {
        return (String)new Formatter().process(expression, null);
    }

    private static class Formatter
    extends SparkExpressionTreeVisitor<String, Void> {
        private Formatter() {
        }

        @Override
        protected String visitExpression(SparkExpression node, Void context) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected String visitComparisonExpression(ComparisonExpression node, Void context) {
            return "(%s %s %s)".formatted(this.process(node.getLeft(), context), node.getOperator().getValue(), this.process(node.getRight(), context));
        }

        @Override
        protected String visitLogicalExpression(LogicalExpression node, Void context) {
            return "(%s %s %s)".formatted(this.process(node.getLeft(), context), node.getOperator().toString(), this.process(node.getRight(), context));
        }

        @Override
        protected String visitIdentifier(Identifier node, Void context) {
            return "\"" + node.getValue().replace("\"", "\"\"") + "\"";
        }

        @Override
        protected String visitBooleanLiteral(BooleanLiteral node, Void context) {
            return Boolean.toString(node.getValue());
        }

        @Override
        protected String visitLongLiteral(LongLiteral node, Void context) {
            return Long.toString(node.getValue());
        }

        @Override
        protected String visitStringLiteral(StringLiteral node, Void context) {
            return "'" + node.getValue().replace("'", "''") + "'";
        }
    }
}

