/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.procedure.DeltaTableProcedureHandle;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DeltaTableOptimizeHandle
extends DeltaTableProcedureHandle {
    private final MetadataEntry metadataEntry;
    private final List<DeltaLakeColumnHandle> tableColumns;
    private final List<String> originalPartitionColumns;
    private final DataSize maxScannedFileSize;
    private final Optional<Long> currentVersion;
    private final boolean retriesEnabled;

    @JsonCreator
    public DeltaTableOptimizeHandle(MetadataEntry metadataEntry, List<DeltaLakeColumnHandle> tableColumns, List<String> originalPartitionColumns, DataSize maxScannedFileSize, Optional<Long> currentVersion, boolean retriesEnabled) {
        this.metadataEntry = Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        this.tableColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableColumns, "tableColumns is null"));
        this.originalPartitionColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(originalPartitionColumns, "originalPartitionColumns is null"));
        this.maxScannedFileSize = Objects.requireNonNull(maxScannedFileSize, "maxScannedFileSize is null");
        this.currentVersion = Objects.requireNonNull(currentVersion, "currentVersion is null");
        this.retriesEnabled = retriesEnabled;
    }

    public DeltaTableOptimizeHandle withCurrentVersion(long currentVersion) {
        Preconditions.checkState((boolean)this.currentVersion.isEmpty(), (Object)"currentVersion already set");
        return new DeltaTableOptimizeHandle(this.metadataEntry, this.tableColumns, this.originalPartitionColumns, this.maxScannedFileSize, Optional.of(currentVersion), this.retriesEnabled);
    }

    @JsonProperty
    public MetadataEntry getMetadataEntry() {
        return this.metadataEntry;
    }

    @JsonProperty
    public List<DeltaLakeColumnHandle> getTableColumns() {
        return this.tableColumns;
    }

    @JsonProperty
    public List<String> getOriginalPartitionColumns() {
        return this.originalPartitionColumns;
    }

    @JsonProperty
    public Optional<Long> getCurrentVersion() {
        return this.currentVersion;
    }

    @JsonProperty
    public DataSize getMaxScannedFileSize() {
        return this.maxScannedFileSize;
    }

    @JsonProperty
    public boolean isRetriesEnabled() {
        return this.retriesEnabled;
    }
}

