/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.parquet.writer.ParquetSchemaConverter;
import io.trino.parquet.writer.ParquetWriterOptions;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeTypes;
import io.trino.plugin.deltalake.DeltaLakeWriter;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.parquet.ParquetFileWriter;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.HiveWriteUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.parquet.format.CompressionCodec;

public abstract class AbstractDeltaLakePageSink
implements ConnectorPageSink {
    private static final Logger LOG = Logger.get(AbstractDeltaLakePageSink.class);
    private static final int MAX_PAGE_POSITIONS = 4096;
    private final TypeOperators typeOperators;
    private final List<DeltaLakeColumnHandle> dataColumnHandles;
    private final int[] dataColumnInputIndex;
    private final List<String> dataColumnNames;
    private final List<Type> dataColumnTypes;
    private final int[] partitionColumnsInputIndex;
    private final List<String> originalPartitionColumnNames;
    private final List<Type> partitionColumnTypes;
    private final PageIndexer pageIndexer;
    private final TrinoFileSystem fileSystem;
    private final int maxOpenWriters;
    protected final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final List<DeltaLakeWriter> writers = new ArrayList<DeltaLakeWriter>();
    private final String tableLocation;
    protected final String outputPathDirectory;
    private final ConnectorSession session;
    private final DeltaLakeWriterStats stats;
    private final String trinoVersion;
    private final long targetMaxFileSize;
    private long writtenBytes;
    private long memoryUsage;
    private final List<Closeable> closedWriterRollbackActions = new ArrayList<Closeable>();
    protected final ImmutableList.Builder<DataFileInfo> dataFileInfos = ImmutableList.builder();

    public AbstractDeltaLakePageSink(TypeOperators typeOperators, List<DeltaLakeColumnHandle> inputColumns, List<String> originalPartitionColumns, PageIndexerFactory pageIndexerFactory, TrinoFileSystemFactory fileSystemFactory, int maxOpenWriters, JsonCodec<DataFileInfo> dataFileInfoCodec, String tableLocation, String outputPathDirectory, ConnectorSession session, DeltaLakeWriterStats stats, String trinoVersion) {
        this.typeOperators = Objects.requireNonNull(typeOperators, "typeOperators is null");
        Objects.requireNonNull(inputColumns, "inputColumns is null");
        Objects.requireNonNull(pageIndexerFactory, "pageIndexerFactory is null");
        this.fileSystem = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null").create(session);
        this.maxOpenWriters = maxOpenWriters;
        this.dataFileInfoCodec = Objects.requireNonNull(dataFileInfoCodec, "dataFileInfoCodec is null");
        int[] partitionColumnInputIndex = new int[originalPartitionColumns.size()];
        ImmutableList.Builder dataColumnsInputIndex = ImmutableList.builder();
        Object[] partitionColumnTypes = new Type[originalPartitionColumns.size()];
        Object[] originalPartitionColumnNames = new String[originalPartitionColumns.size()];
        ImmutableList.Builder dataColumnHandles = ImmutableList.builder();
        ImmutableList.Builder dataColumnTypes = ImmutableList.builder();
        ImmutableList.Builder dataColumnNames = ImmutableList.builder();
        HashMap<String, String> canonicalToOriginalPartitionColumns = new HashMap<String, String>();
        HashMap<String, Integer> canonicalToOriginalPartitionPositions = new HashMap<String, Integer>();
        int partitionColumnPosition = 0;
        for (String partitionColumnName : originalPartitionColumns) {
            String canonicalizeColumnName = TransactionLogAccess.canonicalizeColumnName(partitionColumnName);
            canonicalToOriginalPartitionColumns.put(canonicalizeColumnName, partitionColumnName);
            canonicalToOriginalPartitionPositions.put(canonicalizeColumnName, partitionColumnPosition++);
        }
        block6: for (int inputIndex = 0; inputIndex < inputColumns.size(); ++inputIndex) {
            DeltaLakeColumnHandle column = inputColumns.get(inputIndex);
            switch (column.getColumnType()) {
                case PARTITION_KEY: {
                    int partitionPosition = (Integer)canonicalToOriginalPartitionPositions.get(column.getName());
                    partitionColumnInputIndex[partitionPosition] = inputIndex;
                    originalPartitionColumnNames[partitionPosition] = (String)canonicalToOriginalPartitionColumns.get(column.getName());
                    partitionColumnTypes[partitionPosition] = column.getType();
                    continue block6;
                }
                case REGULAR: {
                    dataColumnHandles.add((Object)column);
                    dataColumnsInputIndex.add((Object)inputIndex);
                    dataColumnNames.add((Object)column.getName());
                    dataColumnTypes.add((Object)column.getType());
                    continue block6;
                }
                case SYNTHESIZED: {
                    this.processSynthesizedColumn(column);
                    continue block6;
                }
                default: {
                    throw new IllegalStateException("Unexpected column type: " + column.getColumnType());
                }
            }
        }
        this.addSpecialColumns(inputColumns, (ImmutableList.Builder<DeltaLakeColumnHandle>)dataColumnHandles, (ImmutableList.Builder<Integer>)dataColumnsInputIndex, (ImmutableList.Builder<String>)dataColumnNames, (ImmutableList.Builder<Type>)dataColumnTypes);
        this.partitionColumnsInputIndex = partitionColumnInputIndex;
        this.dataColumnInputIndex = Ints.toArray((Collection)dataColumnsInputIndex.build());
        this.originalPartitionColumnNames = ImmutableList.copyOf((Object[])originalPartitionColumnNames);
        this.dataColumnHandles = dataColumnHandles.build();
        this.partitionColumnTypes = ImmutableList.copyOf((Object[])partitionColumnTypes);
        this.dataColumnNames = dataColumnNames.build();
        this.dataColumnTypes = dataColumnTypes.build();
        this.pageIndexer = pageIndexerFactory.createPageIndexer(this.partitionColumnTypes);
        this.tableLocation = tableLocation;
        this.outputPathDirectory = outputPathDirectory;
        this.session = Objects.requireNonNull(session, "session is null");
        this.stats = stats;
        this.trinoVersion = Objects.requireNonNull(trinoVersion, "trinoVersion is null");
        this.targetMaxFileSize = DeltaLakeSessionProperties.getTargetMaxFileSize(session);
    }

    protected abstract void processSynthesizedColumn(DeltaLakeColumnHandle var1);

    protected abstract void addSpecialColumns(List<DeltaLakeColumnHandle> var1, ImmutableList.Builder<DeltaLakeColumnHandle> var2, ImmutableList.Builder<Integer> var3, ImmutableList.Builder<String> var4, ImmutableList.Builder<Type> var5);

    protected abstract String getPathPrefix();

    protected abstract DataFileInfo.DataFileType getDataFileType();

    public long getCompletedBytes() {
        return this.writtenBytes;
    }

    public long getMemoryUsage() {
        return this.memoryUsage;
    }

    public long getValidationCpuNanos() {
        return 0L;
    }

    public CompletableFuture<Collection<Slice>> finish() {
        for (int writerIndex = 0; writerIndex < this.writers.size(); ++writerIndex) {
            this.closeWriter(writerIndex);
        }
        this.writers.clear();
        ImmutableList dataFilesInfo = this.dataFileInfos.build();
        Collection result = (Collection)dataFilesInfo.stream().map(dataFileInfo -> Slices.wrappedBuffer((byte[])this.dataFileInfoCodec.toJsonBytes(dataFileInfo))).collect(ImmutableList.toImmutableList());
        return MoreFutures.toCompletableFuture((ListenableFuture)Futures.immediateFuture((Object)result));
    }

    public void abort() {
        List rollbackActions = (List)Streams.concat((Stream[])new Stream[]{this.writers.stream().filter(Objects::nonNull).map(writer -> writer::rollback), this.closedWriterRollbackActions.stream()}).collect(ImmutableList.toImmutableList());
        Throwable rollbackException = null;
        for (Closeable rollbackAction : rollbackActions) {
            try {
                rollbackAction.close();
            }
            catch (Throwable t) {
                if (rollbackException == null) {
                    rollbackException = new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error rolling back write to Delta Lake");
                }
                rollbackException.addSuppressed(t);
            }
        }
        if (rollbackException != null) {
            throw rollbackException;
        }
    }

    public CompletableFuture<?> appendPage(Page page) {
        if (page.getPositionCount() == 0) {
            return NOT_BLOCKED;
        }
        while (page.getPositionCount() > 4096) {
            Page chunk = page.getRegion(0, 4096);
            page = page.getRegion(4096, page.getPositionCount() - 4096);
            this.writePage(chunk);
        }
        this.writePage(page);
        return NOT_BLOCKED;
    }

    private void writePage(Page page) {
        int index;
        int[] writerIndexes = this.getWriterIndexes(page);
        int[] sizes = new int[this.writers.size()];
        int[] nArray = writerIndexes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = index = nArray[i];
            sizes[n2] = sizes[n2] + 1;
        }
        int[][] writerPositions = new int[this.writers.size()][];
        int[] counts = new int[this.writers.size()];
        int position = 0;
        while (position < page.getPositionCount()) {
            index = writerIndexes[position];
            int count = counts[index];
            if (count == 0) {
                writerPositions[index] = new int[sizes[index]];
            }
            writerPositions[index][count] = position++;
            counts[index] = count + 1;
        }
        Page dataPage = this.getDataPage(page);
        for (index = 0; index < writerPositions.length; ++index) {
            int[] positions = writerPositions[index];
            if (positions == null) continue;
            Page pageForWriter = dataPage;
            if (positions.length != dataPage.getPositionCount()) {
                Verify.verify((positions.length == counts[index] ? 1 : 0) != 0);
                pageForWriter = pageForWriter.getPositions(positions, 0, positions.length);
            }
            DeltaLakeWriter writer = this.writers.get(index);
            long currentWritten = writer.getWrittenBytes();
            long currentMemory = writer.getMemoryUsage();
            writer.appendRows(pageForWriter);
            this.writtenBytes += writer.getWrittenBytes() - currentWritten;
            this.memoryUsage += writer.getMemoryUsage() - currentMemory;
        }
    }

    private int[] getWriterIndexes(Page page) {
        Page partitionColumns = AbstractDeltaLakePageSink.extractColumns(page, this.partitionColumnsInputIndex);
        int[] writerIndexes = this.pageIndexer.indexPage(partitionColumns);
        if (this.pageIndexer.getMaxIndex() >= this.maxOpenWriters) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, String.format("Exceeded limit of %s open writers for partitions", this.maxOpenWriters));
        }
        while (this.writers.size() <= this.pageIndexer.getMaxIndex()) {
            this.writers.add(null);
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int writerIndex = writerIndexes[position];
            DeltaLakeWriter deltaLakeWriter = this.writers.get(writerIndex);
            if (deltaLakeWriter != null) {
                if (deltaLakeWriter.getWrittenBytes() <= this.targetMaxFileSize) continue;
                this.closeWriter(writerIndex);
            }
            String filePath = this.outputPathDirectory;
            List<String> partitionValues = AbstractDeltaLakePageSink.createPartitionValues(this.partitionColumnTypes, partitionColumns, position);
            Optional<String> partitionName = Optional.empty();
            if (!this.originalPartitionColumnNames.isEmpty()) {
                String partName = AbstractDeltaLakePageSink.makePartName(this.originalPartitionColumnNames, partitionValues);
                filePath = Locations.appendPath((String)this.outputPathDirectory, (String)partName);
                partitionName = Optional.of(partName);
            }
            String fileName = this.session.getQueryId() + "-" + UUID.randomUUID();
            filePath = Locations.appendPath((String)filePath, (String)fileName);
            FileWriter fileWriter = this.createParquetFileWriter(filePath);
            DeltaLakeWriter writer = new DeltaLakeWriter(this.fileSystem, fileWriter, this.tableLocation, this.getRelativeFilePath(partitionName, fileName), partitionValues, this.stats, this.dataColumnHandles, this.getDataFileType());
            this.writers.set(writerIndex, writer);
            this.memoryUsage += writer.getMemoryUsage();
        }
        Verify.verify((this.writers.size() == this.pageIndexer.getMaxIndex() + 1 ? 1 : 0) != 0);
        Verify.verify((!this.writers.contains(null) ? 1 : 0) != 0);
        return writerIndexes;
    }

    private String getRelativeFilePath(Optional<String> partitionName, String fileName) {
        return this.getPathPrefix() + partitionName.map(partition -> Locations.appendPath((String)partition, (String)fileName)).orElse(fileName);
    }

    protected void closeWriter(int writerIndex) {
        DeltaLakeWriter writer = this.writers.get(writerIndex);
        long currentWritten = writer.getWrittenBytes();
        long currentMemory = writer.getMemoryUsage();
        this.closedWriterRollbackActions.add(writer.commit());
        this.writtenBytes += writer.getWrittenBytes() - currentWritten;
        this.memoryUsage -= currentMemory;
        this.writers.set(writerIndex, null);
        try {
            DataFileInfo dataFileInfo = writer.getDataFileInfo();
            this.dataFileInfos.add((Object)dataFileInfo);
        }
        catch (IOException e) {
            LOG.warn("exception '%s' while finishing write on %s", new Object[]{e, writer});
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error committing Parquet file to Delta Lake", (Throwable)e);
        }
    }

    private static String makePartName(List<String> partitionColumns, List<String> partitionValues) {
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < partitionColumns.size(); ++i) {
            if (i > 0) {
                name.append("/");
            }
            name.append(HiveUtil.escapePathName((String)partitionColumns.get(i)));
            name.append('=');
            name.append(HiveUtil.escapePathName((String)partitionValues.get(i)));
        }
        return name.toString();
    }

    public static List<String> createPartitionValues(List<Type> partitionColumnTypes, Page partitionColumns, int position) {
        return HiveWriteUtils.createPartitionValues(partitionColumnTypes, (Page)partitionColumns, (int)position).stream().map(value -> value.equals("__HIVE_DEFAULT_PARTITION__") ? null : value).collect(Collectors.toList());
    }

    private FileWriter createParquetFileWriter(String path) {
        ParquetWriterOptions parquetWriterOptions = ParquetWriterOptions.builder().setMaxBlockSize(DeltaLakeSessionProperties.getParquetWriterBlockSize(this.session)).setMaxPageSize(DeltaLakeSessionProperties.getParquetWriterPageSize(this.session)).build();
        CompressionCodec compressionCodec = DeltaLakeSessionProperties.getCompressionCodec(this.session).getParquetCompressionCodec();
        try {
            Closeable rollbackAction = () -> this.fileSystem.deleteFile(path);
            List parquetTypes = (List)this.dataColumnTypes.stream().map(type -> DeltaLakeTypes.toParquetType(this.typeOperators, type)).collect(ImmutableList.toImmutableList());
            int[] identityMapping = new int[this.dataColumnTypes.size()];
            for (int i = 0; i < identityMapping.length; ++i) {
                identityMapping[i] = i;
            }
            ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter(parquetTypes, this.dataColumnNames, false, false);
            return new ParquetFileWriter(this.fileSystem.newOutputFile(path), rollbackAction, parquetTypes, this.dataColumnNames, schemaConverter.getMessageType(), schemaConverter.getPrimitiveTypes(), parquetWriterOptions, identityMapping, compressionCodec, this.trinoVersion, false, Optional.empty(), Optional.empty());
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_WRITE, "Error creating Parquet file", (Throwable)e);
        }
    }

    private Page getDataPage(Page page) {
        Block[] blocks = new Block[this.dataColumnInputIndex.length];
        for (int i = 0; i < this.dataColumnInputIndex.length; ++i) {
            int dataColumn = this.dataColumnInputIndex[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }

    private static Page extractColumns(Page page, int[] columns) {
        Block[] blocks = new Block[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dataColumn = columns[i];
            blocks[i] = page.getBlock(dataColumn);
        }
        return new Page(page.getPositionCount(), blocks);
    }
}

