/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeSplit.class);
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final Optional<Long> fileRowCount;
    private final long fileModifiedTime;
    private final List<HostAddress> addresses;
    private final SplitWeight splitWeight;
    private final TupleDomain<DeltaLakeColumnHandle> statisticsPredicate;
    private final Map<String, Optional<String>> partitionKeys;

    @JsonCreator
    public DeltaLakeSplit(@JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="rowCount") Optional<Long> fileRowCount, @JsonProperty(value="fileModifiedTime") long fileModifiedTime, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="splitWeight") SplitWeight splitWeight, @JsonProperty(value="statisticsPredicate") TupleDomain<DeltaLakeColumnHandle> statisticsPredicate, @JsonProperty(value="partitionKeys") Map<String, Optional<String>> partitionKeys) {
        this.path = Objects.requireNonNull(path, "path is null");
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.fileRowCount = Objects.requireNonNull(fileRowCount, "rowCount is null");
        this.fileModifiedTime = fileModifiedTime;
        this.addresses = ImmutableList.copyOf((Collection)Objects.requireNonNull(addresses, "addresses is null"));
        this.splitWeight = Objects.requireNonNull(splitWeight, "splitWeight is null");
        this.statisticsPredicate = Objects.requireNonNull(statisticsPredicate, "statisticsPredicate is null");
        this.partitionKeys = Objects.requireNonNull(partitionKeys, "partitionKeys is null");
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public SplitWeight getSplitWeight() {
        return this.splitWeight;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public Optional<Long> getFileRowCount() {
        return this.fileRowCount;
    }

    @JsonProperty
    public long getFileModifiedTime() {
        return this.fileModifiedTime;
    }

    @JsonProperty
    public TupleDomain<DeltaLakeColumnHandle> getStatisticsPredicate() {
        return this.statisticsPredicate;
    }

    @JsonProperty
    public Map<String, Optional<String>> getPartitionKeys() {
        return this.partitionKeys;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.sizeOf(this.fileRowCount, value -> SizeOf.LONG_INSTANCE_SIZE) + SizeOf.estimatedSizeOf(this.addresses, HostAddress::getRetainedSizeInBytes) + this.splitWeight.getRetainedSizeInBytes() + this.statisticsPredicate.getRetainedSizeInBytes(DeltaLakeColumnHandle::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf(this.partitionKeys, SizeOf::estimatedSizeOf, value -> SizeOf.sizeOf((Optional)value, SizeOf::estimatedSizeOf));
    }

    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"start", (Object)this.start).put((Object)"length", (Object)this.length).buildOrThrow();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).add("start", this.start).add("length", this.length).add("fileSize", this.fileSize).add("rowCount", this.fileRowCount).add("addresses", this.addresses).add("statisticsPredicate", this.statisticsPredicate).add("partitionKeys", this.partitionKeys).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeSplit that = (DeltaLakeSplit)o;
        return this.start == that.start && this.length == that.length && this.fileSize == that.fileSize && this.path.equals(that.path) && this.fileRowCount.equals(that.fileRowCount) && this.addresses.equals(that.addresses) && Objects.equals(this.statisticsPredicate, that.statisticsPredicate) && Objects.equals(this.partitionKeys, that.partitionKeys);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.start, this.length, this.fileSize, this.fileRowCount, this.addresses, this.statisticsPredicate, this.partitionKeys);
    }
}

