/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeSplitSource;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;

public class DeltaLakeSplitManager
implements ConnectorSplitManager {
    private final TypeManager typeManager;
    private final BiFunction<ConnectorSession, HiveTransactionHandle, DeltaLakeMetastore> metastoreProvider;
    private final ExecutorService executor;
    private final int maxInitialSplits;
    private final int maxSplitsPerSecond;
    private final int maxOutstandingSplits;
    private final double minimumAssignedSplitWeight;

    @Inject
    public DeltaLakeSplitManager(TypeManager typeManager, BiFunction<ConnectorSession, HiveTransactionHandle, DeltaLakeMetastore> metastoreProvider, ExecutorService executor, DeltaLakeConfig config) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metastoreProvider = Objects.requireNonNull(metastoreProvider, "metastoreProvider is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.maxInitialSplits = config.getMaxInitialSplits();
        this.maxSplitsPerSecond = config.getMaxSplitsPerSecond();
        this.maxOutstandingSplits = config.getMaxOutstandingSplits();
        this.minimumAssignedSplitWeight = config.getMinimumAssignedSplitWeight();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)handle;
        if (deltaLakeTableHandle.getEnforcedPartitionConstraint().isNone() || deltaLakeTableHandle.getNonPartitionConstraint().isNone()) {
            if (deltaLakeTableHandle.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return FixedSplitSource.emptySplitSource();
        }
        DeltaLakeSplitSource splitSource = new DeltaLakeSplitSource(deltaLakeTableHandle.getSchemaTableName(), this.getSplits(transaction, deltaLakeTableHandle, session, deltaLakeTableHandle.getMaxScannedFileSize(), dynamicFilter.getColumnsCovered(), constraint), this.executor, this.maxSplitsPerSecond, this.maxOutstandingSplits, dynamicFilter, DeltaLakeSessionProperties.getDynamicFilteringWaitTimeout(session), deltaLakeTableHandle.isRecordScannedFiles());
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, DeltaLakeSplitManager.class.getClassLoader());
    }

    private Stream<DeltaLakeSplit> getSplits(ConnectorTransactionHandle transaction, DeltaLakeTableHandle tableHandle, ConnectorSession session, Optional<DataSize> maxScannedFileSize, Set<ColumnHandle> columnsCoveredByDynamicFilter, Constraint constraint) {
        DeltaLakeMetastore metastore = this.getMetastore(session, transaction);
        String tableLocation = metastore.getTableLocation(tableHandle.getSchemaTableName());
        List<AddFileEntry> validDataFiles = metastore.getValidDataFiles(tableHandle.getSchemaTableName(), session);
        TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint = tableHandle.getEnforcedPartitionConstraint();
        TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint = tableHandle.getNonPartitionConstraint();
        Domain pathDomain = DeltaLakeSplitManager.getPathDomain(nonPartitionConstraint);
        boolean splittable = tableHandle.getWriteType().isEmpty() && DeltaLakeSplitManager.mayAnyDataColumnProjected(tableHandle);
        AtomicInteger remainingInitialSplits = new AtomicInteger(this.maxInitialSplits);
        Optional filesModifiedAfter = tableHandle.getAnalyzeHandle().flatMap(AnalyzeHandle::getFilesModifiedAfter);
        Optional<Long> maxScannedFileSizeInBytes = maxScannedFileSize.map(DataSize::toBytes);
        Set predicatedColumnNames = (Set)Stream.concat(((Map)nonPartitionConstraint.getDomains().orElseThrow()).keySet().stream(), columnsCoveredByDynamicFilter.stream().map(DeltaLakeColumnHandle.class::cast)).map(column -> column.getName().toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        List<DeltaLakeColumnMetadata> schema = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), this.typeManager);
        List predicatedColumns = (List)schema.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        return validDataFiles.stream().flatMap(addAction -> {
            if (tableHandle.getAnalyzeHandle().isPresent() && !tableHandle.getAnalyzeHandle().get().isInitialAnalyze() && !addAction.isDataChange()) {
                return Stream.empty();
            }
            String splitPath = DeltaLakeSplitManager.buildSplitPath(tableLocation, addAction);
            if (!DeltaLakeSplitManager.pathMatchesPredicate(pathDomain, splitPath)) {
                return Stream.empty();
            }
            if (filesModifiedAfter.isPresent() && addAction.getModificationTime() <= ((Instant)filesModifiedAfter.get()).toEpochMilli()) {
                return Stream.empty();
            }
            if (maxScannedFileSizeInBytes.isPresent() && addAction.getSize() > (Long)maxScannedFileSizeInBytes.get()) {
                return Stream.empty();
            }
            Map enforcedDomains = (Map)enforcedPartitionConstraint.getDomains().orElseThrow();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), enforcedDomains)) {
                return Stream.empty();
            }
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addAction, predicatedColumns, tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
            if (!nonPartitionConstraint.overlaps(statisticsPredicate)) {
                return Stream.empty();
            }
            if (constraint.predicate().isPresent()) {
                Map<String, Optional<String>> partitionValues = addAction.getCanonicalPartitionValues();
                Map deserializedValues = (Map)((Set)constraint.getPredicateColumns().orElseThrow()).stream().map(DeltaLakeColumnHandle.class::cast).filter(column -> partitionValues.containsKey(column.getName())).collect(ImmutableMap.toImmutableMap(Function.identity(), column -> new NullableValue(column.getType(), TransactionLogParser.deserializePartitionValue(column, (Optional)partitionValues.get(column.getName())))));
                if (!((Predicate)constraint.predicate().get()).test(deserializedValues)) {
                    return Stream.empty();
                }
            }
            return this.splitsForFile(session, (AddFileEntry)addAction, splitPath, addAction.getCanonicalPartitionValues(), statisticsPredicate, splittable, remainingInitialSplits).stream();
        });
    }

    private static boolean mayAnyDataColumnProjected(DeltaLakeTableHandle tableHandle) {
        if (tableHandle.getProjectedColumns().isEmpty()) {
            return true;
        }
        return tableHandle.getProjectedColumns().get().stream().map(columnHandle -> ((DeltaLakeColumnHandle)columnHandle).getColumnType()).anyMatch(DeltaLakeColumnType.REGULAR::equals);
    }

    public static boolean partitionMatchesPredicate(Map<String, Optional<String>> partitionKeys, Map<DeltaLakeColumnHandle, Domain> domains) {
        for (Map.Entry<DeltaLakeColumnHandle, Domain> enforcedDomainsEntry : domains.entrySet()) {
            DeltaLakeColumnHandle partitionColumn = enforcedDomainsEntry.getKey();
            Domain partitionDomain = enforcedDomainsEntry.getValue();
            if (partitionDomain.includesNullableValue(TransactionLogParser.deserializePartitionValue(partitionColumn, partitionKeys.get(partitionColumn.getPhysicalName())))) continue;
            return false;
        }
        return true;
    }

    private static Domain getPathDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> Optional.ofNullable((Domain)domains.get(DeltaLakeColumnHandle.pathColumnHandle()))).orElseGet(() -> Domain.all((Type)DeltaLakeColumnHandle.pathColumnHandle().getType()));
    }

    private static boolean pathMatchesPredicate(Domain pathDomain, String path) {
        return pathDomain.includesNullableValue((Object)Slices.utf8Slice((String)path));
    }

    private List<DeltaLakeSplit> splitsForFile(ConnectorSession session, AddFileEntry addFileEntry, String splitPath, Map<String, Optional<String>> partitionKeys, TupleDomain<DeltaLakeColumnHandle> statisticsPredicate, boolean splittable, AtomicInteger remainingInitialSplits) {
        long splitSize;
        long fileSize = addFileEntry.getSize();
        if (!splittable) {
            return ImmutableList.of((Object)new DeltaLakeSplit(splitPath, 0L, fileSize, fileSize, addFileEntry.getStats().flatMap(DeltaLakeFileStatistics::getNumRecords), addFileEntry.getModificationTime(), (List<HostAddress>)ImmutableList.of(), SplitWeight.standard(), statisticsPredicate, partitionKeys));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        for (long currentOffset = 0L; currentOffset < fileSize; currentOffset += splitSize) {
            long maxSplitSize = remainingInitialSplits.get() > 0 && remainingInitialSplits.getAndDecrement() > 0 ? DeltaLakeSessionProperties.getMaxInitialSplitSize(session).toBytes() : DeltaLakeSessionProperties.getMaxSplitSize(session).toBytes();
            splitSize = Math.min(maxSplitSize, fileSize - currentOffset);
            splits.add((Object)new DeltaLakeSplit(splitPath, currentOffset, splitSize, fileSize, Optional.empty(), addFileEntry.getModificationTime(), (List<HostAddress>)ImmutableList.of(), SplitWeight.fromProportion((double)Math.min(Math.max((double)splitSize / (double)maxSplitSize, this.minimumAssignedSplitWeight), 1.0)), statisticsPredicate, partitionKeys));
        }
        return splits.build();
    }

    private static String buildSplitPath(String tableLocation, AddFileEntry addAction) {
        URI uri = URI.create(addAction.getPath());
        String path = uri.getPath();
        if (tableLocation.startsWith("abfs://") || tableLocation.startsWith("abfss://")) {
            path = URLDecoder.decode(path.replace("+", "%2B"), StandardCharsets.UTF_8);
        }
        if (tableLocation.endsWith("/")) {
            return tableLocation + path;
        }
        return tableLocation + "/" + path;
    }

    private DeltaLakeMetastore getMetastore(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metastoreProvider.apply(session, (HiveTransactionHandle)transactionHandle);
    }
}

