/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.deltalake.metastore.HiveMetastoreBackedDeltaLakeMetastore;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreFactory;
import io.trino.plugin.hive.metastore.Table;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Provider;

public class FlushMetadataCacheProcedure
implements Provider<Procedure> {
    private static final String PROCEDURE_NAME = "flush_metadata_cache";
    private static final String PARAM_SCHEMA_NAME = "SCHEMA_NAME";
    private static final String PARAM_TABLE_NAME = "TABLE_NAME";
    private static final MethodHandle FLUSH_METADATA_CACHE;
    private final HiveMetastoreFactory metastoreFactory;
    private final Optional<CachingHiveMetastore> cachingHiveMetastore;
    private final TransactionLogAccess transactionLogAccess;
    private final CachingExtendedStatisticsAccess extendedStatisticsAccess;

    @Inject
    public FlushMetadataCacheProcedure(HiveMetastoreFactory metastoreFactory, Optional<CachingHiveMetastore> cachingHiveMetastore, TransactionLogAccess transactionLogAccess, CachingExtendedStatisticsAccess extendedStatisticsAccess) {
        this.metastoreFactory = Objects.requireNonNull(metastoreFactory, "metastoreFactory is null");
        this.cachingHiveMetastore = Objects.requireNonNull(cachingHiveMetastore, "cachingHiveMetastore is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.extendedStatisticsAccess = Objects.requireNonNull(extendedStatisticsAccess, "extendedStatisticsAccess is null");
    }

    public Procedure get() {
        return new Procedure("system", PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(PARAM_SCHEMA_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_TABLE_NAME, (Type)VarcharType.VARCHAR, false, null)), FLUSH_METADATA_CACHE.bindTo(this), true);
    }

    public void flushMetadataCache(ConnectorSession session, String schemaName, String tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doFlushMetadataCache(session, Optional.ofNullable(schemaName), Optional.ofNullable(tableName));
        }
    }

    private void doFlushMetadataCache(ConnectorSession session, Optional<String> schemaName, Optional<String> tableName) {
        if (schemaName.isEmpty() && tableName.isEmpty()) {
            this.cachingHiveMetastore.ifPresent(CachingHiveMetastore::flushCache);
            this.transactionLogAccess.flushCache();
            this.extendedStatisticsAccess.invalidateCache();
        } else if (schemaName.isPresent() && tableName.isPresent()) {
            HiveMetastore metastore = this.metastoreFactory.createMetastore(Optional.of(session.getIdentity()));
            Table table = (Table)metastore.getTable(schemaName.get(), tableName.get()).orElseThrow(() -> new TableNotFoundException(new SchemaTableName((String)schemaName.get(), (String)tableName.get())));
            HiveMetastoreBackedDeltaLakeMetastore.verifyDeltaLakeTable(table);
            this.cachingHiveMetastore.ifPresent(caching -> caching.invalidateTable(table.getDatabaseName(), table.getTableName()));
            String tableLocation = HiveMetastoreBackedDeltaLakeMetastore.getTableLocation(table);
            this.transactionLogAccess.invalidateCaches(tableLocation);
            this.extendedStatisticsAccess.invalidateCache(tableLocation);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Illegal parameter set passed");
        }
    }

    static {
        try {
            FLUSH_METADATA_CACHE = MethodHandles.lookup().unreflect(FlushMetadataCacheProcedure.class.getMethod("flushMetadataCache", ConnectorSession.class, String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

