/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.trino.collect.cache.CacheUtils;
import io.trino.collect.cache.EvictableCacheBuilder;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Qualifier;

public class CachingExtendedStatisticsAccess
implements ExtendedStatisticsAccess {
    private static final Duration CACHE_EXPIRATION = Duration.of(1L, ChronoUnit.HOURS);
    private static final long CACHE_MAX_SIZE = 1000L;
    private final ExtendedStatisticsAccess delegate;
    private final Cache<String, Optional<ExtendedStatistics>> cache = EvictableCacheBuilder.newBuilder().expireAfterWrite(CACHE_EXPIRATION).maximumSize(1000L).build();

    @Inject
    public CachingExtendedStatisticsAccess(@ForCachingExtendedStatisticsAccess ExtendedStatisticsAccess delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, String tableLocation) {
        try {
            return (Optional)CacheUtils.uncheckedCacheGet(this.cache, (Object)tableLocation, () -> this.delegate.readExtendedStatistics(session, tableLocation));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error reading statistics from cache", e.getCause());
        }
    }

    @Override
    public void updateExtendedStatistics(ConnectorSession session, String tableLocation, ExtendedStatistics statistics) {
        this.delegate.updateExtendedStatistics(session, tableLocation, statistics);
        this.cache.invalidate((Object)tableLocation);
    }

    @Override
    public void deleteExtendedStatistics(ConnectorSession session, String tableLocation) {
        this.delegate.deleteExtendedStatistics(session, tableLocation);
        this.cache.invalidate((Object)tableLocation);
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public void invalidateCache(String tableLocation) {
        this.cache.invalidate((Object)tableLocation);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @Qualifier
    public static @interface ForCachingExtendedStatisticsAccess {
    }
}

