/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Throwables;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.slice.Slices;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;

public class DeltaLakePageSource
implements ConnectorPageSource {
    private static final JsonCodec<List<String>> PARTITIONS_CODEC = new JsonCodecFactory().listJsonCodec(String.class);
    private final Block[] prefilledBlocks;
    private final int[] delegateIndexes;
    private final int rowIdIndex;
    private final Block pathBlock;
    private final Block partitionsBlock;
    private final ConnectorPageSource delegate;

    public DeltaLakePageSource(List<DeltaLakeColumnHandle> columns, Set<String> missingColumnNames, Map<String, Optional<String>> partitionKeys, Optional<List<String>> partitionValues, ConnectorPageSource delegate, String path, long fileSize, long fileModifiedTime) {
        int size = columns.size();
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.prefilledBlocks = new Block[size];
        this.delegateIndexes = new int[size];
        int outputIndex = 0;
        int delegateIndex = 0;
        int rowIdIndex = -1;
        Block pathBlock = null;
        Block partitionsBlock = null;
        for (DeltaLakeColumnHandle column : columns) {
            if (partitionKeys.containsKey(column.getPhysicalName())) {
                Type type = column.getType();
                Object prefilledValue = TransactionLogParser.deserializePartitionValue(column, partitionKeys.get(column.getPhysicalName()));
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)type, (Object)prefilledValue);
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$path")) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)DeltaLakeColumnHandle.PATH_TYPE, (Object)Slices.utf8Slice((String)path));
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$file_size")) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)DeltaLakeColumnHandle.FILE_SIZE_TYPE, (Object)fileSize);
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$file_modified_time")) {
                long packedTimestamp = DateTimeEncoding.packDateTimeWithZone((long)fileModifiedTime, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)DeltaLakeColumnHandle.FILE_MODIFIED_TIME_TYPE, (Object)packedTimestamp);
                this.delegateIndexes[outputIndex] = -1;
            } else if (column.getName().equals("$row_id")) {
                rowIdIndex = outputIndex;
                pathBlock = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)path));
                partitionsBlock = Utils.nativeValueToBlock((Type)VarcharType.VARCHAR, (Object)Slices.wrappedBuffer((byte[])PARTITIONS_CODEC.toJsonBytes(partitionValues.orElseThrow(() -> new IllegalStateException("partitionValues not provided")))));
                this.delegateIndexes[outputIndex] = delegateIndex++;
            } else if (missingColumnNames.contains(column.getName())) {
                this.prefilledBlocks[outputIndex] = Utils.nativeValueToBlock((Type)column.getType(), null);
                this.delegateIndexes[outputIndex] = -1;
            } else {
                this.delegateIndexes[outputIndex] = delegateIndex++;
            }
            ++outputIndex;
        }
        this.rowIdIndex = rowIdIndex;
        this.pathBlock = pathBlock;
        this.partitionsBlock = partitionsBlock;
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public OptionalLong getCompletedPositions() {
        return this.delegate.getCompletedPositions();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public Page getNextPage() {
        try {
            Page dataPage = this.delegate.getNextPage();
            if (dataPage == null) {
                return null;
            }
            int batchSize = dataPage.getPositionCount();
            Block[] blocks = new Block[this.prefilledBlocks.length];
            for (int i = 0; i < this.prefilledBlocks.length; ++i) {
                blocks[i] = this.prefilledBlocks[i] != null ? RunLengthEncodedBlock.create((Block)this.prefilledBlocks[i], (int)batchSize) : (i == this.rowIdIndex ? this.createRowIdBlock(dataPage.getBlock(this.delegateIndexes[i])) : dataPage.getBlock(this.delegateIndexes[i]));
            }
            return new Page(batchSize, blocks);
        }
        catch (RuntimeException e) {
            this.closeWithSuppression(e);
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, (Throwable)e);
        }
    }

    private Block createRowIdBlock(Block rowIndexBlock) {
        int positions = rowIndexBlock.getPositionCount();
        Block[] fields = new Block[]{RunLengthEncodedBlock.create((Block)this.pathBlock, (int)positions), rowIndexBlock, RunLengthEncodedBlock.create((Block)this.partitionsBlock, (int)positions)};
        return RowBlock.fromFieldBlocks((int)positions, Optional.empty(), (Block[])fields);
    }

    public void close() {
        try {
            this.delegate.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.delegate.toString();
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    protected void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (RuntimeException e) {
                if (throwable == e) break block2;
                throwable.addSuppressed(e);
            }
        }
    }
}

