/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import com.google.common.base.MoreObjects;
import io.trino.plugin.deltalake.expression.Literal;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import java.util.Objects;

public class LongLiteral
extends Literal {
    private final long value;

    public LongLiteral(String value) {
        Objects.requireNonNull(value, "value is null");
        this.value = Long.parseLong(value);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(SparkExpressionTreeVisitor<R, C> visitor, C context) {
        return visitor.visitLongLiteral(this, context);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongLiteral that = (LongLiteral)o;
        return this.value == that.value;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue(this.value).toString();
    }
}

