/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.metastore;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplitManager;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.metastore.DeltaLakeMetastore;
import io.trino.plugin.deltalake.metastore.NotADeltaLakeTableException;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.statistics.DeltaLakeColumnStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.Database;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.PrincipalPrivileges;
import io.trino.plugin.hive.metastore.Table;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.DoubleRange;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.StatsUtil;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;

public class HiveMetastoreBackedDeltaLakeMetastore
implements DeltaLakeMetastore {
    public static final String TABLE_PROVIDER_PROPERTY = "spark.sql.sources.provider";
    public static final String TABLE_PROVIDER_VALUE = "DELTA";
    private final HiveMetastore delegate;
    private final TransactionLogAccess transactionLogAccess;
    private final TypeManager typeManager;
    private final CachingExtendedStatisticsAccess statisticsAccess;
    private final TrinoFileSystemFactory fileSystemFactory;

    public HiveMetastoreBackedDeltaLakeMetastore(HiveMetastore delegate, TransactionLogAccess transactionLogAccess, TypeManager typeManager, CachingExtendedStatisticsAccess statisticsAccess, TrinoFileSystemFactory fileSystemFactory) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogSupport is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.statisticsAccess = Objects.requireNonNull(statisticsAccess, "statisticsAccess is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    @Override
    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    @Override
    public Optional<Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName);
    }

    @Override
    public List<String> getAllTables(String databaseName) {
        return this.delegate.getAllTables(databaseName);
    }

    @Override
    public Optional<Table> getTable(String databaseName, String tableName) {
        Optional candidate = this.delegate.getTable(databaseName, tableName);
        candidate.ifPresent(HiveMetastoreBackedDeltaLakeMetastore::verifyDeltaLakeTable);
        return candidate;
    }

    public static void verifyDeltaLakeTable(Table table) {
        if (ViewReaderUtil.isHiveOrPrestoView((Table)table)) {
            throw new NotADeltaLakeTableException(table.getDatabaseName(), table.getTableName());
        }
        if (!TABLE_PROVIDER_VALUE.equalsIgnoreCase((String)table.getParameters().get(TABLE_PROVIDER_PROPERTY))) {
            throw new NotADeltaLakeTableException(table.getDatabaseName(), table.getTableName());
        }
    }

    @Override
    public void createDatabase(Database database) {
        this.delegate.createDatabase(database);
    }

    @Override
    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    @Override
    public void createTable(ConnectorSession session, Table table, PrincipalPrivileges principalPrivileges) {
        String tableLocation = table.getStorage().getLocation();
        this.statisticsAccess.invalidateCache(tableLocation);
        this.transactionLogAccess.invalidateCaches(tableLocation);
        try {
            TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(table.getSchemaTableName(), tableLocation, session);
            this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_TABLE, "Failed to access table location: " + tableLocation, (Throwable)e);
        }
        this.delegate.createTable(table, principalPrivileges);
    }

    @Override
    public void dropTable(ConnectorSession session, String databaseName, String tableName, boolean deleteData) {
        String tableLocation = this.getTableLocation(new SchemaTableName(databaseName, tableName));
        this.delegate.dropTable(databaseName, tableName, deleteData);
        this.statisticsAccess.invalidateCache(tableLocation);
        this.transactionLogAccess.invalidateCaches(tableLocation);
        if (deleteData) {
            try {
                this.fileSystemFactory.create(session).deleteDirectory(tableLocation);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, String.format("Failed to delete directory %s of the table %s", tableLocation, tableName), (Throwable)e);
            }
        }
    }

    @Override
    public void renameTable(ConnectorSession session, SchemaTableName from, SchemaTableName to) {
        this.delegate.renameTable(from.getSchemaName(), from.getTableName(), to.getSchemaName(), to.getTableName());
    }

    @Override
    public MetadataEntry getMetadata(TableSnapshot tableSnapshot, ConnectorSession session) {
        return this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
    }

    @Override
    public ProtocolEntry getProtocol(ConnectorSession session, TableSnapshot tableSnapshot) {
        return this.transactionLogAccess.getProtocolEntries(tableSnapshot, session).reduce((first, second) -> second).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Protocol entry not found in transaction log for table " + tableSnapshot.getTable()));
    }

    @Override
    public String getTableLocation(SchemaTableName tableName) {
        Table table = this.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        return HiveMetastoreBackedDeltaLakeMetastore.getTableLocation(table);
    }

    public static String getTableLocation(Table table) {
        Map serdeParameters = table.getStorage().getSerdeParameters();
        String location = (String)serdeParameters.get("path");
        if (location == null) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, String.format("No %s property defined for table: %s", "path", table));
        }
        return location;
    }

    @Override
    public TableSnapshot getSnapshot(SchemaTableName table, ConnectorSession session) {
        try {
            return this.transactionLogAccess.loadSnapshot(table, this.getTableLocation(table), session);
        }
        catch (NotADeltaLakeTableException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting snapshot for " + table, (Throwable)e);
        }
    }

    @Override
    public List<AddFileEntry> getValidDataFiles(SchemaTableName table, ConnectorSession session) {
        return this.transactionLogAccess.getActiveFiles(this.getSnapshot(table, session), session);
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, DeltaLakeTableHandle tableHandle) {
        TableSnapshot tableSnapshot = this.getSnapshot(tableHandle.getSchemaTableName(), session);
        double numRecords = 0.0;
        MetadataEntry metadata = this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
        List<DeltaLakeColumnMetadata> columnMetadata = DeltaLakeSchemaSupport.extractSchema(metadata, this.typeManager);
        List columns = (List)columnMetadata.stream().map(columnMeta -> new DeltaLakeColumnHandle(columnMeta.getName(), columnMeta.getType(), columnMeta.getFieldId(), columnMeta.getPhysicalName(), columnMeta.getPhysicalColumnType(), metadata.getCanonicalPartitionColumns().contains(columnMeta.getName()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR)).collect(ImmutableList.toImmutableList());
        HashMap<DeltaLakeColumnHandle, Double> nullCounts = new HashMap<DeltaLakeColumnHandle, Double>();
        columns.forEach(column -> nullCounts.put((DeltaLakeColumnHandle)column, 0.0));
        HashMap minValues = new HashMap();
        HashMap maxValues = new HashMap();
        HashMap partitioningColumnsDistinctValues = new HashMap();
        columns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.PARTITION_KEY).forEach(column -> partitioningColumnsDistinctValues.put(column, new HashSet()));
        if (tableHandle.getEnforcedPartitionConstraint().isNone() || tableHandle.getNonPartitionConstraint().isNone()) {
            return this.createZeroStatistics(columns);
        }
        Set predicatedColumnNames = (Set)((Map)tableHandle.getNonPartitionConstraint().getDomains().orElseThrow()).keySet().stream().map(DeltaLakeColumnHandle::getName).collect(ImmutableSet.toImmutableSet());
        List predicatedColumns = (List)columnMetadata.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        for (AddFileEntry addEntry : this.transactionLogAccess.getActiveFiles(tableSnapshot, session)) {
            Optional<? extends DeltaLakeFileStatistics> fileStatistics = addEntry.getStats();
            if (fileStatistics.isEmpty()) {
                return TableStatistics.empty();
            }
            DeltaLakeFileStatistics stats = fileStatistics.get();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addEntry.getCanonicalPartitionValues(), (Map)tableHandle.getEnforcedPartitionConstraint().getDomains().orElseThrow())) continue;
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addEntry, predicatedColumns, tableHandle.getMetadataEntry().getCanonicalPartitionColumns());
            if (!tableHandle.getNonPartitionConstraint().overlaps(statisticsPredicate)) continue;
            if (stats.getNumRecords().isEmpty()) {
                return TableStatistics.empty();
            }
            numRecords += (double)stats.getNumRecords().get().longValue();
            for (DeltaLakeColumnHandle column2 : columns) {
                if (column2.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                    Optional<String> partitionValue = addEntry.getCanonicalPartitionValues().get(column2.getPhysicalName());
                    if (partitionValue.isEmpty()) {
                        nullCounts.merge(column2, Double.valueOf(stats.getNumRecords().get().longValue()), Double::sum);
                    } else {
                        ((Set)partitioningColumnsDistinctValues.get(column2)).add(partitionValue.get());
                    }
                } else {
                    Optional<Long> maybeNullCount = stats.getNullCount(column2.getPhysicalName());
                    if (maybeNullCount.isPresent()) {
                        nullCounts.put(column2, (Double)nullCounts.get(column2) + (double)maybeNullCount.get().longValue());
                    } else {
                        nullCounts.put(column2, Double.NaN);
                    }
                }
                stats.getMinColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> minValues.merge(column2, parsedValueAsDouble, Math::min));
                stats.getMaxColumnValue(column2).map(parsedValue -> StatsUtil.toStatsRepresentation((Type)column2.getType(), (Object)parsedValue)).filter(OptionalDouble::isPresent).map(OptionalDouble::getAsDouble).ifPresent(parsedValueAsDouble -> maxValues.merge(column2, parsedValueAsDouble, Math::max));
            }
        }
        if (numRecords == 0.0) {
            return this.createZeroStatistics(columns);
        }
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)numRecords));
        Optional<Object> statistics = Optional.empty();
        if (DeltaLakeSessionProperties.isExtendedStatisticsEnabled(session)) {
            statistics = this.statisticsAccess.readExtendedStatistics(session, tableHandle.getLocation());
        }
        for (DeltaLakeColumnHandle column3 : columns) {
            DeltaLakeColumnStatistics deltaLakeColumnStatistics;
            ColumnStatistics.Builder columnStatsBuilder = new ColumnStatistics.Builder();
            Double nullCount = (Double)nullCounts.get(column3);
            columnStatsBuilder.setNullsFraction(nullCount.isNaN() ? Estimate.unknown() : Estimate.of((double)(nullCount / numRecords)));
            Double maxValue = (Double)maxValues.get(column3);
            Double minValue = (Double)minValues.get(column3);
            if (this.isValidInRange(maxValue) && this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), maxValue.doubleValue()));
            } else if (this.isValidInRange(maxValue)) {
                columnStatsBuilder.setRange(new DoubleRange(Double.NEGATIVE_INFINITY, maxValue.doubleValue()));
            } else if (this.isValidInRange(minValue)) {
                columnStatsBuilder.setRange(new DoubleRange(minValue.doubleValue(), Double.POSITIVE_INFINITY));
            }
            if (column3.getColumnType() == DeltaLakeColumnType.PARTITION_KEY) {
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)((Set)partitioningColumnsDistinctValues.get(column3)).size()));
            }
            if (statistics.isPresent() && (deltaLakeColumnStatistics = ((ExtendedStatistics)statistics.get()).getColumnStatistics().get(column3.getPhysicalName())) != null && column3.getColumnType() != DeltaLakeColumnType.PARTITION_KEY) {
                deltaLakeColumnStatistics.getTotalSizeInBytes().ifPresent(size -> columnStatsBuilder.setDataSize(Estimate.of((double)size)));
                columnStatsBuilder.setDistinctValuesCount(Estimate.of((double)deltaLakeColumnStatistics.getNdvSummary().cardinality()));
            }
            statsBuilder.setColumnStatistics((ColumnHandle)column3, columnStatsBuilder.build());
        }
        return statsBuilder.build();
    }

    private TableStatistics createZeroStatistics(List<DeltaLakeColumnHandle> columns) {
        TableStatistics.Builder statsBuilder = new TableStatistics.Builder().setRowCount(Estimate.of((double)0.0));
        for (DeltaLakeColumnHandle column : columns) {
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(Estimate.of((double)0.0));
            columnStatistics.setDistinctValuesCount(Estimate.of((double)0.0));
            statsBuilder.setColumnStatistics((ColumnHandle)column, columnStatistics.build());
        }
        return statsBuilder.build();
    }

    private boolean isValidInRange(Double d) {
        return d != null && !d.isNaN();
    }

    @Override
    public HiveMetastore getHiveMetastore() {
        return this.delegate;
    }
}

