/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class CdfFileEntry {
    private final String path;
    private final Map<String, String> partitionValues;
    private final long size;
    private final boolean dataChange;

    @JsonCreator
    public CdfFileEntry(@JsonProperty(value="path") String path, @JsonProperty(value="partitionValues") Map<String, String> partitionValues, @JsonProperty(value="size") long size) {
        this.path = path;
        this.partitionValues = partitionValues;
        this.size = size;
        this.dataChange = false;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public Map<String, String> getPartitionValues() {
        return this.partitionValues;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty(value="dataChange")
    public boolean isDataChange() {
        return this.dataChange;
    }

    public String toString() {
        return String.format("CdfFileEntry{path=%s, partitionValues=%s, size=%d, dataChange=%b}", this.path, this.partitionValues, this.size, this.dataChange);
    }
}

