/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.spi.type.VarcharType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;

public class DeltaLakeParquetStatisticsUtils {
    private static final Logger LOG = Logger.get(DeltaLakeParquetStatisticsUtils.class);

    private DeltaLakeParquetStatisticsUtils() {
    }

    public static boolean hasInvalidStatistics(Collection<ColumnChunkMetaData> metadataList) {
        return metadataList.stream().anyMatch(metadata -> !metadata.getStatistics().isNumNullsSet() || metadata.getStatistics().isEmpty() || !metadata.getStatistics().hasNonNullValue() && metadata.getStatistics().getNumNulls() != metadata.getValueCount());
    }

    @Nullable
    public static Object jsonValueToTrinoValue(Type type, @Nullable Object jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (type == SmallintType.SMALLINT || type == TinyintType.TINYINT || type == IntegerType.INTEGER) {
            return (long)((Integer)jsonValue).intValue();
        }
        if (type == BigintType.BIGINT) {
            if (jsonValue instanceof Long) {
                return (long)((Long)jsonValue);
            }
            if (jsonValue instanceof Integer) {
                return (long)((Integer)jsonValue).intValue();
            }
            throw new IllegalArgumentException("Unexpected value for bigint type: " + jsonValue);
        }
        if (type == RealType.REAL) {
            return (long)Float.floatToRawIntBits((float)((Double)jsonValue).doubleValue());
        }
        if (type == DoubleType.DOUBLE) {
            return (double)((Double)jsonValue);
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            BigDecimal decimal = new BigDecimal((String)jsonValue);
            if (decimalType.isShort()) {
                return Decimals.encodeShortScaledValue((BigDecimal)decimal, (int)decimalType.getScale());
            }
            return Decimals.encodeScaledValue((BigDecimal)decimal, (int)decimalType.getScale());
        }
        if (type instanceof VarcharType) {
            return Slices.utf8Slice((String)((String)jsonValue));
        }
        if (type == DateType.DATE) {
            return LocalDate.parse((String)jsonValue).toEpochDay();
        }
        if (type == TimestampType.TIMESTAMP_MILLIS) {
            return Instant.parse((String)jsonValue).toEpochMilli() * 1000L;
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            Map values = (Map)jsonValue;
            List fieldTypes = rowType.getTypeParameters();
            RowBlockBuilder blockBuilder = new RowBlockBuilder(fieldTypes, null, 1);
            BlockBuilder singleRowBlockWriter = blockBuilder.beginBlockEntry();
            for (int i = 0; i < values.size(); ++i) {
                Type fieldType = (Type)fieldTypes.get(i);
                String fieldName = (String)((RowType.Field)rowType.getFields().get(i)).getName().orElseThrow(() -> new IllegalArgumentException("Field name must exist"));
                Object fieldValue = DeltaLakeParquetStatisticsUtils.jsonValueToTrinoValue(fieldType, values.remove(fieldName));
                TypeUtils.writeNativeValue((Type)fieldType, (BlockBuilder)singleRowBlockWriter, (Object)fieldValue);
            }
            Preconditions.checkState((boolean)values.isEmpty(), (String)"All fields must be converted into Trino value: %s", (Object)values);
            blockBuilder.closeEntry();
            return blockBuilder.build();
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static Map<String, Object> toJsonValues(Map<String, Type> columnTypeMapping, Map<String, Object> values) {
        HashMap<String, Object> jsonValues = new HashMap<String, Object>();
        for (Map.Entry<String, Object> value : values.entrySet()) {
            Type type = columnTypeMapping.get(value.getKey());
            if (type instanceof ArrayType || type instanceof MapType) continue;
            jsonValues.put(value.getKey(), DeltaLakeParquetStatisticsUtils.toJsonValue(columnTypeMapping.get(value.getKey()), value.getValue()));
        }
        return jsonValues;
    }

    @Nullable
    private static Object toJsonValue(Type type, @Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (type == SmallintType.SMALLINT || type == TinyintType.TINYINT || type == IntegerType.INTEGER || type == BigintType.BIGINT) {
            return value;
        }
        if (type == RealType.REAL) {
            return Float.valueOf(Float.intBitsToFloat(Math.toIntExact((Long)value)));
        }
        if (type == DoubleType.DOUBLE) {
            return value;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                return Decimals.toString((long)((Long)value), (int)decimalType.getScale());
            }
            return Decimals.toString((Int128)((Int128)value), (int)decimalType.getScale());
        }
        if (type instanceof VarcharType) {
            return ((Slice)value).toStringUtf8();
        }
        if (type == DateType.DATE) {
            return LocalDate.ofEpochDay((Long)value).format(DateTimeFormatter.ISO_LOCAL_DATE);
        }
        if (type == TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS) {
            Instant ts = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)((Long)value)));
            return DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.ofInstant(ts, ZoneOffset.UTC));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            Block rowBlock = (Block)value;
            ImmutableMap.Builder fieldValues = ImmutableMap.builder();
            for (int i = 0; i < rowBlock.getPositionCount(); ++i) {
                RowType.Field field = (RowType.Field)rowType.getFields().get(i);
                Object fieldValue = TypeUtils.readNativeValue((Type)field.getType(), (Block)((Block)rowBlock.getChildren().get(i)), (int)i);
                Object jsonValue = DeltaLakeParquetStatisticsUtils.toJsonValue(field.getType(), fieldValue);
                if (jsonValue == null) continue;
                fieldValues.put((Object)((String)field.getName().orElseThrow()), jsonValue);
            }
            return fieldValues.buildOrThrow();
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    public static Map<String, Object> jsonEncodeMin(Map<String, Optional<Statistics<?>>> stats, Map<String, Type> typeForColumn) {
        return DeltaLakeParquetStatisticsUtils.jsonEncode(stats, typeForColumn, DeltaLakeParquetStatisticsUtils::getMin);
    }

    public static Map<String, Object> jsonEncodeMax(Map<String, Optional<Statistics<?>>> stats, Map<String, Type> typeForColumn) {
        return DeltaLakeParquetStatisticsUtils.jsonEncode(stats, typeForColumn, DeltaLakeParquetStatisticsUtils::getMax);
    }

    private static Map<String, Object> jsonEncode(Map<String, Optional<Statistics<?>>> stats, Map<String, Type> typeForColumn, BiFunction<Type, Statistics<?>, Optional<Object>> accessor) {
        Map allStats = (Map)stats.entrySet().stream().filter(entry -> entry.getValue() != null && ((Optional)entry.getValue()).isPresent() && !((Statistics)((Optional)entry.getValue()).get()).isEmpty()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> (Optional)accessor.apply((Type)typeForColumn.get(entry.getKey()), (Statistics)((Optional)entry.getValue()).get())));
        return (Map)allStats.entrySet().stream().filter(entry -> entry.getValue() != null && ((Optional)entry.getValue()).isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((Optional)entry.getValue()).get()));
    }

    public static Map<String, Object> toNullCounts(Map<String, Type> columnTypeMapping, Map<String, Object> values) {
        ImmutableMap.Builder nullCounts = ImmutableMap.builderWithExpectedSize((int)values.size());
        for (Map.Entry<String, Object> value : values.entrySet()) {
            Type type = columnTypeMapping.get(value.getKey());
            Objects.requireNonNull(type, "type is null");
            nullCounts.put((Object)value.getKey(), DeltaLakeParquetStatisticsUtils.toNullCount(type, value.getValue()));
        }
        return nullCounts.buildOrThrow();
    }

    private static Object toNullCount(Type type, Object value) {
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            ColumnarRow row = ColumnarRow.toColumnarRow((Block)((Block)value));
            ImmutableMap.Builder nullCounts = ImmutableMap.builderWithExpectedSize((int)row.getPositionCount());
            for (int i = 0; i < row.getPositionCount(); ++i) {
                RowType.Field field = (RowType.Field)rowType.getFields().get(i);
                if (field.getType() instanceof RowType) {
                    nullCounts.put((Object)((String)field.getName().orElseThrow()), DeltaLakeParquetStatisticsUtils.toNullCount(field.getType(), row.getField(i)));
                    continue;
                }
                nullCounts.put((Object)((String)field.getName().orElseThrow()), (Object)BigintType.BIGINT.getLong(row.getField(i), 0));
            }
            return nullCounts.buildOrThrow();
        }
        return value;
    }

    private static Optional<Object> getMin(Type type, Statistics<?> statistics) {
        if (statistics.genericGetMin() == null || !statistics.hasNonNullValue()) {
            return Optional.empty();
        }
        if (type.equals(DateType.DATE)) {
            Preconditions.checkArgument((boolean)(statistics instanceof IntStatistics), (String)"Column with DATE type contained invalid statistics: %s", statistics);
            IntStatistics intStatistics = (IntStatistics)statistics;
            LocalDate date = LocalDate.ofEpochDay(intStatistics.genericGetMin().intValue());
            return Optional.of(date.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            if (statistics instanceof LongStatistics) {
                Instant ts = Instant.ofEpochMilli(((LongStatistics)statistics).genericGetMin());
                return Optional.of(DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.ofInstant(ts, ZoneOffset.UTC)));
            }
            if (statistics instanceof BinaryStatistics) {
                DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decodeInt96Timestamp((Binary)((BinaryStatistics)statistics).genericGetMin());
                Instant ts = Instant.ofEpochSecond(decodedTimestamp.epochSeconds(), decodedTimestamp.nanosOfSecond());
                return Optional.of(DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.ofInstant(ts, ZoneOffset.UTC).truncatedTo(ChronoUnit.MILLIS)));
            }
        }
        if (type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) {
            Preconditions.checkArgument((statistics instanceof IntStatistics || statistics instanceof LongStatistics ? 1 : 0) != 0, (String)"Column with %s type contained invalid statistics: %s", (Object)type, statistics);
            return Optional.of(statistics.genericGetMin());
        }
        if (type.equals(RealType.REAL)) {
            Preconditions.checkArgument((boolean)(statistics instanceof FloatStatistics), (String)"Column with REAL type contained invalid statistics: %s", statistics);
            Float min = ((FloatStatistics)statistics).genericGetMin();
            return Optional.of(Float.valueOf(min.compareTo(Float.valueOf(-0.0f)) == 0 ? 0.0f : min.floatValue()));
        }
        if (type.equals(DoubleType.DOUBLE)) {
            Preconditions.checkArgument((boolean)(statistics instanceof DoubleStatistics), (String)"Column with DOUBLE type contained invalid statistics: %s", statistics);
            Double min = ((DoubleStatistics)statistics).genericGetMin();
            return Optional.of(min.compareTo(-0.0) == 0 ? 0.0 : min);
        }
        if (type instanceof DecimalType) {
            LogicalTypeAnnotation logicalType = statistics.type().getLogicalTypeAnnotation();
            Preconditions.checkArgument((boolean)(logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation), (String)"DECIMAL column had invalid Parquet Logical Type: %s", (Object)logicalType);
            int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
            if (statistics instanceof IntStatistics) {
                BigDecimal min = BigDecimal.valueOf(((IntStatistics)statistics).getMin()).movePointLeft(scale);
                return Optional.of(min.toPlainString());
            }
            if (statistics instanceof LongStatistics) {
                BigDecimal min = BigDecimal.valueOf(((LongStatistics)statistics).getMin()).movePointLeft(scale);
                return Optional.of(min.toPlainString());
            }
            if (statistics instanceof BinaryStatistics) {
                BigInteger base = new BigInteger(((BinaryStatistics)statistics).genericGetMin().getBytes());
                BigDecimal min = new BigDecimal(base, scale);
                return Optional.of(min.toPlainString());
            }
        }
        if (type instanceof VarcharType) {
            return Optional.of(new String(((BinaryStatistics)statistics).genericGetMin().getBytes(), StandardCharsets.UTF_8));
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return Optional.empty();
        }
        LOG.warn("Accumulating Parquet statistics with Trino type: %s and Parquet statistics of type: %s is not supported", new Object[]{type, statistics});
        return Optional.empty();
    }

    private static Optional<Object> getMax(Type type, Statistics<?> statistics) {
        if (statistics.genericGetMax() == null || !statistics.hasNonNullValue()) {
            return Optional.empty();
        }
        if (type.equals(DateType.DATE)) {
            Preconditions.checkArgument((boolean)(statistics instanceof IntStatistics), (String)"Column with DATE type contained invalid statistics: %s", statistics);
            IntStatistics intStatistics = (IntStatistics)statistics;
            LocalDate date = LocalDate.ofEpochDay(intStatistics.genericGetMax().intValue());
            return Optional.of(date.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (type instanceof TimestampWithTimeZoneType) {
            if (statistics instanceof LongStatistics) {
                Instant ts = Instant.ofEpochMilli(((LongStatistics)statistics).genericGetMax());
                return Optional.of(DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.ofInstant(ts, ZoneOffset.UTC)));
            }
            if (statistics instanceof BinaryStatistics) {
                DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decodeInt96Timestamp((Binary)((BinaryStatistics)statistics).genericGetMax());
                Instant ts = Instant.ofEpochSecond(decodedTimestamp.epochSeconds(), decodedTimestamp.nanosOfSecond());
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(ts, ZoneOffset.UTC);
                ZonedDateTime truncatedToMillis = zonedDateTime.truncatedTo(ChronoUnit.MILLIS);
                if (truncatedToMillis.isBefore(zonedDateTime)) {
                    truncatedToMillis = truncatedToMillis.plus(1L, ChronoUnit.MILLIS);
                }
                return Optional.of(DateTimeFormatter.ISO_INSTANT.format(truncatedToMillis));
            }
        }
        if (type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) {
            Preconditions.checkArgument((statistics instanceof IntStatistics || statistics instanceof LongStatistics ? 1 : 0) != 0, (String)"Column with %s type contained invalid statistics: %s", (Object)type, statistics);
            return Optional.of(statistics.genericGetMax());
        }
        if (type.equals(RealType.REAL)) {
            Preconditions.checkArgument((boolean)(statistics instanceof FloatStatistics), (String)"Column with REAL type contained invalid statistics: %s", statistics);
            return Optional.of(((FloatStatistics)statistics).genericGetMax());
        }
        if (type.equals(DoubleType.DOUBLE)) {
            Preconditions.checkArgument((boolean)(statistics instanceof DoubleStatistics), (String)"Column with DOUBLE type contained invalid statistics: %s", statistics);
            return Optional.of(((DoubleStatistics)statistics).genericGetMax());
        }
        if (type instanceof DecimalType) {
            LogicalTypeAnnotation logicalType = statistics.type().getLogicalTypeAnnotation();
            Preconditions.checkArgument((boolean)(logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation), (String)"DECIMAL column had invalid Parquet Logical Type: %s", (Object)logicalType);
            int scale = ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType).getScale();
            if (statistics instanceof IntStatistics) {
                BigDecimal max = BigDecimal.valueOf(((IntStatistics)statistics).getMax()).movePointLeft(scale);
                return Optional.of(max.toPlainString());
            }
            if (statistics instanceof LongStatistics) {
                BigDecimal max = BigDecimal.valueOf(((LongStatistics)statistics).getMax()).movePointLeft(scale);
                return Optional.of(max.toPlainString());
            }
            if (statistics instanceof BinaryStatistics) {
                BigInteger base = new BigInteger(((BinaryStatistics)statistics).genericGetMax().getBytes());
                BigDecimal max = new BigDecimal(base, scale);
                return Optional.of(max.toPlainString());
            }
        }
        if (type instanceof VarcharType) {
            return Optional.of(new String(((BinaryStatistics)statistics).genericGetMax().getBytes(), StandardCharsets.UTF_8));
        }
        if (type.equals(BooleanType.BOOLEAN)) {
            return Optional.empty();
        }
        LOG.warn("Accumulating Parquet statistics with Trino type: %s and Parquet statistics of type: %s is not supported", new Object[]{type, statistics});
        return Optional.empty();
    }
}

