/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import io.airlift.json.ObjectMapperProvider;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeNotFoundException;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class DeltaLakeSchemaSupport {
    public static final String APPEND_ONLY_CONFIGURATION_KEY = "delta.appendOnly";
    public static final String COLUMN_MAPPING_MODE_CONFIGURATION_KEY = "delta.columnMapping.mode";
    private static final Set<String> SUPPORTED_READER_FEATURES = ImmutableSet.builder().add((Object)"columnMapping").build();
    private static final Map<Type, String> PRIMITIVE_TYPE_MAPPING = ImmutableMap.builder().put((Object)BigintType.BIGINT, (Object)"long").put((Object)IntegerType.INTEGER, (Object)"integer").put((Object)SmallintType.SMALLINT, (Object)"short").put((Object)TinyintType.TINYINT, (Object)"byte").put((Object)RealType.REAL, (Object)"float").put((Object)DoubleType.DOUBLE, (Object)"double").put((Object)BooleanType.BOOLEAN, (Object)"boolean").put((Object)VarbinaryType.VARBINARY, (Object)"binary").put((Object)DateType.DATE, (Object)"date").buildOrThrow();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();

    private DeltaLakeSchemaSupport() {
    }

    public static boolean isAppendOnly(MetadataEntry metadataEntry) {
        return Boolean.parseBoolean(metadataEntry.getConfiguration().getOrDefault(APPEND_ONLY_CONFIGURATION_KEY, "false"));
    }

    public static ColumnMappingMode getColumnMappingMode(MetadataEntry metadata) {
        String columnMappingMode = metadata.getConfiguration().getOrDefault(COLUMN_MAPPING_MODE_CONFIGURATION_KEY, "none");
        return (ColumnMappingMode)((Object)Enums.getIfPresent(ColumnMappingMode.class, (String)columnMappingMode.toUpperCase(Locale.ENGLISH)).or((Object)ColumnMappingMode.UNKNOWN));
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(MetadataEntry metadataEntry, TypeManager typeManager) {
        return DeltaLakeSchemaSupport.extractPartitionColumns(DeltaLakeSchemaSupport.extractSchema(metadataEntry, typeManager), metadataEntry.getCanonicalPartitionColumns());
    }

    public static List<DeltaLakeColumnHandle> extractPartitionColumns(List<DeltaLakeColumnMetadata> schema, List<String> canonicalPartitionColumns) {
        if (canonicalPartitionColumns.isEmpty()) {
            return ImmutableList.of();
        }
        return (List)schema.stream().filter(entry -> canonicalPartitionColumns.contains(entry.getName())).map(entry -> new DeltaLakeColumnHandle(entry.getName(), entry.getType(), OptionalInt.empty(), entry.getPhysicalName(), entry.getPhysicalColumnType(), DeltaLakeColumnType.PARTITION_KEY)).collect(ImmutableList.toImmutableList());
    }

    public static String serializeSchemaAsJson(List<DeltaLakeColumnHandle> columns, Map<String, String> columnComments, Map<String, Boolean> columnNullability, Map<String, Map<String, Object>> columnMetadata) {
        try {
            return OBJECT_MAPPER.writeValueAsString(DeltaLakeSchemaSupport.serializeStructType(columns, columnComments, columnNullability, columnMetadata));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to encode Delta Lake schema", (Throwable)e);
        }
    }

    private static Map<String, Object> serializeStructType(List<DeltaLakeColumnHandle> columns, Map<String, String> columnComments, Map<String, Boolean> columnNullability, Map<String, Map<String, Object>> columnMetadata) {
        ImmutableMap.Builder schema = ImmutableMap.builder();
        schema.put((Object)"fields", columns.stream().map(column -> {
            String columnName = column.getName();
            return DeltaLakeSchemaSupport.serializeStructField(column.getName(), column.getType(), (String)columnComments.get(columnName), (Boolean)columnNullability.get(columnName), (Map)columnMetadata.get(columnName));
        }).collect(ImmutableList.toImmutableList()));
        schema.put((Object)"type", (Object)"struct");
        return schema.buildOrThrow();
    }

    private static Map<String, Object> serializeStructField(String name, Type type, @Nullable String comment, @Nullable Boolean nullable, @Nullable Map<String, Object> metadata) {
        ImmutableMap.Builder fieldContents = ImmutableMap.builder();
        ImmutableMap.Builder columnMetadata = ImmutableMap.builder();
        if (comment != null) {
            columnMetadata.put((Object)"comment", (Object)comment);
        }
        if (metadata != null) {
            metadata.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).forEach(entry -> columnMetadata.put((Object)((String)entry.getKey()), entry.getValue()));
        }
        fieldContents.put((Object)"metadata", (Object)columnMetadata.buildOrThrow());
        fieldContents.put((Object)"name", (Object)name);
        fieldContents.put((Object)"nullable", (Object)(nullable != null ? nullable : true));
        fieldContents.put((Object)"type", DeltaLakeSchemaSupport.serializeColumnType(type));
        return fieldContents.buildOrThrow();
    }

    private static Object serializeColumnType(Type columnType) {
        if (columnType instanceof ArrayType) {
            return DeltaLakeSchemaSupport.serializeArrayType((ArrayType)columnType);
        }
        if (columnType instanceof RowType) {
            return DeltaLakeSchemaSupport.serializeStructType((RowType)columnType);
        }
        if (columnType instanceof MapType) {
            return DeltaLakeSchemaSupport.serializeMapType((MapType)columnType);
        }
        return DeltaLakeSchemaSupport.serializePrimitiveType(columnType);
    }

    private static Map<String, Object> serializeArrayType(ArrayType arrayType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"array");
        fields.put((Object)"containsNull", (Object)true);
        fields.put((Object)"elementType", DeltaLakeSchemaSupport.serializeColumnType(arrayType.getElementType()));
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeMapType(MapType mapType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"keyType", DeltaLakeSchemaSupport.serializeColumnType(mapType.getKeyType()));
        fields.put((Object)"type", (Object)"map");
        fields.put((Object)"valueContainsNull", (Object)true);
        fields.put((Object)"valueType", DeltaLakeSchemaSupport.serializeColumnType(mapType.getValueType()));
        return fields.buildOrThrow();
    }

    private static Map<String, Object> serializeStructType(RowType rowType) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        fields.put((Object)"type", (Object)"struct");
        fields.put((Object)"fields", rowType.getFields().stream().map(field -> DeltaLakeSchemaSupport.serializeStructField(field.getName().orElse(null), field.getType(), null, null, null)).collect(ImmutableList.toImmutableList()));
        return fields.buildOrThrow();
    }

    private static String serializePrimitiveType(Type type) {
        return DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).orElseThrow(() -> new TypeNotFoundException(type.getTypeSignature()));
    }

    private static Optional<String> serializeSupportedPrimitiveType(Type type) {
        if (type instanceof TimestampWithTimeZoneType) {
            return Optional.of("timestamp");
        }
        if (type instanceof VarcharType) {
            return Optional.of("string");
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return Optional.of(String.format("decimal(%s,%s)", decimalType.getPrecision(), decimalType.getScale()));
        }
        return Optional.ofNullable(PRIMITIVE_TYPE_MAPPING.get(type));
    }

    public static void validateType(Type type) {
        DeltaLakeSchemaSupport.validateType(Optional.empty(), type);
    }

    private static void validateType(Optional<Type> rootType, Type type) {
        if (HiveUtil.isStructuralType((Type)type)) {
            DeltaLakeSchemaSupport.validateStructuralType(Optional.of(rootType.orElse(type)), type);
        } else {
            DeltaLakeSchemaSupport.validatePrimitiveType(type);
        }
    }

    private static void validateStructuralType(Optional<Type> rootType, Type type) {
        if (type instanceof ArrayType) {
            DeltaLakeSchemaSupport.validateType(rootType, ((ArrayType)type).getElementType());
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getKeyType());
            DeltaLakeSchemaSupport.validateType(rootType, mapType.getValueType());
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            rowType.getFields().forEach(field -> DeltaLakeSchemaSupport.validateType(rootType, field.getType()));
        }
    }

    private static void validatePrimitiveType(Type type) {
        if (DeltaLakeSchemaSupport.serializeSupportedPrimitiveType(type).isEmpty() || type instanceof TimestampWithTimeZoneType && ((TimestampWithTimeZoneType)type).getPrecision() != 3) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unsupported type: " + type);
        }
    }

    public static String serializeStatsAsJson(DeltaLakeFileStatistics fileStatistics) throws JsonProcessingException {
        return OBJECT_MAPPER.writeValueAsString((Object)fileStatistics);
    }

    public static List<ColumnMetadata> extractColumnMetadata(MetadataEntry metadataEntry, TypeManager typeManager) {
        return (List)DeltaLakeSchemaSupport.extractSchema(metadataEntry, typeManager).stream().map(DeltaLakeColumnMetadata::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public static List<DeltaLakeColumnMetadata> extractSchema(MetadataEntry metadataEntry, TypeManager typeManager) {
        ColumnMappingMode mappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(metadataEntry);
        DeltaLakeSchemaSupport.verifySupportedColumnMapping(mappingMode);
        return Optional.ofNullable(metadataEntry.getSchemaString()).map(json -> DeltaLakeSchemaSupport.getColumnMetadata(json, typeManager, mappingMode)).orElseThrow(() -> new IllegalStateException("Serialized schema not found in transaction log for " + metadataEntry.getName()));
    }

    public static void verifySupportedColumnMapping(ColumnMappingMode mappingMode) {
        if (mappingMode != ColumnMappingMode.ID && mappingMode != ColumnMappingMode.NAME && mappingMode != ColumnMappingMode.NONE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Only 'id', 'name' or 'none' is supported for the '%s' table property", COLUMN_MAPPING_MODE_CONFIGURATION_KEY));
        }
    }

    @VisibleForTesting
    static List<DeltaLakeColumnMetadata> getColumnMetadata(String json, TypeManager typeManager, ColumnMappingMode mappingMode) {
        try {
            return (List)Streams.stream((Iterator)OBJECT_MAPPER.readTree(json).get("fields").elements()).map(node -> DeltaLakeSchemaSupport.mapColumn(typeManager, node, mappingMode)).collect(ImmutableList.toImmutableList());
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + json, (Throwable)e);
        }
    }

    private static DeltaLakeColumnMetadata mapColumn(TypeManager typeManager, JsonNode node, ColumnMappingMode mappingMode) {
        String physicalName;
        String fieldName = node.get("name").asText();
        JsonNode typeNode = node.get("type");
        boolean nullable = node.get("nullable").asBoolean();
        Type columnType = DeltaLakeSchemaSupport.buildType(typeManager, typeNode, false);
        OptionalInt fieldId = OptionalInt.empty();
        Type physicalColumnType = switch (mappingMode) {
            case ColumnMappingMode.ID -> {
                String columnMappingId = node.get("metadata").get("delta.columnMapping.id").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)columnMappingId) ? 1 : 0) != 0, (String)"id is null or empty", (Object[])new Object[0]);
                fieldId = OptionalInt.of(Integer.parseInt(columnMappingId));
                physicalName = node.get("metadata").get("delta.columnMapping.physicalName").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                yield DeltaLakeSchemaSupport.buildType(typeManager, typeNode, true);
            }
            case ColumnMappingMode.NAME -> {
                physicalName = node.get("metadata").get("delta.columnMapping.physicalName").asText();
                Verify.verify((!Strings.isNullOrEmpty((String)physicalName) ? 1 : 0) != 0, (String)"physicalName is null or empty", (Object[])new Object[0]);
                yield DeltaLakeSchemaSupport.buildType(typeManager, typeNode, true);
            }
            default -> {
                physicalName = fieldName;
                yield columnType;
            }
        };
        ColumnMetadata columnMetadata = ColumnMetadata.builder().setName(fieldName).setType(columnType).setNullable(nullable).setComment(Optional.ofNullable(DeltaLakeSchemaSupport.getComment(node))).build();
        return new DeltaLakeColumnMetadata(columnMetadata, fieldId, physicalName, physicalColumnType);
    }

    public static Map<String, String> getColumnComments(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getComment);
    }

    @Nullable
    private static String getComment(JsonNode node) {
        JsonNode comment = node.get("metadata").get("comment");
        return comment == null ? null : comment.asText();
    }

    public static Map<String, Boolean> getColumnsNullability(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, node -> node.get("nullable").asBoolean());
    }

    public static Map<String, String> getColumnInvariants(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getInvariants);
    }

    @Nullable
    private static String getInvariants(JsonNode node) {
        JsonNode invariants = node.get("metadata").get("delta.invariants");
        return invariants == null ? null : DeltaLakeSchemaSupport.extractInvariantsExpression(invariants.asText());
    }

    private static String extractInvariantsExpression(String invariants) {
        try {
            return OBJECT_MAPPER.readTree(invariants).get("expression").get("expression").asText();
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse invariants expression: " + invariants, (Throwable)e);
        }
    }

    public static Map<String, String> getGeneratedColumnExpressions(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, DeltaLakeSchemaSupport::getGeneratedColumnExpressions);
    }

    @Nullable
    private static String getGeneratedColumnExpressions(JsonNode node) {
        JsonNode generationExpression = node.get("metadata").get("delta.generationExpression");
        return generationExpression == null ? null : generationExpression.asText();
    }

    public static Map<String, String> getCheckConstraints(MetadataEntry metadataEntry) {
        return (Map)metadataEntry.getConfiguration().entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("delta.constraints.")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static boolean changeDataFeedEnabled(MetadataEntry metadataEntry) {
        String enableChangeDataFeed = metadataEntry.getConfiguration().getOrDefault("delta.enableChangeDataFeed", "false");
        return Boolean.parseBoolean(enableChangeDataFeed);
    }

    public static Map<String, Map<String, Object>> getColumnsMetadata(MetadataEntry metadataEntry) {
        return DeltaLakeSchemaSupport.getColumnProperties(metadataEntry, node -> (Map)OBJECT_MAPPER.convertValue((Object)node.get("metadata"), (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }

    public static <T> Map<String, T> getColumnProperties(MetadataEntry metadataEntry, Function<JsonNode, T> extractor) {
        return Optional.ofNullable(metadataEntry.getSchemaString()).map(json -> DeltaLakeSchemaSupport.getColumnProperty(json, extractor)).orElseThrow(() -> new IllegalStateException("Serialized schema not found in transaction log for " + metadataEntry.getName()));
    }

    private static <T> Map<String, T> getColumnProperty(String json, Function<JsonNode, T> extractor) {
        try {
            return (Map)Streams.stream((Iterator)OBJECT_MAPPER.readTree(json).get("fields").elements()).map(field -> new AbstractMap.SimpleEntry(field.get("name").asText(), extractor.apply((JsonNode)field))).filter(entry -> entry.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (JsonProcessingException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, DeltaLakeSchemaSupport.getLocation(e), "Failed to parse serialized schema: " + json, (Throwable)e);
        }
    }

    public static Set<String> unsupportedReaderFeatures(Set<String> features) {
        return Sets.difference(features, SUPPORTED_READER_FEATURES);
    }

    private static Type buildType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) {
        if (typeNode.isContainerNode()) {
            return DeltaLakeSchemaSupport.buildContainerType(typeManager, typeNode, usePhysicalName);
        }
        String primitiveType = typeNode.asText();
        if (primitiveType.startsWith("decimal")) {
            return typeManager.fromSqlType(primitiveType);
        }
        switch (primitiveType) {
            case "string": {
                return VarcharType.VARCHAR;
            }
            case "long": {
                return BigintType.BIGINT;
            }
            case "integer": {
                return IntegerType.INTEGER;
            }
            case "short": {
                return SmallintType.SMALLINT;
            }
            case "byte": {
                return TinyintType.TINYINT;
            }
            case "float": {
                return RealType.REAL;
            }
            case "double": {
                return DoubleType.DOUBLE;
            }
            case "boolean": {
                return BooleanType.BOOLEAN;
            }
            case "binary": {
                return VarbinaryType.VARBINARY;
            }
            case "date": {
                return DateType.DATE;
            }
            case "timestamp": {
                return TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3);
            }
        }
        throw new TypeNotFoundException(new TypeSignature(primitiveType, new TypeSignatureParameter[0]));
    }

    private static Type buildContainerType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) {
        String containerType;
        switch (containerType = typeNode.get("type").asText()) {
            case "array": {
                return DeltaLakeSchemaSupport.buildArrayType(typeManager, typeNode, usePhysicalName);
            }
            case "map": {
                return DeltaLakeSchemaSupport.buildMapType(typeManager, typeNode, usePhysicalName);
            }
            case "struct": {
                return DeltaLakeSchemaSupport.buildRowType(typeManager, typeNode, usePhysicalName);
            }
        }
        throw new TypeNotFoundException(new TypeSignature(containerType, new TypeSignatureParameter[0]));
    }

    private static RowType buildRowType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) {
        return (RowType)typeManager.getType(TypeSignature.rowType((List)((List)Streams.stream((Iterator)typeNode.get("fields").elements()).map(element -> {
            String fieldName = usePhysicalName ? element.get("metadata").get("delta.columnMapping.physicalName").asText() : element.get("name").asText();
            Verify.verify((!Strings.isNullOrEmpty((String)fieldName) ? 1 : 0) != 0, (String)"fieldName is null or empty", (Object[])new Object[0]);
            return TypeSignatureParameter.namedField((String)TransactionLogAccess.canonicalizeColumnName(fieldName), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, element.get("type"), usePhysicalName).getTypeSignature());
        }).collect(ImmutableList.toImmutableList()))));
    }

    private static ArrayType buildArrayType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) {
        return (ArrayType)typeManager.getType(TypeSignature.arrayType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("elementType"), usePhysicalName).getTypeSignature()));
    }

    private static MapType buildMapType(TypeManager typeManager, JsonNode typeNode, boolean usePhysicalName) {
        return (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("keyType"), usePhysicalName).getTypeSignature(), (TypeSignature)DeltaLakeSchemaSupport.buildType(typeManager, typeNode.get("valueType"), usePhysicalName).getTypeSignature()));
    }

    private static Optional<Location> getLocation(JsonProcessingException e) {
        return Optional.ofNullable(e.getLocation()).map(location -> new Location(location.getLineNr(), location.getColumnNr()));
    }

    public static enum ColumnMappingMode {
        ID,
        NAME,
        NONE,
        UNKNOWN;

    }
}

