/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CdfFileEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.deltalake.transactionlog.ProtocolEntry;
import io.trino.plugin.deltalake.transactionlog.RemoveFileEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionEntry;
import java.util.Objects;
import javax.annotation.Nullable;

public class DeltaLakeTransactionLogEntry {
    private final TransactionEntry txn;
    private final AddFileEntry add;
    private final RemoveFileEntry remove;
    private final MetadataEntry metaData;
    private final ProtocolEntry protocol;
    private final CommitInfoEntry commitInfo;
    private final CdfFileEntry cdfFileEntry;

    private DeltaLakeTransactionLogEntry(TransactionEntry txn, AddFileEntry add, RemoveFileEntry remove, MetadataEntry metaData, ProtocolEntry protocol, CommitInfoEntry commitInfo, CdfFileEntry cdfFileEntry) {
        this.txn = txn;
        this.add = add;
        this.remove = remove;
        this.metaData = metaData;
        this.protocol = protocol;
        this.commitInfo = commitInfo;
        this.cdfFileEntry = cdfFileEntry;
    }

    @JsonCreator
    public static DeltaLakeTransactionLogEntry fromJson(@JsonProperty(value="txn") TransactionEntry txn, @JsonProperty(value="add") AddFileEntry add, @JsonProperty(value="remove") RemoveFileEntry remove, @JsonProperty(value="metaData") MetadataEntry metaData, @JsonProperty(value="protocol") ProtocolEntry protocol, @JsonProperty(value="commitInfo") CommitInfoEntry commitInfo, @JsonProperty(value="cdfFileEntry") CdfFileEntry cdfFileEntry) {
        return new DeltaLakeTransactionLogEntry(txn, add, remove, metaData, protocol, commitInfo, cdfFileEntry);
    }

    public static DeltaLakeTransactionLogEntry transactionEntry(TransactionEntry transaction) {
        Objects.requireNonNull(transaction, "transaction is null");
        return new DeltaLakeTransactionLogEntry(transaction, null, null, null, null, null, null);
    }

    public static DeltaLakeTransactionLogEntry commitInfoEntry(CommitInfoEntry commitInfo) {
        Objects.requireNonNull(commitInfo, "commitInfo is null");
        return new DeltaLakeTransactionLogEntry(null, null, null, null, null, commitInfo, null);
    }

    public static DeltaLakeTransactionLogEntry protocolEntry(ProtocolEntry protocolEntry) {
        Objects.requireNonNull(protocolEntry, "protocolEntry is null");
        return new DeltaLakeTransactionLogEntry(null, null, null, null, protocolEntry, null, null);
    }

    public static DeltaLakeTransactionLogEntry metadataEntry(MetadataEntry metadataEntry) {
        Objects.requireNonNull(metadataEntry, "metadataEntry is null");
        return new DeltaLakeTransactionLogEntry(null, null, null, metadataEntry, null, null, null);
    }

    public static DeltaLakeTransactionLogEntry addFileEntry(AddFileEntry addFileEntry) {
        Objects.requireNonNull(addFileEntry, "addFileEntry is null");
        return new DeltaLakeTransactionLogEntry(null, addFileEntry, null, null, null, null, null);
    }

    public static DeltaLakeTransactionLogEntry removeFileEntry(RemoveFileEntry removeFileEntry) {
        Objects.requireNonNull(removeFileEntry, "removeFileEntry is null");
        return new DeltaLakeTransactionLogEntry(null, null, removeFileEntry, null, null, null, null);
    }

    public static DeltaLakeTransactionLogEntry cdfFileEntry(CdfFileEntry cdfFileEntry) {
        Objects.requireNonNull(cdfFileEntry, "cdfFileEntry is null");
        return new DeltaLakeTransactionLogEntry(null, null, null, null, null, null, cdfFileEntry);
    }

    @Nullable
    @JsonProperty
    public TransactionEntry getTxn() {
        return this.txn;
    }

    @Nullable
    @JsonProperty
    public AddFileEntry getAdd() {
        return this.add;
    }

    @Nullable
    @JsonProperty
    public RemoveFileEntry getRemove() {
        return this.remove;
    }

    @Nullable
    @JsonProperty
    public MetadataEntry getMetaData() {
        return this.metaData;
    }

    @Nullable
    @JsonProperty
    public ProtocolEntry getProtocol() {
        return this.protocol;
    }

    @Nullable
    @JsonProperty
    public CommitInfoEntry getCommitInfo() {
        return this.commitInfo;
    }

    @Nullable
    @JsonProperty
    public CdfFileEntry getCDC() {
        return this.cdfFileEntry;
    }

    public DeltaLakeTransactionLogEntry withCommitInfo(CommitInfoEntry commitInfo) {
        return new DeltaLakeTransactionLogEntry(this.txn, this.add, this.remove, this.metaData, this.protocol, commitInfo, this.cdfFileEntry);
    }

    public String toString() {
        return String.format("DeltaLakeTransactionLogEntry{%s, %s, %s, %s, %s, %s, %s}", this.txn, this.add, this.remove, this.metaData, this.protocol, this.commitInfo, this.cdfFileEntry);
    }
}

