/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.failsafe.Failsafe;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.Logger;
import io.airlift.slice.Slices;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class TransactionLogParser {
    private static final Logger log = Logger.get(TransactionLogParser.class);
    public static final LocalDate START_OF_MODERN_ERA = LocalDate.of(1900, 1, 2);
    public static final String LAST_CHECKPOINT_FILENAME = "_last_checkpoint";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapperProvider().get();
    public static final DateTimeFormatter PARTITION_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter(Locale.ENGLISH).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);
    public static final DateTimeFormatter JSON_STATISTICS_TIMESTAMP_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NORMAL).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffsetId().optionalStart().appendLiteral('[').parseCaseSensitive().appendZoneRegionId().appendLiteral(']').toFormatter(Locale.ENGLISH).withChronology(IsoChronology.INSTANCE).withResolverStyle(ResolverStyle.STRICT);

    private TransactionLogParser() {
    }

    public static DeltaLakeTransactionLogEntry parseJson(String json) throws JsonProcessingException {
        if (json.endsWith("x")) {
            json = json.substring(0, json.length() - 1);
        }
        return (DeltaLakeTransactionLogEntry)JsonUtils.parseJson((ObjectMapper)OBJECT_MAPPER, (String)json, DeltaLakeTransactionLogEntry.class);
    }

    private static Object parseDecimal(DecimalType type, String valueString) {
        BigDecimal bigDecimal = new BigDecimal(valueString).setScale(type.getScale());
        if (type.isShort()) {
            return bigDecimal.unscaledValue().longValueExact();
        }
        return Decimals.valueOf((BigInteger)bigDecimal.unscaledValue());
    }

    @Nullable
    public static Object deserializePartitionValue(DeltaLakeColumnHandle column, Optional<String> valueString) {
        return valueString.map(value -> TransactionLogParser.deserializeColumnValue(column, value, TransactionLogParser::readPartitionTimestamp)).orElse(null);
    }

    private static Long readPartitionTimestamp(String timestamp) {
        ZonedDateTime zonedDateTime = LocalDateTime.parse(timestamp, PARTITION_TIMESTAMP_FORMATTER).atZone(ZoneOffset.UTC);
        return DateTimeEncoding.packDateTimeWithZone((long)zonedDateTime.toInstant().toEpochMilli(), (TimeZoneKey)TimeZoneKey.UTC_KEY);
    }

    public static Object deserializeColumnValue(DeltaLakeColumnHandle column, String valueString, Function<String, Long> timestampReader) {
        Type type = column.getType();
        try {
            if (type.equals(BooleanType.BOOLEAN)) {
                if (valueString.equalsIgnoreCase("true")) {
                    return true;
                }
                if (valueString.equalsIgnoreCase("false")) {
                    return false;
                }
            }
            if (type.equals(IntegerType.INTEGER)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals(SmallintType.SMALLINT)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals(TinyintType.TINYINT)) {
                return (long)Integer.parseInt(valueString);
            }
            if (type.equals(BigintType.BIGINT)) {
                return Long.parseLong(valueString);
            }
            if (type.getBaseName().equals("decimal")) {
                return TransactionLogParser.parseDecimal((DecimalType)type, valueString);
            }
            if (type.equals(RealType.REAL)) {
                return (long)Float.floatToRawIntBits(Float.parseFloat(valueString));
            }
            if (type.equals(DoubleType.DOUBLE)) {
                return Double.parseDouble(valueString);
            }
            if (type.equals(DateType.DATE)) {
                return LocalDate.parse(valueString).toEpochDay();
            }
            if (type.equals(TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3))) {
                return timestampReader.apply(valueString);
            }
            if (VarcharType.VARCHAR.equals((Object)type)) {
                return Slices.utf8Slice((String)valueString);
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unable to parse value [%s] from column %s with type %s", valueString, column.getName(), column.getType()), (Throwable)e);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Unable to parse value [%s] from column %s with type %s", valueString, column.getName(), column.getType()));
    }

    static Optional<LastCheckpoint> readLastCheckpoint(TrinoFileSystem fileSystem, String tableLocation) {
        return (Optional)Failsafe.with((Policy)RetryPolicy.builder().withMaxRetries(5).withDelay(Duration.ofSeconds(1L)).onRetry(event -> log.debug(event.getLastException(), "Failure when accessing last checkpoint information, will be retried")).build(), (Policy[])new RetryPolicy[0]).get(() -> TransactionLogParser.tryReadLastCheckpoint(fileSystem, tableLocation));
    }

    private static Optional<LastCheckpoint> tryReadLastCheckpoint(TrinoFileSystem fileSystem, String tableLocation) throws JsonParseException, JsonMappingException {
        Optional<LastCheckpoint> optional;
        block9: {
            String checkpointPath = Locations.appendPath((String)TransactionLogUtil.getTransactionLogDir(tableLocation), (String)LAST_CHECKPOINT_FILENAME);
            TrinoInputFile inputFile = fileSystem.newInputFile(checkpointPath);
            TrinoInputStream lastCheckpointInput = inputFile.newStream();
            try {
                optional = Optional.of((LastCheckpoint)JsonUtils.parseJson((ObjectMapper)OBJECT_MAPPER, (InputStream)lastCheckpointInput, LastCheckpoint.class));
                if (lastCheckpointInput == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (lastCheckpointInput != null) {
                        try {
                            lastCheckpointInput.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException | JsonMappingException e) {
                    throw e;
                }
                catch (IOException | UncheckedIOException e) {
                    return Optional.empty();
                }
            }
            lastCheckpointInput.close();
        }
        return optional;
    }

    public static long getMandatoryCurrentVersion(TrinoFileSystem fileSystem, String tableLocation) throws IOException {
        long version = TransactionLogParser.readLastCheckpoint(fileSystem, tableLocation).map(LastCheckpoint::getVersion).orElse(0L);
        String transactionLogDir = TransactionLogUtil.getTransactionLogDir(tableLocation);
        String entryPath;
        while (fileSystem.newInputFile(entryPath = TransactionLogUtil.getTransactionLogJsonEntryPath(transactionLogDir, version + 1L)).exists()) {
            ++version;
        }
        return version;
    }
}

