/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.trino.plugin.deltalake.DataFileInfo;
import java.util.Objects;
import java.util.Optional;

public class DeltaLakeMergeResult {
    private final Optional<String> oldFile;
    private final Optional<DataFileInfo> newFile;

    @JsonCreator
    public DeltaLakeMergeResult(Optional<String> oldFile, Optional<DataFileInfo> newFile) {
        this.oldFile = Objects.requireNonNull(oldFile, "oldFile is null");
        this.newFile = Objects.requireNonNull(newFile, "newFile is null");
        Preconditions.checkArgument((oldFile.isPresent() || newFile.isPresent() ? 1 : 0) != 0, (Object)"old or new must be present");
    }

    @JsonProperty
    public Optional<String> getOldFile() {
        return this.oldFile;
    }

    @JsonProperty
    public Optional<DataFileInfo> getNewFile() {
        return this.newFile;
    }
}

