/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.reader.MetadataReader;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnProjectionInfo;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakePageSource;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.ReaderProjectionsAdapter;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSourceProvider
implements ConnectorPageSourceProvider {
    private static final int MAX_RLE_PAGE_SIZE = 131072;
    private static final int MAX_RLE_ROW_ID_PAGE_SIZE = 65536;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final ParquetReaderOptions parquetReaderOptions;
    private final int domainCompactionThreshold;
    private final DateTimeZone parquetDateTimeZone;
    private final TypeManager typeManager;

    @Inject
    public DeltaLakePageSourceProvider(TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats fileFormatDataSourceStats, ParquetReaderConfig parquetReaderConfig, DeltaLakeConfig deltaLakeConfig, TypeManager typeManager) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.parquetReaderOptions = parquetReaderConfig.toParquetReaderOptions().withBloomFilter(false);
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit connectorSplit, ConnectorTableHandle connectorTable, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        TupleDomain filteredSplitPredicate;
        DeltaLakeSplit split = (DeltaLakeSplit)connectorSplit;
        DeltaLakeTableHandle table = (DeltaLakeTableHandle)connectorTable;
        List deltaLakeColumns = (List)columns.stream().map(DeltaLakeColumnHandle.class::cast).collect(ImmutableList.toImmutableList());
        List regularColumns = (List)deltaLakeColumns.stream().filter(column -> column.getColumnType() == DeltaLakeColumnType.REGULAR || column.getBaseColumnName().equals("$row_id")).collect(ImmutableList.toImmutableList());
        Map<String, Optional<String>> partitionKeys = split.getPartitionKeys();
        Optional<Object> partitionValues = Optional.empty();
        if (deltaLakeColumns.stream().anyMatch(column -> column.getBaseColumnName().equals("$row_id"))) {
            partitionValues = Optional.of(new ArrayList());
            for (DeltaLakeColumnMetadata column2 : DeltaLakeSchemaSupport.extractSchema(table.getMetadataEntry(), this.typeManager)) {
                Optional<String> value = partitionKeys.get(column2.getName());
                if (value == null) continue;
                ((List)partitionValues.get()).add(value.orElse(null));
            }
        }
        if ((filteredSplitPredicate = TupleDomain.intersect((List)ImmutableList.of(table.getNonPartitionConstraint(), split.getStatisticsPredicate(), (Object)dynamicFilter.getCurrentPredicate().transformKeys(DeltaLakeColumnHandle.class::cast)))).isNone()) {
            return new EmptyPageSource();
        }
        if (filteredSplitPredicate.isAll() && split.getStart() == 0L && split.getLength() == split.getFileSize() && split.getFileRowCount().isPresent() && (regularColumns.isEmpty() || DeltaLakePageSourceProvider.onlyRowIdColumn(regularColumns))) {
            return new DeltaLakePageSource(deltaLakeColumns, (Set<String>)ImmutableSet.of(), partitionKeys, partitionValues, DeltaLakePageSourceProvider.generatePages(split.getFileRowCount().get(), DeltaLakePageSourceProvider.onlyRowIdColumn(regularColumns)), Optional.empty(), split.getPath(), split.getFileSize(), split.getFileModifiedTime());
        }
        Location location = Location.of((String)split.getPath());
        TrinoInputFile inputFile = this.fileSystemFactory.create(session).newInputFile(location, split.getFileSize());
        ParquetReaderOptions options = this.parquetReaderOptions.withMaxReadBlockSize(DeltaLakeSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(DeltaLakeSessionProperties.getParquetMaxReadBlockRowCount(session)).withUseColumnIndex(DeltaLakeSessionProperties.isParquetUseColumnIndex(session)).withBatchColumnReaders(DeltaLakeSessionProperties.isParquetOptimizedReaderEnabled(session)).withBatchNestedColumnReaders(DeltaLakeSessionProperties.isParquetOptimizedNestedReaderEnabled(session));
        DeltaLakeSchemaSupport.ColumnMappingMode columnMappingMode = DeltaLakeSchemaSupport.getColumnMappingMode(table.getMetadataEntry());
        ImmutableMap parquetFieldIdToName = columnMappingMode == DeltaLakeSchemaSupport.ColumnMappingMode.ID ? this.loadParquetIdAndNameMapping(inputFile, options) : ImmutableMap.of();
        ImmutableSet.Builder missingColumnNames = ImmutableSet.builder();
        ImmutableList.Builder hiveColumnHandles = ImmutableList.builder();
        for (DeltaLakeColumnHandle column3 : regularColumns) {
            if (column3.getBaseColumnName().equals("$row_id")) {
                hiveColumnHandles.add((Object)ParquetPageSourceFactory.PARQUET_ROW_INDEX_COLUMN);
                continue;
            }
            DeltaLakePageSourceProvider.toHiveColumnHandle(column3, columnMappingMode, (Map<Integer, String>)parquetFieldIdToName).ifPresentOrElse(arg_0 -> ((ImmutableList.Builder)hiveColumnHandles).add(arg_0), () -> missingColumnNames.add((Object)column3.getBaseColumnName()));
        }
        TupleDomain<HiveColumnHandle> parquetPredicate = DeltaLakePageSourceProvider.getParquetTupleDomain((TupleDomain<DeltaLakeColumnHandle>)filteredSplitPredicate.simplify(this.domainCompactionThreshold), columnMappingMode, (Map<Integer, String>)parquetFieldIdToName);
        ReaderPageSource pageSource = ParquetPageSourceFactory.createPageSource((TrinoInputFile)inputFile, (long)split.getStart(), (long)split.getLength(), (List)hiveColumnHandles.build(), parquetPredicate, (boolean)true, (DateTimeZone)this.parquetDateTimeZone, (FileFormatDataSourceStats)this.fileFormatDataSourceStats, (ParquetReaderOptions)options, Optional.empty(), (int)this.domainCompactionThreshold);
        Optional<ReaderProjectionsAdapter> projectionsAdapter = pageSource.getReaderColumns().map(readerColumns -> new ReaderProjectionsAdapter((List)hiveColumnHandles.build(), readerColumns, column -> ((HiveColumnHandle)column).getType(), HivePageSourceProvider::getProjection));
        return new DeltaLakePageSource(deltaLakeColumns, (Set<String>)missingColumnNames.build(), partitionKeys, partitionValues, pageSource.get(), projectionsAdapter, split.getPath(), split.getFileSize(), split.getFileModifiedTime());
    }

    public Map<Integer, String> loadParquetIdAndNameMapping(TrinoInputFile inputFile, ParquetReaderOptions options) {
        Map map;
        TrinoParquetDataSource dataSource = new TrinoParquetDataSource(inputFile, options, this.fileFormatDataSourceStats);
        try {
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, Optional.empty());
            FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            map = (Map)fileSchema.getFields().stream().filter(field -> field.getId() != null).collect(ImmutableMap.toImmutableMap(field -> field.getId().intValue(), Type::getName));
        }
        catch (Throwable throwable) {
            try {
                try {
                    dataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        dataSource.close();
        return map;
    }

    public static TupleDomain<HiveColumnHandle> getParquetTupleDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate, DeltaLakeSchemaSupport.ColumnMappingMode columnMapping, Map<Integer, String> fieldIdToName) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        ((Map)effectivePredicate.getDomains().get()).forEach((columnHandle, domain) -> {
            String baseType = columnHandle.getBaseType().getTypeSignature().getBase();
            if (!(baseType.equals("map") || baseType.equals("array") || baseType.equals("row"))) {
                Optional<HiveColumnHandle> hiveColumnHandle = DeltaLakePageSourceProvider.toHiveColumnHandle(columnHandle, columnMapping, fieldIdToName);
                hiveColumnHandle.ifPresent(column -> predicate.put(column, domain));
            }
        });
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    public static Optional<HiveColumnHandle> toHiveColumnHandle(DeltaLakeColumnHandle deltaLakeColumnHandle, DeltaLakeSchemaSupport.ColumnMappingMode columnMapping, Map<Integer, String> fieldIdToName) {
        switch (columnMapping) {
            case ID: {
                Integer fieldId = deltaLakeColumnHandle.getBaseFieldId().orElseThrow(() -> new IllegalArgumentException("Field ID must exist"));
                if (!fieldIdToName.containsKey(fieldId)) {
                    return Optional.empty();
                }
                String fieldName = fieldIdToName.get(fieldId);
                Optional<HiveColumnProjectionInfo> hiveColumnProjectionInfo = deltaLakeColumnHandle.getProjectionInfo().map(DeltaLakeColumnProjectionInfo::toHiveColumnProjectionInfo);
                return Optional.of(new HiveColumnHandle(fieldName, 0, DeltaHiveTypeTranslator.toHiveType(deltaLakeColumnHandle.getBasePhysicalType()), deltaLakeColumnHandle.getBasePhysicalType(), hiveColumnProjectionInfo, deltaLakeColumnHandle.getColumnType().toHiveColumnType(), Optional.empty()));
            }
            case NAME: 
            case NONE: {
                Preconditions.checkArgument((boolean)fieldIdToName.isEmpty(), (String)"Mapping between field id and name must be empty: %s", fieldIdToName);
                return Optional.of(deltaLakeColumnHandle.toHiveColumnHandle());
            }
        }
        throw new IllegalArgumentException("Unsupported column mapping: " + columnMapping);
    }

    private static boolean onlyRowIdColumn(List<DeltaLakeColumnHandle> columns) {
        return columns.size() == 1 && ((DeltaLakeColumnHandle)Iterables.getOnlyElement(columns)).getBaseColumnName().equals("$row_id");
    }

    private static ConnectorPageSource generatePages(final long totalRowCount, final boolean projectRowNumber) {
        return new FixedPageSource((Iterator)new AbstractIterator<Page>(){
            private static final Block[] EMPTY_BLOCKS = new Block[0];
            private final int maxPageSize;
            private long rowIndex;
            {
                this.maxPageSize = projectRowNumber ? 65536 : 131072;
            }

            protected Page computeNext() {
                if (this.rowIndex == totalRowCount) {
                    return (Page)this.endOfData();
                }
                int pageSize = Math.toIntExact(Math.min((long)this.maxPageSize, totalRowCount - this.rowIndex));
                Block[] blocks = projectRowNumber ? new Block[]{DeltaLakePageSourceProvider.createRowNumberBlock(this.rowIndex, pageSize)} : EMPTY_BLOCKS;
                this.rowIndex += (long)pageSize;
                return new Page(pageSize, blocks);
            }
        }, 0L);
    }

    private static Block createRowNumberBlock(long baseIndex, int size) {
        long[] rowIndices = new long[size];
        for (int position = 0; position < size; ++position) {
            rowIndices[position] = baseIndex + (long)position;
        }
        return new LongArrayBlock(size, Optional.empty(), rowIndices);
    }
}

