/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog;

import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.filesystem.Locations;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import java.util.Map;
import java.util.Optional;

public final class TransactionLogUtil {
    public static final String TRANSACTION_LOG_DIRECTORY = "_delta_log";

    private TransactionLogUtil() {
    }

    public static String getTransactionLogDir(String tableLocation) {
        return Locations.appendPath((String)tableLocation, (String)TRANSACTION_LOG_DIRECTORY);
    }

    public static Location getTransactionLogJsonEntryPath(String transactionLogDir, long entryNumber) {
        return Location.of((String)transactionLogDir).appendPath("%020d.json".formatted(entryNumber));
    }

    public static Map<String, Optional<String>> canonicalizePartitionValues(Map<String, String> partitionValues) {
        return (Map)partitionValues.entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> TransactionLogAccess.canonicalizeColumnName((String)entry.getKey()), entry -> {
            String value = (String)entry.getValue();
            if (value == null || value.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(value);
        }));
    }
}

