/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.airlift.stats.TimeStat;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.hdfs.HadoopPaths;
import io.trino.filesystem.hdfs.HdfsFileSystem;
import io.trino.filesystem.hdfs.HdfsOutputStream;
import io.trino.hdfs.CallStats;
import io.trino.hdfs.FileSystemUtils;
import io.trino.hdfs.HdfsContext;
import io.trino.hdfs.HdfsEnvironment;
import io.trino.hdfs.MemoryAwareFileSystem;
import io.trino.hdfs.authentication.GenericExceptionAction;
import io.trino.memory.context.AggregatedMemoryContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

class HdfsOutputFile
implements TrinoOutputFile {
    private final Location location;
    private final HdfsEnvironment environment;
    private final HdfsContext context;
    private final CallStats createFileCallStat;

    public HdfsOutputFile(Location location, HdfsEnvironment environment, HdfsContext context, CallStats createFileCallStat) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.environment = Objects.requireNonNull(environment, "environment is null");
        this.context = Objects.requireNonNull(context, "context is null");
        this.createFileCallStat = Objects.requireNonNull(createFileCallStat, "createFileCallStat is null");
        location.verifyValidFileLocation();
    }

    public OutputStream create(AggregatedMemoryContext memoryContext) throws IOException {
        return this.create(false, memoryContext);
    }

    public OutputStream createOrOverwrite(AggregatedMemoryContext memoryContext) throws IOException {
        return this.create(true, memoryContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OutputStream create(boolean overwrite, AggregatedMemoryContext memoryContext) throws IOException {
        this.createFileCallStat.newCall();
        Path file = HadoopPaths.hadoopPath(this.location);
        FileSystem fileSystem = this.environment.getFileSystem(this.context, file);
        FileSystem rawFileSystem = FileSystemUtils.getRawFileSystem(fileSystem);
        try (TimeStat.BlockTimer ignored = this.createFileCallStat.time();){
            if (rawFileSystem instanceof MemoryAwareFileSystem) {
                MemoryAwareFileSystem memoryAwareFileSystem = (MemoryAwareFileSystem)rawFileSystem;
                OutputStream outputStream2 = this.create(() -> memoryAwareFileSystem.create(file, memoryContext));
                return outputStream2;
            }
            OutputStream outputStream = this.create(() -> fileSystem.create(file, overwrite));
            return outputStream;
        }
        catch (FileAlreadyExistsException e) {
            this.createFileCallStat.recordException((Exception)((Object)e));
            throw HdfsFileSystem.withCause(new java.nio.file.FileAlreadyExistsException(this.toString()), e);
        }
        catch (IOException e) {
            this.createFileCallStat.recordException(e);
            throw new IOException("Creation of file %s failed: %s".formatted(file, e.getMessage()), e);
        }
    }

    private OutputStream create(GenericExceptionAction<FSDataOutputStream, IOException> action) throws IOException {
        FSDataOutputStream out = this.environment.doAs(this.context.getIdentity(), action);
        return new HdfsOutputStream(this.location, out, this.environment, this.context);
    }

    public Location location() {
        return this.location;
    }

    public String toString() {
        return this.location().toString();
    }
}

