/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.hdfs;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoInputStream;
import io.trino.filesystem.hdfs.HdfsFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

class HdfsTrinoInputStream
extends TrinoInputStream {
    private final Location location;
    private final FSDataInputStream stream;
    private boolean closed;

    HdfsTrinoInputStream(Location location, FSDataInputStream stream) {
        this.location = Objects.requireNonNull(location, "location is null");
        this.stream = Objects.requireNonNull(stream, "stream is null");
    }

    public int available() throws IOException {
        this.ensureOpen();
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            throw new IOException("Get available for file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public long getPosition() throws IOException {
        this.ensureOpen();
        try {
            return this.stream.getPos();
        }
        catch (IOException e) {
            throw new IOException("Get position for file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public void seek(long position) throws IOException {
        this.ensureOpen();
        try {
            this.stream.seek(position);
        }
        catch (IOException e) {
            throw new IOException("Seek to position %s for file %s failed: %s".formatted(position, this.location, e.getMessage()), e);
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        try {
            return this.stream.read();
        }
        catch (FileNotFoundException e) {
            throw HdfsFileSystem.withCause(new FileNotFoundException("File %s not found: %s".formatted(this.location, e.getMessage())), e);
        }
        catch (IOException e) {
            throw new IOException("Read of file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        try {
            return this.stream.read(b, off, len);
        }
        catch (FileNotFoundException e) {
            throw HdfsFileSystem.withCause(new FileNotFoundException("File %s not found: %s".formatted(this.location, e.getMessage())), e);
        }
        catch (IOException e) {
            throw new IOException("Read of file %s failed: %s".formatted(this.location, e.getMessage()), e);
        }
    }

    public void close() throws IOException {
        this.closed = true;
        this.stream.close();
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Output stream closed: " + this.location);
        }
    }
}

