/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.awssdk.v1_11;

import com.amazonaws.Request;
import com.amazonaws.Response;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class AwsSdkHttpAttributesGetter
implements HttpClientAttributesGetter<Request<?>, Response<?>> {
    AwsSdkHttpAttributesGetter() {
    }

    public String getUrl(Request<?> request) {
        return request.getEndpoint().toString();
    }

    public String getMethod(Request<?> request) {
        return request.getHttpMethod().name();
    }

    public List<String> getRequestHeader(Request<?> request, String name) {
        String value = (String)request.getHeaders().get(name.equals("user-agent") ? "User-Agent" : name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    public Integer getStatusCode(Request<?> request, Response<?> response, @Nullable Throwable error) {
        return response.getHttpResponse().getStatusCode();
    }

    public List<String> getResponseHeader(Request<?> request, Response<?> response, String name) {
        String value = (String)response.getHttpResponse().getHeaders().get(name);
        return value == null ? Collections.emptyList() : Collections.singletonList(value);
    }
}

