/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.manager;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

final class SwitchingFileSystem
implements TrinoFileSystem {
    private final Optional<ConnectorSession> session;
    private final Optional<ConnectorIdentity> identity;
    private final Optional<TrinoFileSystemFactory> hdfsFactory;
    private final Map<String, TrinoFileSystemFactory> factories;

    public SwitchingFileSystem(Optional<ConnectorSession> session, Optional<ConnectorIdentity> identity, Optional<TrinoFileSystemFactory> hdfsFactory, Map<String, TrinoFileSystemFactory> factories) {
        Preconditions.checkArgument((session.isPresent() != identity.isPresent() ? 1 : 0) != 0, (Object)"exactly one of session and identity must be present");
        this.session = session;
        this.identity = identity;
        this.hdfsFactory = Objects.requireNonNull(hdfsFactory, "hdfsFactory is null");
        this.factories = ImmutableMap.copyOf(Objects.requireNonNull(factories, "factories is null"));
    }

    public TrinoInputFile newInputFile(Location location) {
        return this.fileSystem(location).newInputFile(location);
    }

    public TrinoInputFile newInputFile(Location location, long length) {
        return this.fileSystem(location).newInputFile(location, length);
    }

    public TrinoOutputFile newOutputFile(Location location) {
        return this.fileSystem(location).newOutputFile(location);
    }

    public void deleteFile(Location location) throws IOException {
        this.fileSystem(location).deleteFile(location);
    }

    public void deleteFiles(Collection<Location> locations) throws IOException {
        Map<TrinoFileSystemFactory, List<Location>> groups = locations.stream().collect(Collectors.groupingBy(this::determineFactory));
        for (Map.Entry<TrinoFileSystemFactory, List<Location>> entry : groups.entrySet()) {
            this.createFileSystem(entry.getKey()).deleteFiles((Collection)entry.getValue());
        }
    }

    public void deleteDirectory(Location location) throws IOException {
        this.fileSystem(location).deleteDirectory(location);
    }

    public void renameFile(Location source, Location target) throws IOException {
        this.fileSystem(source).renameFile(source, target);
    }

    public FileIterator listFiles(Location location) throws IOException {
        return this.fileSystem(location).listFiles(location);
    }

    public Optional<Boolean> directoryExists(Location location) throws IOException {
        return this.fileSystem(location).directoryExists(location);
    }

    public void createDirectory(Location location) throws IOException {
        this.fileSystem(location).createDirectory(location);
    }

    public void renameDirectory(Location source, Location target) throws IOException {
        this.fileSystem(source).renameDirectory(source, target);
    }

    private TrinoFileSystem fileSystem(Location location) {
        return this.createFileSystem(this.determineFactory(location));
    }

    private TrinoFileSystemFactory determineFactory(Location location) {
        return location.scheme().map(this.factories::get).or(() -> this.hdfsFactory).orElseThrow(() -> new IllegalArgumentException("No factory for location: " + location));
    }

    private TrinoFileSystem createFileSystem(TrinoFileSystemFactory factory) {
        return this.session.map(arg_0 -> ((TrinoFileSystemFactory)factory).create(arg_0)).orElseGet(() -> factory.create(this.identity.orElseThrow()));
    }
}

