/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.ConditionalModule;
import io.airlift.event.client.EventModule;
import io.airlift.json.JsonModule;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.manager.FileSystemModule;
import io.trino.hdfs.HdfsModule;
import io.trino.hdfs.authentication.HdfsAuthenticationModule;
import io.trino.hdfs.azure.HiveAzureModule;
import io.trino.hdfs.cos.HiveCosModule;
import io.trino.hdfs.gcs.HiveGcsModule;
import io.trino.hdfs.rubix.RubixEnabledConfig;
import io.trino.hdfs.rubix.RubixModule;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.base.CatalogNameModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorAccessControl;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSinkProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorPageSourceProvider;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeEventListener;
import io.trino.plugin.base.classloader.ClassLoaderSafeNodePartitioningProvider;
import io.trino.plugin.base.jmx.ConnectorObjectNameGeneratorModule;
import io.trino.plugin.base.jmx.MBeanServerModule;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.hive.HiveAnalyzeProperties;
import io.trino.plugin.hive.HiveColumnProperties;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveConnector;
import io.trino.plugin.hive.HiveMaterializedViewPropertiesProvider;
import io.trino.plugin.hive.HiveModule;
import io.trino.plugin.hive.HiveSchemaProperties;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveTableProperties;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.SystemTableProvider;
import io.trino.plugin.hive.aws.athena.PartitionProjectionModule;
import io.trino.plugin.hive.fs.CachingDirectoryListerModule;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.metastore.HiveMetastore;
import io.trino.plugin.hive.metastore.HiveMetastoreModule;
import io.trino.plugin.hive.procedure.HiveProcedureModule;
import io.trino.plugin.hive.security.HiveSecurityModule;
import io.trino.plugin.hive.security.SystemTableAwareAccessControl;
import io.trino.spi.NodeManager;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.procedure.Procedure;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.MBeanModule;

public final class InternalHiveConnectorFactory {
    private InternalHiveConnectorFactory() {
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module) {
        return InternalHiveConnectorFactory.createConnector(catalogName, config, context, module, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Connector createConnector(String catalogName, Map<String, String> config, ConnectorContext context, Module module, Optional<HiveMetastore> metastore, Optional<TrinoFileSystemFactory> fileSystemFactory, Optional<OpenTelemetry> openTelemetry, Optional<DirectoryLister> directoryLister) {
        Objects.requireNonNull(config, "config is null");
        ClassLoader classLoader = InternalHiveConnectorFactory.class.getClassLoader();
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new CatalogNameModule(catalogName), new EventModule(), new MBeanModule(), new ConnectorObjectNameGeneratorModule("io.trino.plugin.hive", "trino.plugin.hive"), new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new HiveModule(), new PartitionProjectionModule(), new CachingDirectoryListerModule(directoryLister), new HdfsModule(), new HiveGcsModule(), new HiveAzureModule(), new HiveCosModule(), ConditionalModule.conditionalModule(RubixEnabledConfig.class, RubixEnabledConfig::isCacheEnabled, (Module)new RubixModule()), new HiveMetastoreModule(metastore), new HiveSecurityModule(), new HdfsAuthenticationModule(), fileSystemFactory.map(factory -> binder -> binder.bind(TrinoFileSystemFactory.class).toInstance(factory)).orElseGet(FileSystemModule::new), new HiveProcedureModule(), new MBeanServerModule(), binder -> {
                binder.bind(OpenTelemetry.class).toInstance((Object)openTelemetry.orElse(context.getOpenTelemetry()));
                binder.bind(Tracer.class).toInstance((Object)context.getTracer());
                binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(context.getNodeManager().getCurrentNode().getVersion()));
                binder.bind(NodeManager.class).toInstance((Object)context.getNodeManager());
                binder.bind(VersionEmbedder.class).toInstance((Object)context.getVersionEmbedder());
                binder.bind(MetadataProvider.class).toInstance((Object)context.getMetadataProvider());
                binder.bind(PageIndexerFactory.class).toInstance((Object)context.getPageIndexerFactory());
                binder.bind(PageSorter.class).toInstance((Object)context.getPageSorter());
                binder.bind(CatalogName.class).toInstance((Object)new CatalogName(catalogName));
            }, binder -> Multibinder.newSetBinder((Binder)binder, EventListener.class), binder -> InternalHiveConnectorFactory.bindSessionPropertiesProvider(binder, HiveSessionProperties.class), module});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).initialize();
            LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
            HiveTransactionManager transactionManager = (HiveTransactionManager)injector.getInstance(HiveTransactionManager.class);
            ConnectorSplitManager splitManager = (ConnectorSplitManager)injector.getInstance(ConnectorSplitManager.class);
            ConnectorPageSourceProvider connectorPageSource = (ConnectorPageSourceProvider)injector.getInstance(ConnectorPageSourceProvider.class);
            ConnectorPageSinkProvider pageSinkProvider = (ConnectorPageSinkProvider)injector.getInstance(ConnectorPageSinkProvider.class);
            ConnectorNodePartitioningProvider connectorDistributionProvider = (ConnectorNodePartitioningProvider)injector.getInstance(ConnectorNodePartitioningProvider.class);
            Set sessionPropertiesProviders = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SessionPropertiesProvider>>(){}));
            HiveTableProperties hiveTableProperties = (HiveTableProperties)injector.getInstance(HiveTableProperties.class);
            HiveColumnProperties hiveColumnProperties = (HiveColumnProperties)injector.getInstance(HiveColumnProperties.class);
            HiveAnalyzeProperties hiveAnalyzeProperties = (HiveAnalyzeProperties)injector.getInstance(HiveAnalyzeProperties.class);
            HiveMaterializedViewPropertiesProvider hiveMaterializedViewPropertiesProvider = (HiveMaterializedViewPropertiesProvider)injector.getInstance(HiveMaterializedViewPropertiesProvider.class);
            Set procedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Procedure>>(){}));
            Set tableProcedures = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<TableProcedureMetadata>>(){}));
            Set eventListeners = (Set)((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<EventListener>>(){}))).stream().map(listener -> new ClassLoaderSafeEventListener(listener, classLoader)).collect(ImmutableSet.toImmutableSet());
            Set systemTableProviders = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<SystemTableProvider>>(){}));
            Optional<ConnectorAccessControl> hiveAccessControl = ((Optional)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Optional<ConnectorAccessControl>>(){}))).map(accessControl -> new SystemTableAwareAccessControl((ConnectorAccessControl)accessControl, systemTableProviders)).map(accessControl -> new ClassLoaderSafeConnectorAccessControl((ConnectorAccessControl)accessControl, classLoader));
            HiveConnector hiveConnector = new HiveConnector(injector, lifeCycleManager, transactionManager, (ConnectorSplitManager)new ClassLoaderSafeConnectorSplitManager(splitManager, classLoader), (ConnectorPageSourceProvider)new ClassLoaderSafeConnectorPageSourceProvider(connectorPageSource, classLoader), (ConnectorPageSinkProvider)new ClassLoaderSafeConnectorPageSinkProvider(pageSinkProvider, classLoader), (ConnectorNodePartitioningProvider)new ClassLoaderSafeNodePartitioningProvider(connectorDistributionProvider, classLoader), procedures, tableProcedures, eventListeners, sessionPropertiesProviders, HiveSchemaProperties.SCHEMA_PROPERTIES, hiveTableProperties.getTableProperties(), hiveColumnProperties.getColumnProperties(), hiveAnalyzeProperties.getAnalyzeProperties(), hiveMaterializedViewPropertiesProvider.getMaterializedViewProperties(), hiveAccessControl, ((HiveConfig)injector.getInstance(HiveConfig.class)).isSingleStatementWritesOnly(), classLoader);
            return hiveConnector;
        }
    }

    public static void bindSessionPropertiesProvider(Binder binder, Class<? extends SessionPropertiesProvider> type) {
        Multibinder.newSetBinder((Binder)binder, SessionPropertiesProvider.class).addBinding().to(type).in(Scopes.SINGLETON);
    }
}

