/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3select;

import com.google.common.annotations.VisibleForTesting;
import io.trino.plugin.hive.GenericHiveRecordCursor;
import io.trino.plugin.hive.HiveColumnHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordReader;

class S3SelectRecordCursor<K, V extends Writable>
extends GenericHiveRecordCursor<K, V> {
    public S3SelectRecordCursor(Configuration configuration, Path path, RecordReader<K, V> recordReader, long totalBytes, Properties splitSchema, List<HiveColumnHandle> columns) {
        super(configuration, path, recordReader, totalBytes, S3SelectRecordCursor.updateSplitSchema(splitSchema, columns), columns);
    }

    @VisibleForTesting
    static Properties updateSplitSchema(Properties splitSchema, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(splitSchema, "splitSchema is null");
        Objects.requireNonNull(columns, "columns is null");
        Properties updatedSchema = new Properties();
        updatedSchema.putAll((Map<?, ?>)splitSchema);
        updatedSchema.setProperty("columns", S3SelectRecordCursor.buildColumns(columns));
        updatedSchema.setProperty("columns.types", S3SelectRecordCursor.buildColumnTypes(columns));
        return updatedSchema;
    }

    private static String buildColumns(List<HiveColumnHandle> columns) {
        if (columns == null || columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(HiveColumnHandle::getName).collect(Collectors.joining(","));
    }

    private static String buildColumnTypes(List<HiveColumnHandle> columns) {
        if (columns == null || columns.isEmpty()) {
            return "";
        }
        return columns.stream().map(column -> column.getHiveType().getTypeInfo().getTypeName()).collect(Collectors.joining(","));
    }
}

