/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.DataFileInfo;
import io.trino.plugin.deltalake.DeltaLakeCdfPageSink;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeInsertTableHandle;
import io.trino.plugin.deltalake.DeltaLakeMergeResult;
import io.trino.plugin.deltalake.DeltaLakeMergeSink;
import io.trino.plugin.deltalake.DeltaLakeMergeTableHandle;
import io.trino.plugin.deltalake.DeltaLakeOutputTableHandle;
import io.trino.plugin.deltalake.DeltaLakePageSink;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemaMapping;
import io.trino.plugin.deltalake.DeltaLakeParquetSchemas;
import io.trino.plugin.deltalake.DeltaLakeWriterStats;
import io.trino.plugin.deltalake.procedure.DeltaLakeTableExecuteHandle;
import io.trino.plugin.deltalake.procedure.DeltaTableOptimizeHandle;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.MetadataEntry;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableExecuteHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.joda.time.DateTimeZone;

public class DeltaLakePageSinkProvider
implements ConnectorPageSinkProvider {
    private final PageIndexerFactory pageIndexerFactory;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final JsonCodec<DataFileInfo> dataFileInfoCodec;
    private final JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec;
    private final DeltaLakeWriterStats stats;
    private final int maxPartitionsPerWriter;
    private final DateTimeZone parquetDateTimeZone;
    private final TypeManager typeManager;
    private final String trinoVersion;
    private final int domainCompactionThreshold;

    @Inject
    public DeltaLakePageSinkProvider(PageIndexerFactory pageIndexerFactory, TrinoFileSystemFactory fileSystemFactory, JsonCodec<DataFileInfo> dataFileInfoCodec, JsonCodec<DeltaLakeMergeResult> mergeResultJsonCodec, DeltaLakeWriterStats stats, DeltaLakeConfig deltaLakeConfig, TypeManager typeManager, NodeVersion nodeVersion) {
        this.pageIndexerFactory = pageIndexerFactory;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.dataFileInfoCodec = dataFileInfoCodec;
        this.mergeResultJsonCodec = Objects.requireNonNull(mergeResultJsonCodec, "mergeResultJsonCodec is null");
        this.stats = stats;
        this.maxPartitionsPerWriter = deltaLakeConfig.getMaxPartitionsPerWriter();
        this.parquetDateTimeZone = deltaLakeConfig.getParquetDateTimeZone();
        this.domainCompactionThreshold = deltaLakeConfig.getDomainCompactionThreshold();
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.trinoVersion = nodeVersion.toString();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeOutputTableHandle tableHandle = (DeltaLakeOutputTableHandle)outputTableHandle;
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(tableHandle.getSchemaString(), this.typeManager, tableHandle.getColumnMappingMode(), tableHandle.getPartitionedBy());
        return new DeltaLakePageSink(this.typeManager.getTypeOperators(), tableHandle.getInputColumns(), tableHandle.getPartitionedBy(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)tableHandle.getLocation()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeInsertTableHandle tableHandle = (DeltaLakeInsertTableHandle)insertTableHandle;
        MetadataEntry metadataEntry = tableHandle.getMetadataEntry();
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry, this.typeManager);
        return new DeltaLakePageSink(this.typeManager.getTypeOperators(), tableHandle.getInputColumns(), tableHandle.getMetadataEntry().getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)tableHandle.getLocation()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorTableExecuteHandle tableExecuteHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeTableExecuteHandle executeHandle = (DeltaLakeTableExecuteHandle)tableExecuteHandle;
        switch (executeHandle.getProcedureId()) {
            case OPTIMIZE: {
                DeltaTableOptimizeHandle optimizeHandle = (DeltaTableOptimizeHandle)executeHandle.getProcedureHandle();
                DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(optimizeHandle.getMetadataEntry(), this.typeManager);
                return new DeltaLakePageSink(this.typeManager.getTypeOperators(), optimizeHandle.getTableColumns(), optimizeHandle.getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, Location.of((String)executeHandle.getTableLocation()), session, this.stats, this.trinoVersion, parquetSchemaMapping);
            }
        }
        throw new IllegalArgumentException("Unknown procedure: " + executeHandle.getProcedureId());
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        DeltaLakeMergeTableHandle merge = (DeltaLakeMergeTableHandle)mergeHandle;
        DeltaLakeInsertTableHandle tableHandle = merge.getInsertTableHandle();
        ConnectorPageSink pageSink = this.createPageSink(transactionHandle, session, tableHandle, pageSinkId);
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(tableHandle.getMetadataEntry(), this.typeManager);
        return new DeltaLakeMergeSink(this.typeManager.getTypeOperators(), this.fileSystemFactory, session, this.parquetDateTimeZone, this.trinoVersion, this.dataFileInfoCodec, this.mergeResultJsonCodec, this.stats, Location.of((String)tableHandle.getLocation()), pageSink, tableHandle.getInputColumns(), this.domainCompactionThreshold, () -> this.createCdfPageSink(merge, session), DeltaLakeSchemaSupport.changeDataFeedEnabled(tableHandle.getMetadataEntry()), parquetSchemaMapping);
    }

    private DeltaLakeCdfPageSink createCdfPageSink(DeltaLakeMergeTableHandle mergeTableHandle, ConnectorSession session) {
        MetadataEntry metadataEntry = mergeTableHandle.getTableHandle().getMetadataEntry();
        Set partitionKeys = (Set)mergeTableHandle.getTableHandle().getMetadataEntry().getOriginalPartitionColumns().stream().collect(ImmutableSet.toImmutableSet());
        List tableColumns = (List)DeltaLakeSchemaSupport.extractSchema(metadataEntry, this.typeManager).stream().map(metadata -> new DeltaLakeColumnHandle(metadata.getName(), metadata.getType(), metadata.getFieldId(), metadata.getPhysicalName(), metadata.getPhysicalColumnType(), partitionKeys.contains(metadata.getName()) ? DeltaLakeColumnType.PARTITION_KEY : DeltaLakeColumnType.REGULAR, Optional.empty())).collect(ImmutableList.toImmutableList());
        ImmutableList allColumns = ImmutableList.builder().addAll((Iterable)tableColumns).add((Object)new DeltaLakeColumnHandle("_change_type", (Type)VarcharType.VARCHAR, OptionalInt.empty(), "_change_type", (Type)VarcharType.VARCHAR, DeltaLakeColumnType.REGULAR, Optional.empty())).build();
        Location tableLocation = Location.of((String)mergeTableHandle.getTableHandle().getLocation());
        DeltaLakeParquetSchemaMapping parquetSchemaMapping = DeltaLakeParquetSchemas.createParquetSchemaMapping(metadataEntry, this.typeManager, true);
        return new DeltaLakeCdfPageSink(this.typeManager.getTypeOperators(), (List<DeltaLakeColumnHandle>)allColumns, metadataEntry.getOriginalPartitionColumns(), this.pageIndexerFactory, this.fileSystemFactory, this.maxPartitionsPerWriter, this.dataFileInfoCodec, tableLocation, tableLocation.appendPath("_change_data"), session, this.stats, this.trinoVersion, parquetSchemaMapping);
    }
}

