/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorSplitSource;
import io.trino.plugin.deltalake.AnalyzeHandle;
import io.trino.plugin.deltalake.DeltaLakeAnalyzeProperties;
import io.trino.plugin.deltalake.DeltaLakeColumnHandle;
import io.trino.plugin.deltalake.DeltaLakeColumnMetadata;
import io.trino.plugin.deltalake.DeltaLakeColumnType;
import io.trino.plugin.deltalake.DeltaLakeConfig;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeSessionProperties;
import io.trino.plugin.deltalake.DeltaLakeSplit;
import io.trino.plugin.deltalake.DeltaLakeSplitSource;
import io.trino.plugin.deltalake.DeltaLakeTableHandle;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesSplitSource;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesTableFunctionHandle;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeSchemaSupport;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogParser;
import io.trino.plugin.deltalake.transactionlog.statistics.DeltaLakeFileStatistics;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DeltaLakeSplitManager
implements ConnectorSplitManager {
    private final TypeManager typeManager;
    private final TransactionLogAccess transactionLogAccess;
    private final ExecutorService executor;
    private final int maxInitialSplits;
    private final int maxSplitsPerSecond;
    private final int maxOutstandingSplits;
    private final double minimumAssignedSplitWeight;
    private final TrinoFileSystemFactory fileSystemFactory;

    @Inject
    public DeltaLakeSplitManager(TypeManager typeManager, TransactionLogAccess transactionLogAccess, ExecutorService executor, DeltaLakeConfig config, TrinoFileSystemFactory fileSystemFactory) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.maxInitialSplits = config.getMaxInitialSplits();
        this.maxSplitsPerSecond = config.getMaxSplitsPerSecond();
        this.maxOutstandingSplits = config.getMaxOutstandingSplits();
        this.minimumAssignedSplitWeight = config.getMinimumAssignedSplitWeight();
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        DeltaLakeTableHandle deltaLakeTableHandle = (DeltaLakeTableHandle)handle;
        if (deltaLakeTableHandle.getEnforcedPartitionConstraint().isNone() || deltaLakeTableHandle.getNonPartitionConstraint().isNone()) {
            if (deltaLakeTableHandle.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return FixedSplitSource.emptySplitSource();
        }
        DeltaLakeSplitSource splitSource = new DeltaLakeSplitSource(deltaLakeTableHandle.getSchemaTableName(), this.getSplits(deltaLakeTableHandle, session, deltaLakeTableHandle.getMaxScannedFileSize(), dynamicFilter.getColumnsCovered(), constraint), this.executor, this.maxSplitsPerSecond, this.maxOutstandingSplits, dynamicFilter, DeltaLakeSessionProperties.getDynamicFilteringWaitTimeout(session), deltaLakeTableHandle.isRecordScannedFiles());
        return new ClassLoaderSafeConnectorSplitSource((ConnectorSplitSource)splitSource, DeltaLakeSplitManager.class.getClassLoader());
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableFunctionHandle function) {
        if (function instanceof TableChangesTableFunctionHandle) {
            TableChangesTableFunctionHandle tableFunctionHandle = (TableChangesTableFunctionHandle)function;
            return new TableChangesSplitSource(session, this.fileSystemFactory, tableFunctionHandle);
        }
        throw new UnsupportedOperationException("Unrecognized function: " + function);
    }

    private Stream<DeltaLakeSplit> getSplits(DeltaLakeTableHandle tableHandle, ConnectorSession session, Optional<DataSize> maxScannedFileSize, Set<ColumnHandle> columnsCoveredByDynamicFilter, Constraint constraint) {
        TableSnapshot tableSnapshot;
        try {
            tableSnapshot = this.transactionLogAccess.loadSnapshot(tableHandle.getSchemaTableName(), tableHandle.getLocation(), session);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        List<AddFileEntry> validDataFiles = this.transactionLogAccess.getActiveFiles(tableSnapshot, session);
        TupleDomain<DeltaLakeColumnHandle> enforcedPartitionConstraint = tableHandle.getEnforcedPartitionConstraint();
        TupleDomain<DeltaLakeColumnHandle> nonPartitionConstraint = tableHandle.getNonPartitionConstraint();
        Domain pathDomain = DeltaLakeSplitManager.getPathDomain(nonPartitionConstraint);
        boolean splittable = tableHandle.getWriteType().isEmpty() && DeltaLakeSplitManager.mayAnyDataColumnProjected(tableHandle);
        AtomicInteger remainingInitialSplits = new AtomicInteger(this.maxInitialSplits);
        Optional filesModifiedAfter = tableHandle.getAnalyzeHandle().flatMap(AnalyzeHandle::getFilesModifiedAfter);
        Optional<Long> maxScannedFileSizeInBytes = maxScannedFileSize.map(DataSize::toBytes);
        Set predicatedColumnNames = (Set)Stream.concat(((Map)nonPartitionConstraint.getDomains().orElseThrow()).keySet().stream(), columnsCoveredByDynamicFilter.stream().map(DeltaLakeColumnHandle.class::cast)).map(DeltaLakeColumnHandle::getBaseColumnName).collect(ImmutableSet.toImmutableSet());
        List<DeltaLakeColumnMetadata> schema = DeltaLakeSchemaSupport.extractSchema(tableHandle.getMetadataEntry(), this.typeManager);
        List predicatedColumns = (List)schema.stream().filter(column -> predicatedColumnNames.contains(column.getName())).collect(ImmutableList.toImmutableList());
        return validDataFiles.stream().flatMap(addAction -> {
            if (tableHandle.getAnalyzeHandle().isPresent() && tableHandle.getAnalyzeHandle().get().getAnalyzeMode() != DeltaLakeAnalyzeProperties.AnalyzeMode.FULL_REFRESH && !addAction.isDataChange()) {
                return Stream.empty();
            }
            String splitPath = DeltaLakeSplitManager.buildSplitPath(Location.of((String)tableHandle.getLocation()), addAction).toString();
            if (!DeltaLakeSplitManager.pathMatchesPredicate(pathDomain, splitPath)) {
                return Stream.empty();
            }
            if (filesModifiedAfter.isPresent() && addAction.getModificationTime() <= ((Instant)filesModifiedAfter.get()).toEpochMilli()) {
                return Stream.empty();
            }
            if (maxScannedFileSizeInBytes.isPresent() && addAction.getSize() > (Long)maxScannedFileSizeInBytes.get()) {
                return Stream.empty();
            }
            Map enforcedDomains = (Map)enforcedPartitionConstraint.getDomains().orElseThrow();
            if (!DeltaLakeSplitManager.partitionMatchesPredicate(addAction.getCanonicalPartitionValues(), enforcedDomains)) {
                return Stream.empty();
            }
            TupleDomain<DeltaLakeColumnHandle> statisticsPredicate = DeltaLakeMetadata.createStatisticsPredicate(addAction, predicatedColumns, tableHandle.getMetadataEntry().getLowercasePartitionColumns());
            if (!nonPartitionConstraint.overlaps(statisticsPredicate)) {
                return Stream.empty();
            }
            if (constraint.predicate().isPresent()) {
                Map<String, Optional<String>> partitionValues = addAction.getCanonicalPartitionValues();
                Map deserializedValues = (Map)((Set)constraint.getPredicateColumns().orElseThrow()).stream().map(DeltaLakeColumnHandle.class::cast).filter(column -> column.isBaseColumn() && partitionValues.containsKey(column.getBaseColumnName())).collect(ImmutableMap.toImmutableMap(Function.identity(), column -> new NullableValue(column.getBaseType(), TransactionLogParser.deserializePartitionValue(column, (Optional)partitionValues.get(column.getBaseColumnName())))));
                if (!((Predicate)constraint.predicate().get()).test(deserializedValues)) {
                    return Stream.empty();
                }
            }
            return this.splitsForFile(session, (AddFileEntry)addAction, splitPath, addAction.getCanonicalPartitionValues(), statisticsPredicate, splittable, remainingInitialSplits).stream();
        });
    }

    private static boolean mayAnyDataColumnProjected(DeltaLakeTableHandle tableHandle) {
        if (tableHandle.getProjectedColumns().isEmpty()) {
            return true;
        }
        return tableHandle.getProjectedColumns().get().stream().map(DeltaLakeColumnHandle::getColumnType).anyMatch(DeltaLakeColumnType.REGULAR::equals);
    }

    public static boolean partitionMatchesPredicate(Map<String, Optional<String>> partitionKeys, Map<DeltaLakeColumnHandle, Domain> domains) {
        for (Map.Entry<DeltaLakeColumnHandle, Domain> enforcedDomainsEntry : domains.entrySet()) {
            DeltaLakeColumnHandle partitionColumn = enforcedDomainsEntry.getKey();
            Domain partitionDomain = enforcedDomainsEntry.getValue();
            if (partitionDomain.includesNullableValue(TransactionLogParser.deserializePartitionValue(partitionColumn, partitionKeys.get(partitionColumn.getBasePhysicalColumnName())))) continue;
            return false;
        }
        return true;
    }

    private static Domain getPathDomain(TupleDomain<DeltaLakeColumnHandle> effectivePredicate) {
        return effectivePredicate.getDomains().flatMap(domains -> Optional.ofNullable((Domain)domains.get(DeltaLakeColumnHandle.pathColumnHandle()))).orElseGet(() -> Domain.all((Type)DeltaLakeColumnHandle.pathColumnHandle().getBaseType()));
    }

    private static boolean pathMatchesPredicate(Domain pathDomain, String path) {
        return pathDomain.includesNullableValue((Object)Slices.utf8Slice((String)path));
    }

    private List<DeltaLakeSplit> splitsForFile(ConnectorSession session, AddFileEntry addFileEntry, String splitPath, Map<String, Optional<String>> partitionKeys, TupleDomain<DeltaLakeColumnHandle> statisticsPredicate, boolean splittable, AtomicInteger remainingInitialSplits) {
        long splitSize;
        long fileSize = addFileEntry.getSize();
        if (!splittable) {
            return ImmutableList.of((Object)new DeltaLakeSplit(splitPath, 0L, fileSize, fileSize, addFileEntry.getStats().flatMap(DeltaLakeFileStatistics::getNumRecords), addFileEntry.getModificationTime(), SplitWeight.standard(), statisticsPredicate, partitionKeys));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        for (long currentOffset = 0L; currentOffset < fileSize; currentOffset += splitSize) {
            long maxSplitSize = remainingInitialSplits.get() > 0 && remainingInitialSplits.getAndDecrement() > 0 ? DeltaLakeSessionProperties.getMaxInitialSplitSize(session).toBytes() : DeltaLakeSessionProperties.getMaxSplitSize(session).toBytes();
            splitSize = Math.min(maxSplitSize, fileSize - currentOffset);
            splits.add((Object)new DeltaLakeSplit(splitPath, currentOffset, splitSize, fileSize, Optional.empty(), addFileEntry.getModificationTime(), SplitWeight.fromProportion((double)Math.min(Math.max((double)splitSize / (double)maxSplitSize, this.minimumAssignedSplitWeight), 1.0)), statisticsPredicate, partitionKeys));
        }
        return splits.build();
    }

    private static Location buildSplitPath(Location tableLocation, AddFileEntry addAction) {
        URI uri = URI.create(addAction.getPath());
        String path = uri.getPath();
        Optional scheme = tableLocation.scheme();
        if (scheme.isPresent() && (((String)scheme.get()).equals("abfs") || ((String)scheme.get()).equals("abfss"))) {
            path = URLDecoder.decode(path.replace("+", "%2B"), StandardCharsets.UTF_8);
        }
        return tableLocation.appendPath(path);
    }
}

