/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.functions.tablechanges;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.filesystem.Locations;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesFileType;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesSplit;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesTableFunctionHandle;
import io.trino.plugin.deltalake.transactionlog.AddFileEntry;
import io.trino.plugin.deltalake.transactionlog.CdcEntry;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public class TableChangesSplitSource
implements ConnectorSplitSource {
    private final String tableLocation;
    private final Iterator<ConnectorSplit> splits;

    public TableChangesSplitSource(ConnectorSession session, TrinoFileSystemFactory fileSystemFactory, TableChangesTableFunctionHandle functionHandle) {
        this.tableLocation = functionHandle.tableLocation();
        this.splits = this.prepareSplits(functionHandle.firstReadVersion(), functionHandle.tableReadVersion(), TransactionLogUtil.getTransactionLogDir(functionHandle.tableLocation()), fileSystemFactory.create(session)).iterator();
    }

    private Stream<ConnectorSplit> prepareSplits(long currentVersion, long tableReadVersion, String transactionLogDir, TrinoFileSystem fileSystem) {
        return LongStream.range(currentVersion, tableReadVersion + 1L).boxed().flatMap(version -> {
            try {
                List<DeltaLakeTransactionLogEntry> entries = TransactionLogTail.getEntriesFromJson(version, transactionLogDir, fileSystem).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "Delta Lake log entries are missing for version " + version));
                if (entries.isEmpty()) {
                    return ImmutableList.of().stream();
                }
                List commitInfoEntries = (List)entries.stream().map(DeltaLakeTransactionLogEntry::getCommitInfo).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
                if (commitInfoEntries.size() != 1) {
                    throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_BAD_DATA, "There should be exactly 1 commitInfo present in a metadata file");
                }
                CommitInfoEntry commitInfo = (CommitInfoEntry)Iterables.getOnlyElement((Iterable)commitInfoEntries);
                ArrayList<TableChangesSplit> splits = new ArrayList<TableChangesSplit>();
                boolean containsCdcEntry = false;
                boolean containsRemoveEntry = false;
                for (DeltaLakeTransactionLogEntry entry : entries) {
                    CdcEntry cdcEntry = entry.getCDC();
                    if (cdcEntry != null) {
                        containsCdcEntry = true;
                        splits.add(this.mapToDeltaLakeTableChangesSplit(commitInfo, TableChangesFileType.CDF_FILE, cdcEntry.getSize(), cdcEntry.getPath(), cdcEntry.getCanonicalPartitionValues()));
                    }
                    if (entry.getRemove() == null || !entry.getRemove().isDataChange()) continue;
                    containsRemoveEntry = true;
                }
                if (containsRemoveEntry && !containsCdcEntry) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Change Data Feed is not enabled at version %d. Version contains 'remove' entries without 'cdc' entries", version));
                }
                if (!containsRemoveEntry) {
                    for (DeltaLakeTransactionLogEntry entry : entries) {
                        if (entry.getAdd() == null || !entry.getAdd().isDataChange()) continue;
                        AddFileEntry addEntry = entry.getAdd();
                        splits.add(this.mapToDeltaLakeTableChangesSplit(commitInfo, TableChangesFileType.DATA_FILE, addEntry.getSize(), addEntry.getPath(), addEntry.getCanonicalPartitionValues()));
                    }
                }
                return splits.stream();
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Failed to access table metadata", (Throwable)e);
            }
        });
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < maxSize && this.splits.hasNext(); ++i) {
            result.add((Object)this.splits.next());
        }
        return CompletableFuture.completedFuture(new ConnectorSplitSource.ConnectorSplitBatch((List)result.build(), this.isFinished()));
    }

    private TableChangesSplit mapToDeltaLakeTableChangesSplit(CommitInfoEntry commitInfoEntry, TableChangesFileType source, long length, String entryPath, Map<String, Optional<String>> canonicalPartitionValues) {
        String path = Locations.appendPath((String)this.tableLocation, (String)entryPath);
        return new TableChangesSplit(path, length, canonicalPartitionValues, commitInfoEntry.getTimestamp(), source, commitInfoEntry.getVersion());
    }

    public void close() {
    }

    public boolean isFinished() {
        return !this.splits.hasNext();
    }
}

