/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;

public class CachingExtendedStatisticsAccess
implements ExtendedStatisticsAccess {
    private static final Duration CACHE_EXPIRATION = Duration.of(1L, ChronoUnit.HOURS);
    private static final long CACHE_MAX_SIZE = 1000L;
    private final ExtendedStatisticsAccess delegate;
    private final Cache<CacheKey, Optional<ExtendedStatistics>> cache = EvictableCacheBuilder.newBuilder().expireAfterWrite(CACHE_EXPIRATION).maximumSize(1000L).build();

    @Inject
    public CachingExtendedStatisticsAccess(@ForCachingExtendedStatisticsAccess ExtendedStatisticsAccess delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    @Override
    public Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation) {
        try {
            return (Optional)CacheUtils.uncheckedCacheGet(this.cache, (Object)new CacheKey(schemaTableName, tableLocation), () -> this.delegate.readExtendedStatistics(session, schemaTableName, tableLocation));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Error reading statistics from cache", e.getCause());
        }
    }

    @Override
    public void updateExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation, ExtendedStatistics statistics) {
        this.delegate.updateExtendedStatistics(session, schemaTableName, tableLocation, statistics);
        this.cache.invalidate((Object)new CacheKey(schemaTableName, tableLocation));
    }

    @Override
    public void deleteExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation) {
        this.delegate.deleteExtendedStatistics(session, schemaTableName, tableLocation);
        this.cache.invalidate((Object)new CacheKey(schemaTableName, tableLocation));
    }

    public void invalidateCache() {
        this.cache.invalidateAll();
    }

    public void invalidateCache(SchemaTableName schemaTableName, Optional<String> tableLocation) {
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        tableLocation.ifPresent(location -> CacheUtils.invalidateAllIf(this.cache, cacheKey -> cacheKey.location().equals(location)));
        CacheUtils.invalidateAllIf(this.cache, cacheKey -> cacheKey.tableName().equals((Object)schemaTableName));
    }

    private record CacheKey(SchemaTableName tableName, String location) {
        CacheKey {
            Objects.requireNonNull(tableName, "tableName is null");
            Objects.requireNonNull(location, "location is null");
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD})
    @BindingAnnotation
    public static @interface ForCachingExtendedStatisticsAccess {
    }
}

