/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import io.trino.hive.$internal.com.google.common.cache.Cache;
import io.trino.hive.$internal.com.google.common.cache.CacheBuilder;
import io.trino.hive.$internal.com.google.common.cache.Weigher;
import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import io.trino.hive.orc.impl.OrcTail;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.ReaderImpl;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;

class LocalCache
implements OrcInputFormat.FooterCache {
    private static final Logger LOG = LoggerFactory.getLogger(LocalCache.class);
    private static final int DEFAULT_CACHE_INITIAL_CAPACITY = 1024;
    private final Cache<Path, TailAndFileData> cache;

    LocalCache(int numThreads, long cacheMemSize, boolean useSoftRef) {
        CacheBuilder<Path, TailAndFileData> builder = CacheBuilder.newBuilder().initialCapacity(1024).concurrencyLevel(numThreads).maximumWeight(cacheMemSize).weigher(new Weigher<Path, TailAndFileData>(){

            @Override
            public int weigh(Path key, TailAndFileData value) {
                return value.getMemoryUsage();
            }
        });
        if (useSoftRef) {
            builder = builder.softValues();
        }
        this.cache = builder.build();
    }

    public void clear() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    public void put(Path path, OrcTail tail) {
        ByteBuffer bb = tail.getSerializedTail();
        if (bb.capacity() != bb.remaining()) {
            throw new RuntimeException("Bytebuffer allocated for path: " + path + " has remaining: " + bb.remaining() + " != capacity: " + bb.capacity());
        }
        this.cache.put(path, new TailAndFileData(tail.getFileTail().getFileLength(), tail.getFileModificationTime(), bb.duplicate()));
    }

    @Override
    public void getAndValidate(List<HadoopShims.HdfsFileStatusWithId> files, boolean isOriginal, OrcTail[] result, ByteBuffer[] ppdResult) throws IOException, HiveException {
        assert (result.length == files.size());
        int i = -1;
        for (HadoopShims.HdfsFileStatusWithId fileWithId : files) {
            ++i;
            FileStatus file = fileWithId.getFileStatus();
            Path path = file.getPath();
            TailAndFileData tfd = this.cache.getIfPresent(path);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Serialized tail " + (tfd == null ? "not " : "") + "cached for path: " + path);
            }
            if (tfd == null) continue;
            if (file.getLen() == tfd.fileLength && file.getModificationTime() == tfd.fileModTime) {
                result[i] = ReaderImpl.extractFileTail(tfd.bb.duplicate(), tfd.fileLength, tfd.fileModTime);
                continue;
            }
            this.cache.invalidate(path);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Meta-Info for : " + path + " changed. CachedModificationTime: " + tfd.fileModTime + ", CurrentModificationTime: " + file.getModificationTime() + ", CachedLength: " + tfd.fileLength + ", CurrentLength: " + file.getLen());
        }
    }

    @Override
    public boolean hasPpd() {
        return false;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }

    @Override
    public void put(OrcInputFormat.FooterCacheKey cacheKey, OrcTail orcTail) throws IOException {
        this.put(cacheKey.getPath(), orcTail);
    }

    private static final class TailAndFileData {
        public ByteBuffer bb;
        public long fileLength;
        public long fileModTime;

        public TailAndFileData(long fileLength, long fileModificationTime, ByteBuffer bb) {
            this.fileLength = fileLength;
            this.fileModTime = fileModificationTime;
            this.bb = bb;
        }

        public int getMemoryUsage() {
            return this.bb.capacity() + 100;
        }
    }
}

