/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.DQResultsPublishingOptions;
import com.amazonaws.services.glue.model.DQStopJobOnFailureOptions;
import com.amazonaws.services.glue.model.transform.EvaluateDataQualityMultiFrameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluateDataQualityMultiFrame
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private Map<String, String> additionalDataSources;
    private String ruleset;
    private DQResultsPublishingOptions publishingOptions;
    private Map<String, String> additionalOptions;
    private DQStopJobOnFailureOptions stopJobOnFailureOptions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EvaluateDataQualityMultiFrame withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public EvaluateDataQualityMultiFrame withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public EvaluateDataQualityMultiFrame withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public Map<String, String> getAdditionalDataSources() {
        return this.additionalDataSources;
    }

    public void setAdditionalDataSources(Map<String, String> additionalDataSources) {
        this.additionalDataSources = additionalDataSources;
    }

    public EvaluateDataQualityMultiFrame withAdditionalDataSources(Map<String, String> additionalDataSources) {
        this.setAdditionalDataSources(additionalDataSources);
        return this;
    }

    public EvaluateDataQualityMultiFrame addAdditionalDataSourcesEntry(String key, String value) {
        if (null == this.additionalDataSources) {
            this.additionalDataSources = new HashMap<String, String>();
        }
        if (this.additionalDataSources.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalDataSources.put(key, value);
        return this;
    }

    public EvaluateDataQualityMultiFrame clearAdditionalDataSourcesEntries() {
        this.additionalDataSources = null;
        return this;
    }

    public void setRuleset(String ruleset) {
        this.ruleset = ruleset;
    }

    public String getRuleset() {
        return this.ruleset;
    }

    public EvaluateDataQualityMultiFrame withRuleset(String ruleset) {
        this.setRuleset(ruleset);
        return this;
    }

    public void setPublishingOptions(DQResultsPublishingOptions publishingOptions) {
        this.publishingOptions = publishingOptions;
    }

    public DQResultsPublishingOptions getPublishingOptions() {
        return this.publishingOptions;
    }

    public EvaluateDataQualityMultiFrame withPublishingOptions(DQResultsPublishingOptions publishingOptions) {
        this.setPublishingOptions(publishingOptions);
        return this;
    }

    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(Map<String, String> additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public EvaluateDataQualityMultiFrame withAdditionalOptions(Map<String, String> additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public EvaluateDataQualityMultiFrame addAdditionalOptionsEntry(String key, String value) {
        if (null == this.additionalOptions) {
            this.additionalOptions = new HashMap<String, String>();
        }
        if (this.additionalOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalOptions.put(key, value);
        return this;
    }

    public EvaluateDataQualityMultiFrame clearAdditionalOptionsEntries() {
        this.additionalOptions = null;
        return this;
    }

    public void setStopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions) {
        this.stopJobOnFailureOptions = stopJobOnFailureOptions;
    }

    public DQStopJobOnFailureOptions getStopJobOnFailureOptions() {
        return this.stopJobOnFailureOptions;
    }

    public EvaluateDataQualityMultiFrame withStopJobOnFailureOptions(DQStopJobOnFailureOptions stopJobOnFailureOptions) {
        this.setStopJobOnFailureOptions(stopJobOnFailureOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getAdditionalDataSources() != null) {
            sb.append("AdditionalDataSources: ").append(this.getAdditionalDataSources()).append(",");
        }
        if (this.getRuleset() != null) {
            sb.append("Ruleset: ").append(this.getRuleset()).append(",");
        }
        if (this.getPublishingOptions() != null) {
            sb.append("PublishingOptions: ").append(this.getPublishingOptions()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getStopJobOnFailureOptions() != null) {
            sb.append("StopJobOnFailureOptions: ").append(this.getStopJobOnFailureOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateDataQualityMultiFrame)) {
            return false;
        }
        EvaluateDataQualityMultiFrame other = (EvaluateDataQualityMultiFrame)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getAdditionalDataSources() == null ^ this.getAdditionalDataSources() == null) {
            return false;
        }
        if (other.getAdditionalDataSources() != null && !other.getAdditionalDataSources().equals(this.getAdditionalDataSources())) {
            return false;
        }
        if (other.getRuleset() == null ^ this.getRuleset() == null) {
            return false;
        }
        if (other.getRuleset() != null && !other.getRuleset().equals(this.getRuleset())) {
            return false;
        }
        if (other.getPublishingOptions() == null ^ this.getPublishingOptions() == null) {
            return false;
        }
        if (other.getPublishingOptions() != null && !other.getPublishingOptions().equals(this.getPublishingOptions())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getStopJobOnFailureOptions() == null ^ this.getStopJobOnFailureOptions() == null) {
            return false;
        }
        return other.getStopJobOnFailureOptions() == null || other.getStopJobOnFailureOptions().equals(this.getStopJobOnFailureOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalDataSources() == null ? 0 : this.getAdditionalDataSources().hashCode());
        hashCode = 31 * hashCode + (this.getRuleset() == null ? 0 : this.getRuleset().hashCode());
        hashCode = 31 * hashCode + (this.getPublishingOptions() == null ? 0 : this.getPublishingOptions().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getStopJobOnFailureOptions() == null ? 0 : this.getStopJobOnFailureOptions().hashCode());
        return hashCode;
    }

    public EvaluateDataQualityMultiFrame clone() {
        try {
            return (EvaluateDataQualityMultiFrame)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluateDataQualityMultiFrameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

