/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;
import java.io.IOException;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.io.api.Binary;

public class BinaryDictionary
implements Dictionary {
    private final Binary[] content;

    public BinaryDictionary(DictionaryPage dictionaryPage) throws IOException {
        this(dictionaryPage, null);
    }

    public BinaryDictionary(DictionaryPage dictionaryPage, Integer length) throws IOException {
        this.content = new Binary[dictionaryPage.getDictionarySize()];
        Slice dictionarySlice = dictionaryPage.getSlice();
        byte[] dictionaryBytes = dictionarySlice.byteArray();
        int offset = dictionarySlice.byteArrayOffset();
        if (length == null) {
            for (int i = 0; i < this.content.length; ++i) {
                int len = BytesUtils.readIntLittleEndian((byte[])dictionaryBytes, (int)offset);
                this.content[i] = Binary.fromReusedByteArray((byte[])dictionaryBytes, (int)(offset += 4), (int)len);
                offset += len;
            }
        } else {
            Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (String)"Invalid byte array length: %s", (Object)length);
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = Binary.fromReusedByteArray((byte[])dictionaryBytes, (int)offset, (int)length);
                offset += length.intValue();
            }
        }
    }

    @Override
    public Binary decodeToBinary(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

